/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKArrayAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKAssignmentChainAlsoLink;
import org.jetbrains.kotlin.nj2k.tree.JKAssignmentChainLetLink;
import org.jetbrains.kotlin.nj2k.tree.JKBinaryExpression;
import org.jetbrains.kotlin.nj2k.tree.JKBlockImpl;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKDelegationConstructorCall;
import org.jetbrains.kotlin.nj2k.tree.JKDoWhileStatement;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKExpressionStatement;
import org.jetbrains.kotlin.nj2k.tree.JKField;
import org.jetbrains.kotlin.nj2k.tree.JKForInStatement;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKIfElseExpression;
import org.jetbrains.kotlin.nj2k.tree.JKIfElseStatement;
import org.jetbrains.kotlin.nj2k.tree.JKIsExpression;
import org.jetbrains.kotlin.nj2k.tree.JKKtAssignmentStatement;
import org.jetbrains.kotlin.nj2k.tree.JKKtWhenCase;
import org.jetbrains.kotlin.nj2k.tree.JKKtWordOperatorToken;
import org.jetbrains.kotlin.nj2k.tree.JKLabeledExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLambdaExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLocalVariable;
import org.jetbrains.kotlin.nj2k.tree.JKMethodReferenceExpression;
import org.jetbrains.kotlin.nj2k.tree.JKOperatorToken;
import org.jetbrains.kotlin.nj2k.tree.JKParenthesizedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKPostfixExpression;
import org.jetbrains.kotlin.nj2k.tree.JKPrefixExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKReturnStatement;
import org.jetbrains.kotlin.nj2k.tree.JKSuperExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.tree.JKWhileStatement;
import org.jetbrains.kotlin.nj2k.tree.TreeUtilsKt;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/RemoveUnnecessaryParenthesesConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "KaSession", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;)Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "areParenthesesNecessary", "", "expression", "Lorg/jetbrains/kotlin/nj2k/tree/JKParenthesizedExpression;", "getPriority", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKElement;", "kotlin.j2k.shared"})
public final class RemoveUnnecessaryParenthesesConversion
extends RecursiveConversion {
    public RemoveUnnecessaryParenthesesConversion(@NotNull ConverterContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull KaSession $context_receiver_0, @NotNull JKTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKParenthesizedExpression)) {
            return this.recurse($context_receiver_0, element);
        }
        if (this.areParenthesesNecessary((JKParenthesizedExpression)element)) {
            return this.recurse($context_receiver_0, element);
        }
        return this.recurse($context_receiver_0, (JKTreeElement)FormattingKt.withFormattingFrom((JKFormattingOwner)TreeUtilsKt.detached((KProperty0)new MutablePropertyReference0Impl(element){

            public Object get() {
                return ((JKParenthesizedExpression)this.receiver).getExpression();
            }

            public void set(Object value) {
                ((JKParenthesizedExpression)this.receiver).setExpression((JKExpression)value);
            }
        }), (JKFormattingOwner)element));
    }

    private final boolean areParenthesesNecessary(JKParenthesizedExpression expression) {
        int parentPriority;
        JKExpression innerExpression = expression.getExpression();
        JKElement parent2 = expression.getParent();
        if (parent2 instanceof JKKtAssignmentStatement && Intrinsics.areEqual((Object)((JKKtAssignmentStatement)parent2).getField(), (Object)expression) || parent2 instanceof JKAssignmentChainLetLink && Intrinsics.areEqual((Object)((JKAssignmentChainLetLink)parent2).getReceiver(), (Object)expression)) {
            return false;
        }
        if (expression.getShouldBePreserved()) {
            return true;
        }
        if (parent2 == null) {
            return true;
        }
        if (innerExpression instanceof JKParenthesizedExpression || parent2 instanceof JKParenthesizedExpression) {
            return false;
        }
        if (parent2 instanceof JKIfElseExpression && ((JKIfElseExpression)parent2).getCondition() == expression || parent2 instanceof JKIfElseStatement && ((JKIfElseStatement)parent2).getCondition() == expression || parent2 instanceof JKWhileStatement && ((JKWhileStatement)parent2).getCondition() == expression || parent2 instanceof JKDoWhileStatement && ((JKDoWhileStatement)parent2).getCondition() == expression || parent2 instanceof JKArgument) {
            return false;
        }
        if (innerExpression instanceof JKBinaryExpression && ExpressionsKt.recursivelyContainsNewlineBeforeOperator((JKBinaryExpression)innerExpression)) {
            return true;
        }
        if (parent2 instanceof JKDelegationConstructorCall || parent2 instanceof JKKtWhenCase || parent2 instanceof JKReturnStatement) {
            return false;
        }
        if (parent2 instanceof JKQualifiedExpression && Intrinsics.areEqual((Object)((JKQualifiedExpression)parent2).getReceiver(), (Object)expression) || parent2 instanceof JKAssignmentChainAlsoLink && Intrinsics.areEqual((Object)((JKAssignmentChainAlsoLink)parent2).getReceiver(), (Object)expression)) {
            return !ExpressionsKt.isAtomic(innerExpression);
        }
        if (parent2 instanceof JKForInStatement && Intrinsics.areEqual((Object)((JKForInStatement)parent2).getIterationExpression(), (Object)expression)) {
            return false;
        }
        if (parent2 instanceof JKIsExpression && Intrinsics.areEqual((Object)((JKIsExpression)parent2).getExpression(), (Object)expression)) {
            return false;
        }
        JKElement grandparent = parent2.getParent();
        if (parent2 instanceof JKExpressionStatement && (grandparent instanceof JKLambdaExpression || grandparent instanceof JKBlockImpl)) {
            return false;
        }
        if (parent2 instanceof JKLocalVariable && Intrinsics.areEqual((Object)((JKLocalVariable)parent2).getInitializer(), (Object)expression) || parent2 instanceof JKField && Intrinsics.areEqual((Object)((JKField)parent2).getInitializer(), (Object)expression) || parent2 instanceof JKKtAssignmentStatement && Intrinsics.areEqual((Object)((JKKtAssignmentStatement)parent2).getExpression(), (Object)expression)) {
            return false;
        }
        if (parent2 instanceof JKPrefixExpression || parent2 instanceof JKPostfixExpression) {
            return !ExpressionsKt.isAtomic(innerExpression);
        }
        int innerPriority = this.getPriority(innerExpression);
        if (innerPriority == (parentPriority = this.getPriority(parent2))) {
            if (!(parent2 instanceof JKBinaryExpression)) {
                return false;
            }
            if (innerExpression instanceof JKBinaryExpression && (Intrinsics.areEqual((Object)((JKBinaryExpression)innerExpression).getOperator().getToken(), (Object)JKOperatorToken.Companion.getANDAND()) || Intrinsics.areEqual((Object)((JKBinaryExpression)innerExpression).getOperator().getToken(), (Object)JKOperatorToken.Companion.getOROR()))) {
                return false;
            }
            return Intrinsics.areEqual((Object)((JKBinaryExpression)parent2).getRight(), (Object)expression);
        }
        return innerPriority < parentPriority;
    }

    private final int getPriority(JKElement expression) {
        if (expression instanceof JKSuperExpression) {
            return KtPsiUtil.MAX_PRIORITY;
        }
        if (expression instanceof JKPostfixExpression || expression instanceof JKQualifiedExpression || expression instanceof JKCallExpression || expression instanceof JKMethodReferenceExpression || expression instanceof JKArrayAccessExpression) {
            return KtPsiUtil.MAX_PRIORITY - 1;
        }
        if (expression instanceof JKPrefixExpression || expression instanceof JKLabeledExpression || expression instanceof JKIfElseExpression) {
            return KtPsiUtil.MAX_PRIORITY - 2;
        }
        if (expression instanceof JKBinaryExpression) {
            KtToken binaryOperation;
            KotlinExpressionParsing.BinaryOperationPrecedence binaryOperationPrecedence;
            JKOperatorToken operatorToken = ((JKBinaryExpression)expression).getOperator().getToken();
            KtToken operatorElementType = JKOperatorToken.Companion.toKtElementType(operatorToken);
            Object object = operatorElementType;
            if (object == null) {
                object = operatorToken instanceof JKKtWordOperatorToken ? KtTokens.IDENTIFIER : null;
            }
            if ((binaryOperationPrecedence = (KotlinExpressionParsing.BinaryOperationPrecedence)KotlinExpressionParsing.TOKEN_TO_BINARY_PRECEDENCE_MAP.get(binaryOperation = object)) != null) {
                return KtPsiUtil.MAX_PRIORITY - 3 - binaryOperationPrecedence.ordinal();
            }
        }
        return KtPsiUtil.MAX_PRIORITY;
    }
}

