/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.codeinsight;

import com.intellij.openapi.util.Pair;
import com.intellij.tasks.jira.jql.codeinsight.JqlFieldType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum JqlStandardFunction {
    RELEASED_VERSIONS("releasedVersions", JqlFieldType.VERSION, true),
    LATEST_RELEASED_VERSION("latestReleasedVersion", JqlFieldType.VERSION, false),
    UNRELEASED_VERSIONS("unreleasedVersions", JqlFieldType.VERSION, true),
    EARLIEST_UNRELEASED_VERSION("earliestUnreleasedVersion", JqlFieldType.VERSION, false),
    MEMBERS_OF("membersOf", JqlFieldType.USER, true),
    CURRENT_USER("currentUser", JqlFieldType.USER, false),
    COMPONENTS_LEAD_BY_USER("componentsLeadByUser", JqlFieldType.COMPONENT, true),
    CURRENT_LOGIN("currentLogin", JqlFieldType.DATE, false),
    LAST_LOGIN("lastLogin", JqlFieldType.DATE, false),
    NOW("now", JqlFieldType.DATE, false),
    START_OF_DAY("startOfDay", JqlFieldType.DATE, false),
    START_OF_WEEK("startOfWeek", JqlFieldType.DATE, false),
    START_OF_MONTH("startOfMonth", JqlFieldType.DATE, false),
    START_OF_YEAR("startOfYear", JqlFieldType.DATE, false),
    END_OF_DAY("endOfDay", JqlFieldType.DATE, false),
    END_OF_WEEK("endOfWeek", JqlFieldType.DATE, false),
    END_OF_MONTH("endOfMonth", JqlFieldType.DATE, false),
    END_OF_YEAR("endOfYear", JqlFieldType.DATE, false),
    ISSUE_HISTORY("issueHistory", JqlFieldType.ISSUE, true),
    LINKED_ISSUES("linkedIssues", JqlFieldType.ISSUE, true),
    VOTED_ISSUES("votedIssues", JqlFieldType.ISSUE, true),
    WATCHED_ISSUES("watchedIssues", JqlFieldType.ISSUE, true),
    PROJECTS_LEAD_BY_USER("projectsLeadByUser", JqlFieldType.PROJECT, true),
    PROJECTS_WHERE_USER_HAS_PERMISSION("projectsWhereUserHasPermission", JqlFieldType.PROJECT, true),
    PROJECTS_WHERE_USER_HAS_ROLE("projectsWhereUserHasRole", null, true);

    private final String myName;
    private final JqlFieldType myReturnType;
    private final boolean myHasMultipleResults;
    private static final JqlStandardFunction[] VALUES;
    private static final Map<String, JqlStandardFunction> NAME_LOOKUP;
    private static final MultiMap<Pair<JqlFieldType, Boolean>, String> TYPE_LOOKUP;
    public static final List<String> ALL_FUNCTION_NAMES;

    private JqlStandardFunction(String name, JqlFieldType returnType, boolean hasMultipleResults) {
        this.myName = name;
        this.myReturnType = returnType;
        this.myHasMultipleResults = hasMultipleResults;
    }

    public String getName() {
        return this.myName;
    }

    public JqlFieldType getReturnType() {
        return this.myReturnType;
    }

    public boolean hasMultipleResults() {
        return this.myHasMultipleResults;
    }

    public static JqlStandardFunction byName(@NotNull String name) {
        if (name == null) {
            JqlStandardFunction.$$$reportNull$$$0(0);
        }
        return NAME_LOOKUP.get(name);
    }

    public static List<String> allOfType(@NotNull JqlFieldType type, boolean multipleResults) {
        if (type == null) {
            JqlStandardFunction.$$$reportNull$$$0(1);
        }
        if (type == JqlFieldType.UNKNOWN) {
            return ALL_FUNCTION_NAMES;
        }
        return new ArrayList<String>(TYPE_LOOKUP.get((Object)Pair.create((Object)((Object)type), (Object)multipleResults)));
    }

    static {
        VALUES = JqlStandardFunction.values();
        NAME_LOOKUP = ContainerUtil.newMapFromValues((Iterator)ContainerUtil.iterate((Object[])VALUES), field -> field.getName());
        TYPE_LOOKUP = new MultiMap();
        for (JqlStandardFunction function : VALUES) {
            TYPE_LOOKUP.putValue((Object)Pair.create((Object)((Object)function.getReturnType()), (Object)function.hasMultipleResults()), (Object)function.getName());
        }
        ALL_FUNCTION_NAMES = ContainerUtil.map((Object[])VALUES, field -> field.myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/jira/jql/codeinsight/JqlStandardFunction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "byName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "allOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

