/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.monitor.Context;
import org.assertj.swing.monitor.ContextMonitor;
import org.assertj.swing.monitor.WindowAvailabilityMonitor;
import org.assertj.swing.monitor.WindowStatus;
import org.assertj.swing.monitor.Windows;
import org.assertj.swing.util.ToolkitProvider;

public class WindowMonitor {
    private final Context context;
    private final ContextMonitor contextMonitor;
    private final Windows windows;
    private final WindowStatus windowStatus;
    private final WindowAvailabilityMonitor windowAvailabilityMonitor;

    @RunsInCurrentThread
    WindowMonitor(@Nonnull Toolkit toolkit) {
        this(toolkit, new Context(toolkit), new WindowStatus(new Windows()));
    }

    @VisibleForTesting
    @RunsInCurrentThread
    WindowMonitor(@Nonnull Toolkit toolkit, @Nonnull Context context, @Nonnull WindowStatus windowStatus) {
        this.context = context;
        this.windowStatus = windowStatus;
        this.windows = windowStatus.windows();
        this.contextMonitor = new ContextMonitor(context, this.windows);
        this.contextMonitor.attachTo(toolkit);
        this.windowAvailabilityMonitor = new WindowAvailabilityMonitor(this.windows);
        this.windowAvailabilityMonitor.attachTo(toolkit);
        this.populateExistingWindows();
    }

    private void populateExistingWindows() {
        for (Frame f : Frame.getFrames()) {
            this.examine((Window)Preconditions.checkNotNull((Object)f));
        }
    }

    @RunsInCurrentThread
    private void examine(@Nonnull Window w) {
        this.windows.attachNewWindowVisibilityMonitor(w);
        for (Window owned : w.getOwnedWindows()) {
            this.examine((Window)Preconditions.checkNotNull((Object)owned));
        }
        this.windows.markExisting(w);
        this.context.addContextFor(w);
    }

    public boolean isWindowReady(@Nonnull Window w) {
        if (this.windows.isReady(w)) {
            return true;
        }
        this.windowStatus.checkIfReady(w);
        return false;
    }

    @Nullable
    public EventQueue eventQueueFor(@Nonnull Component c) {
        return this.context.eventQueueFor(c);
    }

    @Nonnull
    public Collection<EventQueue> allEventQueues() {
        return this.context.allEventQueues();
    }

    @Nonnull
    public Collection<Window> rootWindows() {
        return this.context.rootWindows();
    }

    @Nonnull
    @RunsInEDT
    public static WindowMonitor instance() {
        return SingletonLazyLoader.INSTANCE;
    }

    @RunsInEDT
    private static class SingletonLazyLoader {
        static final WindowMonitor INSTANCE = GuiActionRunner.execute(new GuiQuery<WindowMonitor>(){

            @Override
            protected WindowMonitor executeInEDT() {
                return new WindowMonitor(ToolkitProvider.instance().defaultToolkit());
            }
        });

        private SingletonLazyLoader() {
        }
    }
}

