/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DocumentUpdaterWithComputeOnBG;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.HookUpVirtualFileProvider;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.UpdateActionWithComputeOnBG;
import com.intellij.database.datagrid.UpdateSessionCloser;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.run.ui.grid.MoveColumnsRequestPlace;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EdtInvocationManager;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DocumentDataHookUp
extends GridDataHookUpBase<GridRow, GridColumn>
implements Disposable,
HookUpVirtualFileProvider {
    private final Document myDocument;
    private TextRange myRange;
    private DataMarkup myCurrentMarkup;
    private final DataGridListModel myModel;
    private final GridStorageAndModelUpdater myModelUpdater;
    private final GridMutationModel myMutationModel;
    private final GridPagingModel<GridRow, GridColumn> myPageModel;
    private final DocumentDataLoader myLoader;
    private final DocumentDataMutator myMutator;
    private final CoroutineScope cs;
    private final MyDocumentListener myDocumentListener;

    protected DocumentDataHookUp(@NotNull Project project, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            DocumentDataHookUp.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentDataHookUp.$$$reportNull$$$0(1);
        }
        super(project);
        this.cs = CoroutineScopeKt.childScope((CoroutineScope)GlobalScope.INSTANCE, (String)this.getClass().getName(), (CoroutineContext)Dispatchers.getIO(), (boolean)true);
        this.myDocument = document;
        this.myRange = range;
        this.myModel = new DataGridListModel(GridCellEditorHelper::areValuesEqual);
        this.myMutationModel = new GridMutationModel(this);
        this.myModelUpdater = new GridStorageAndModelUpdater(this.myModel, this.myMutationModel, null);
        this.myPageModel = new GridPagingModelImpl.SinglePage<GridRow, GridColumn>(this.myMutationModel);
        this.myLoader = new DocumentDataLoader();
        Disposer.register((Disposable)this, (Disposable)this.myLoader);
        this.myMutator = this.createDataMutator();
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener, (Disposable)this);
    }

    @NotNull
    protected DocumentDataMutator createDataMutator() {
        return new DocumentDataMutator();
    }

    @TestOnly
    public void awaitParsingFinished() {
        this.myLoader.awaitParsingFinished();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DocumentDataHookUp.$$$reportNull$$$0(2);
        }
        return document;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return FileDocumentManager.getInstance().getFile(this.myDocument);
    }

    @Override
    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DocumentDataHookUp.$$$reportNull$$$0(3);
        }
        return dataGridListModel;
    }

    @Override
    @NotNull
    public GridModel<GridRow, GridColumn> getMutationModel() {
        GridMutationModel gridMutationModel = this.myMutationModel;
        if (gridMutationModel == null) {
            DocumentDataHookUp.$$$reportNull$$$0(4);
        }
        return gridMutationModel;
    }

    @Override
    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        GridPagingModel<GridRow, GridColumn> gridPagingModel = this.myPageModel;
        if (gridPagingModel == null) {
            DocumentDataHookUp.$$$reportNull$$$0(5);
        }
        return gridPagingModel;
    }

    @Override
    @NotNull
    public GridLoader getLoader() {
        DocumentDataLoader documentDataLoader = this.myLoader;
        if (documentDataLoader == null) {
            DocumentDataHookUp.$$$reportNull$$$0(6);
        }
        return documentDataLoader;
    }

    @Override
    @Nullable
    public GridMutator<GridRow, GridColumn> getMutator() {
        return this.myMutator;
    }

    @Override
    public boolean isReadOnly() {
        return !this.myDocument.isWritable();
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.cs, (String)"Disposed", null);
    }

    @Nullable
    public TextRange getRange() {
        return this.myRange;
    }

    @Nullable
    protected abstract DataMarkup buildMarkup(@NotNull CharSequence var1, @NotNull GridRequestSource var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DocumentDataHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private class DocumentDataLoader
    implements GridLoader,
    Disposable {
        private final Logger LOG = Logger.getInstance(DocumentDataLoader.class);
        private final ThreadPoolExecutor myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)this.getClass().getSimpleName());
        private Future<?> myLastExtractorTask = null;

        private DocumentDataLoader() {
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(0);
            }
            this.load(source, 0);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(1);
            }
            this.load(source, 0);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(2);
            }
            this.load(source, 0);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(3);
            }
            this.load(source, 0);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(4);
            }
            this.load(source, 0);
        }

        @Override
        public void load(@NotNull GridRequestSource source, int offset) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(5);
            }
            try {
                this.doLoadData(source);
            }
            catch (Exception e) {
                DocumentDataHookUp.this.notifyRequestError(source, SimpleErrorInfo.create(e));
            }
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(6);
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilterAndSorting(@NotNull GridRequestSource source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(7);
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void updateIsTotalRowCountUpdateable() {
        }

        private void doLoadData(@NotNull GridRequestSource source) {
            CharSequence sequence;
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(8);
            }
            CharSequence charSequence = sequence = DocumentDataHookUp.this.myRange != null ? DocumentDataHookUp.this.myRange.subSequence(DocumentDataHookUp.this.myDocument.getCharsSequence()) : DocumentDataHookUp.this.myDocument.getCharsSequence();
            if (this.myLastExtractorTask != null) {
                this.myLastExtractorTask.cancel(false);
            }
            ModalityState state = ModalityState.current();
            this.myLastExtractorTask = this.myExecutor.submit(() -> {
                DataMarkup markup = DocumentDataHookUp.this.buildMarkup(sequence, source);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (markup == null) {
                        DocumentDataHookUp.this.myModelUpdater.removeRows(0, DocumentDataHookUp.this.myModel.getRowCount());
                        DocumentDataHookUp.this.myModelUpdater.setColumns(ContainerUtil.emptyList());
                        DocumentDataHookUp.this.myCurrentMarkup = null;
                        DocumentDataHookUp.this.notifyRequestFinished(source, false);
                        return;
                    }
                    List<GridColumn> columns = markup.columns;
                    List<GridRow> rows = markup.rows;
                    if (!DocumentDataLoader.sameColumns(columns, DocumentDataHookUp.this.myModel.getColumns()) || source.place instanceof MoveColumnsRequestPlace) {
                        DocumentDataHookUp.this.myModelUpdater.removeRows(0, DocumentDataHookUp.this.myModel.getRowCount());
                        DocumentDataHookUp.this.myModelUpdater.setColumns(columns);
                        DocumentDataHookUp.this.myModelUpdater.addRows(rows);
                        GridRequestSource.RequestPlace patt23550$temp = source.place;
                        if (patt23550$temp instanceof MoveColumnsRequestPlace) {
                            MoveColumnsRequestPlace info = (MoveColumnsRequestPlace)patt23550$temp;
                            info.adjustColumnsUI();
                        }
                    } else {
                        int oldRowCount = DocumentDataHookUp.this.myModel.getRowCount();
                        int newRowCount = rows.size();
                        DocumentDataHookUp.this.myModelUpdater.setRows(0, rows, source);
                        if (oldRowCount > newRowCount) {
                            DocumentDataHookUp.this.myModelUpdater.removeRows(newRowCount, oldRowCount - newRowCount);
                        }
                    }
                    DocumentDataHookUp.this.myCurrentMarkup = markup;
                    DocumentDataHookUp.this.notifyRequestFinished(source, true);
                }, state);
            });
        }

        private static boolean sameColumns(List<GridColumn> columns1, List<GridColumn> columns2) {
            if (columns1.size() != columns2.size()) {
                return false;
            }
            for (int i = 0; i < columns1.size(); ++i) {
                if (Comparing.equal((Object)columns1.get(i), (Object)columns2.get(i))) continue;
                return false;
            }
            return true;
        }

        public void awaitParsingFinished() {
            if (this.myLastExtractorTask == null) {
                return;
            }
            try {
                this.myLastExtractorTask.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.LOG.error("DocumentDataLoader task termination interrupted", (Throwable)e);
            }
        }

        public void dispose() {
            this.myExecutor.shutdown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reloadCurrentPage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadNextPage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadPreviousPage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadLastPage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFirstPage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateTotalRowCount";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilterAndSorting";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doLoadData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class DocumentDataMutator
    implements GridMutator.RowsMutator<GridRow, GridColumn>,
    GridMutator.ColumnsMutator<GridRow, GridColumn> {
        protected DocumentDataMutator() {
        }

        @Override
        public boolean hasUnparsedValues() {
            return false;
        }

        @Override
        public void deleteRows(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridRow> rows) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(0);
            }
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(1);
            }
            final List<GridRow> rowsToDelete = DocumentDataMutator.sortedRows(DocumentDataHookUp.this.myModel.getRows(rows));
            if (DocumentDataHookUp.this.isReadOnly() || rowsToDelete.isEmpty()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.deleteRows(session, rowsToDelete);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$1", "perform"));
                }
            });
        }

        @Override
        public void insertRows(@NotNull GridRequestSource source, int amount) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(2);
            }
            if (DocumentDataHookUp.this.isReadOnly()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            for (int i = 0; i < amount; ++i) {
                this.updateDocument(source, new UpdateAction(){

                    @Override
                    public boolean perform(@NotNull UpdateSession session) {
                        if (session == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return DocumentDataHookUp.this.myCurrentMarkup.insertRow(session);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$2", "perform"));
                    }
                });
            }
        }

        @Override
        public void cloneRow(@NotNull GridRequestSource source, @NotNull ModelIndex<GridRow> toClone) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(3);
            }
            if (toClone == null) {
                DocumentDataMutator.$$$reportNull$$$0(4);
            }
            final GridRow row = DocumentDataHookUp.this.myModel.getRow(toClone);
            if (DocumentDataHookUp.this.isReadOnly() || row == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.cloneRow(session, row);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$3", "perform"));
                }
            });
        }

        @Override
        public boolean isDeletedRow(@NotNull ModelIndex<GridRow> row) {
            if (row == null) {
                DocumentDataMutator.$$$reportNull$$$0(5);
            }
            return false;
        }

        @Override
        public boolean isDeletedRows(@NotNull ModelIndexSet<GridRow> rows) {
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(6);
            }
            return false;
        }

        @Override
        public boolean isInsertedRow(@NotNull ModelIndex<GridRow> row) {
            if (row == null) {
                DocumentDataMutator.$$$reportNull$$$0(7);
            }
            return false;
        }

        @Override
        public boolean isDeletedColumn(@NotNull ModelIndex<GridColumn> idx) {
            if (idx == null) {
                DocumentDataMutator.$$$reportNull$$$0(8);
            }
            return false;
        }

        @Override
        public int getInsertedRowsCount() {
            return 0;
        }

        @Override
        public int getInsertedColumnsCount() {
            return 0;
        }

        @Override
        public void deleteColumns(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridColumn> columns) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(9);
            }
            if (columns == null) {
                DocumentDataMutator.$$$reportNull$$$0(10);
            }
            final List<GridColumn> columnsToDelete = DocumentDataMutator.sortedColumns(DocumentDataHookUp.this.myModel.getColumns(columns));
            if (DocumentDataHookUp.this.isReadOnly() || columnsToDelete.isEmpty()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.deleteColumns(session, columnsToDelete);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$4", "perform"));
                }
            });
        }

        @Override
        public void insertColumn(@NotNull GridRequestSource source, final @Nullable String name) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(11);
            }
            if (DocumentDataHookUp.this.isReadOnly()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.insertColumn(session, name);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$5", "perform"));
                }
            });
        }

        @Override
        public void moveColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<GridColumn> from, final @NotNull ModelIndex<GridColumn> to) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(12);
            }
            if (from == null) {
                DocumentDataMutator.$$$reportNull$$$0(13);
            }
            if (to == null) {
                DocumentDataMutator.$$$reportNull$$$0(14);
            }
            final GridColumn fromColumn = DocumentDataHookUp.this.myModel.getColumn(from);
            if (DocumentDataHookUp.this.isReadOnly() || fromColumn == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocumentWithComputeOnBG(source, new UpdateActionWithComputeOnBG<String>(){

                @Override
                public boolean performUpdate(@NotNull UpdateSession session, String data) {
                    if (session == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    DocumentDataHookUp.this.myDocument.setText((CharSequence)data);
                    return true;
                }

                @Override
                public String prepareData() {
                    return DocumentDataHookUp.this.myCurrentMarkup.prepareMoveColumn(fromColumn, to);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$6", "performUpdate"));
                }
            });
        }

        @Override
        public void cloneColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<GridColumn> toClone) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(15);
            }
            if (toClone == null) {
                DocumentDataMutator.$$$reportNull$$$0(16);
            }
            final GridColumn column = DocumentDataHookUp.this.myModel.getColumn(toClone);
            if (DocumentDataHookUp.this.isReadOnly() || column == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.cloneColumn(session, column);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$7", "perform"));
                }
            });
        }

        @Override
        @NotNull
        public ModelIndex<GridRow> getLastInsertedRow() {
            ModelIndex<GridRow> modelIndex = ModelIndex.forRow(DocumentDataHookUp.this.myModel, -1);
            if (modelIndex == null) {
                DocumentDataMutator.$$$reportNull$$$0(17);
            }
            return modelIndex;
        }

        @Override
        @NotNull
        public ModelIndexSet<GridRow> getAffectedRows() {
            ModelIndexSet<GridRow> modelIndexSet = ModelIndexSet.forRows(DocumentDataHookUp.this.myModel, -1);
            if (modelIndexSet == null) {
                DocumentDataMutator.$$$reportNull$$$0(18);
            }
            return modelIndexSet;
        }

        @Override
        @NotNull
        public JBIterable<ModelIndex<GridRow>> getInsertedRows() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DocumentDataMutator.$$$reportNull$$$0(19);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public JBIterable<ModelIndex<GridColumn>> getInsertedColumns() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DocumentDataMutator.$$$reportNull$$$0(20);
            }
            return jBIterable;
        }

        @Override
        public boolean isInsertedColumn(@NotNull ModelIndex<GridColumn> idx) {
            if (idx == null) {
                DocumentDataMutator.$$$reportNull$$$0(21);
            }
            return false;
        }

        @Override
        @Nullable
        public GridColumn getInsertedColumn(@NotNull ModelIndex<GridColumn> idx) {
            if (idx == null) {
                DocumentDataMutator.$$$reportNull$$$0(22);
            }
            return null;
        }

        @Override
        public void renameColumn(@NotNull GridRequestSource source, final @NotNull ModelIndex<GridColumn> idx, final @NotNull String newName) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(23);
            }
            if (idx == null) {
                DocumentDataMutator.$$$reportNull$$$0(24);
            }
            if (newName == null) {
                DocumentDataMutator.$$$reportNull$$$0(25);
            }
            GridColumn column = DocumentDataHookUp.this.myModel.getColumn(idx);
            if (DocumentDataHookUp.this.isReadOnly() || column == null) {
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.renameColumn(session, idx, newName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$8", "perform"));
                }
            });
        }

        @Override
        public void mutate(@NotNull GridRequestSource source, @NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns, Object newValue, boolean allowImmediateUpdate) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(26);
            }
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(27);
            }
            if (columns == null) {
                DocumentDataMutator.$$$reportNull$$$0(28);
            }
            this.mutate(source, GridUtilCore.createMutations(rows, columns, newValue), allowImmediateUpdate);
        }

        @Override
        public void mutate(@NotNull GridRequestSource source, @NotNull List<CellMutation> mutations, boolean allowImmediateUpdate) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(29);
            }
            if (mutations == null) {
                DocumentDataMutator.$$$reportNull$$$0(30);
            }
            final List<RowMutation> rowMutations = GridUtilCore.mergeAll(mutations, DocumentDataHookUp.this.myModel);
            if (DocumentDataHookUp.this.isReadOnly() || mutations.isEmpty() || rowMutations.isEmpty() || DocumentDataHookUp.this.myModel.allValuesEqualTo(mutations)) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) {
                    if (session == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.update(session, rowMutations);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$9", "perform"));
                }
            });
        }

        @Override
        public boolean isUpdateSafe(@NotNull ModelIndexSet<GridRow> rowIndices, @NotNull ModelIndexSet<GridColumn> columnIndices, @Nullable Object newValue) {
            if (rowIndices == null) {
                DocumentDataMutator.$$$reportNull$$$0(31);
            }
            if (columnIndices == null) {
                DocumentDataMutator.$$$reportNull$$$0(32);
            }
            return true;
        }

        @Override
        public boolean hasPendingChanges() {
            return false;
        }

        @Override
        public boolean isUpdateImmediately() {
            return true;
        }

        private <T> void updateDocumentWithComputeOnBG(@NotNull GridRequestSource source, @NotNull UpdateActionWithComputeOnBG<T> action) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(33);
            }
            if (action == null) {
                DocumentDataMutator.$$$reportNull$$$0(34);
            }
            new DocumentUpdaterWithComputeOnBG().run(DocumentDataHookUp.this.cs, source, action, DocumentDataHookUp.this.myDocument, DocumentDataHookUp.this.myDocumentListener, DocumentDataHookUp.this, (Function0<UpdateSessionCloser>)((Function0)() -> new UpdateSessionCloser(this.createSession(), (Function2<? super UpdateSession, ? super Boolean, Unit>)((Function2)(session, success) -> {
                this.finishSession((UpdateSession)session, (boolean)success);
                return Unit.INSTANCE;
            }))));
        }

        private void updateDocument(@NotNull GridRequestSource source, @NotNull UpdateAction action) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(35);
            }
            if (action == null) {
                DocumentDataMutator.$$$reportNull$$$0(36);
            }
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)DocumentDataHookUp.this.getProject(), (Document)DocumentDataHookUp.this.myDocument)) {
                    DocumentDataHookUp.this.notifyRequestError(source, SimpleErrorInfo.create(DataGridBundle.message("cannot.update.document", new Object[0])));
                    DocumentDataHookUp.this.notifyRequestFinished(source, false);
                    return;
                }
                UpdateSession session = this.createSession();
                ThrowableComputable wrappedAction = () -> {
                    DocumentDataHookUp.this.myDocumentListener.muteChangeEvents();
                    Ref result = Ref.create((Object)false);
                    try {
                        DocumentUtil.executeInBulk((Document)DocumentDataHookUp.this.myDocument, () -> {
                            try {
                                boolean actionResult = action.perform(session);
                                result.set((Object)actionResult);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                        Boolean bl = (Boolean)result.get();
                        return bl;
                    }
                    finally {
                        DocumentDataHookUp.this.myDocumentListener.unmuteChangeEvents(source);
                    }
                };
                CommandProcessor.getInstance().executeCommand(DocumentDataHookUp.this.getProject(), () -> {
                    boolean success = false;
                    try {
                        success = (Boolean)ApplicationManager.getApplication().runWriteAction(wrappedAction);
                        this.finishSession(session, success);
                    }
                    catch (Exception e) {
                        DocumentDataHookUp.this.notifyRequestError(source, SimpleErrorInfo.create(e));
                    }
                    DocumentDataHookUp.this.notifyRequestFinished(source, success);
                }, DataGridBundle.message("command.name.update.values", new Object[0]), null);
            });
        }

        protected void finishSession(@NotNull UpdateSession session, boolean success) {
            if (session == null) {
                DocumentDataMutator.$$$reportNull$$$0(37);
            }
        }

        @NotNull
        protected UpdateSession createSession() {
            return new UpdateSession(DocumentDataHookUp.this.myDocument, DocumentDataHookUp.this.myRange != null ? DocumentDataHookUp.this.myRange.getStartOffset() : 0);
        }

        private static List<GridColumn> sortedColumns(@NotNull List<GridColumn> columns) {
            if (columns == null) {
                DocumentDataMutator.$$$reportNull$$$0(38);
            }
            return ContainerUtil.sorted(columns, Comparator.comparingInt(column -> column.getColumnNumber()));
        }

        private static List<GridRow> sortedRows(@NotNull List<GridRow> rows) {
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(39);
            }
            return ContainerUtil.sorted(rows, Comparator.comparingInt(row -> row.getRowNum()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 17, 18, 19, 20 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 6: 
                case 27: 
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 4: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toClone";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 8: 
                case 21: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idx";
                    break;
                }
                case 10: 
                case 28: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutations";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIndices";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIndices";
                    break;
                }
                case 34: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastInsertedRow";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedRows";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertedRows";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertedColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "insertRows";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneRow";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isDeletedRow";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isDeletedRows";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsertedRow";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isDeletedColumn";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumns";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "insertColumn";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "moveColumn";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneColumn";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsertedColumn";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getInsertedColumn";
                    break;
                }
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "renameColumn";
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "mutate";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "isUpdateSafe";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "updateDocumentWithComputeOnBG";
                    break;
                }
                case 35: 
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "updateDocument";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "finishSession";
                    break;
                }
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "sortedColumns";
                    break;
                }
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "sortedRows";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 17, 18, 19, 20 -> new IllegalStateException(string);
            };
        }
    }

    public class MyDocumentListener
    implements DocumentListener {
        private boolean myMuteChangeEvents;
        private boolean myChangesOccurredWhileMuted;

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            this.adjustRange(event);
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (this.myMuteChangeEvents) {
                this.myChangesOccurredWhileMuted = true;
            } else {
                this.reload(new GridRequestSource(null));
            }
        }

        public void muteChangeEvents() {
            this.myMuteChangeEvents = true;
            this.myChangesOccurredWhileMuted = false;
        }

        public void unmuteChangeEvents(@NotNull GridRequestSource source) {
            if (source == null) {
                MyDocumentListener.$$$reportNull$$$0(2);
            }
            this.myMuteChangeEvents = false;
            if (this.myChangesOccurredWhileMuted) {
                this.reload(source);
            }
        }

        private void reload(@NotNull GridRequestSource source) {
            if (source == null) {
                MyDocumentListener.$$$reportNull$$$0(3);
            }
            EdtInvocationManager.invokeLaterIfNeeded(() -> {
                if (!DocumentDataHookUp.this.myMutationModel.hasListeners()) {
                    return;
                }
                DocumentDataHookUp.this.myLoader.doLoadData(source);
            });
        }

        private void adjustRange(DocumentEvent e) {
            if (DocumentDataHookUp.this.myRange == null) {
                return;
            }
            int lengthDelta = e.getNewLength() - e.getOldLength();
            if (DocumentDataHookUp.this.myRange.containsRange(e.getOffset(), e.getOffset() + e.getOldLength())) {
                DocumentDataHookUp.this.myRange = new TextRange(DocumentDataHookUp.this.myRange.getStartOffset(), DocumentDataHookUp.this.myRange.getEndOffset() + lengthDelta);
            } else if (DocumentDataHookUp.this.myRange.getStartOffset() > e.getOffset() + e.getOldLength()) {
                DocumentDataHookUp.this.myRange = DocumentDataHookUp.this.myRange.shiftRight(lengthDelta);
            } else if (DocumentDataHookUp.this.myRange.intersects(e.getOffset(), e.getOffset() + e.getOldLength())) {
                int startOffset = Math.min(e.getOffset(), DocumentDataHookUp.this.myRange.getStartOffset());
                int endOffset = Math.max(e.getOffset() + e.getNewLength(), DocumentDataHookUp.this.myRange.getEndOffset() + lengthDelta);
                DocumentDataHookUp.this.myRange = new TextRange(startOffset, endOffset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unmuteChangeEvents";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reload";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface UpdateAction {
        public boolean perform(@NotNull UpdateSession var1) throws Exception;
    }

    public static abstract class DataMarkup {
        public static final TypeMerger STRING_MERGER = new TypeMerger.StringMerger("TEXT");
        public static final TypeMerger INTEGER_MERGER = new TypeMerger.IntegerMerger("INT");
        public static final TypeMerger BIG_INTEGER_MERGER = new TypeMerger.BigIntegerMerger("BIGINT");
        public static final TypeMerger DOUBLE_MERGER = new TypeMerger.DoubleMerger("DOUBLE");
        public static final TypeMerger BOOLEAN_MERGER = new TypeMerger.BooleanMerger("BOOLEAN");
        public final List<GridColumn> columns;
        public final List<GridRow> rows;

        public DataMarkup(@NotNull List<GridColumn> columns, @NotNull List<GridRow> rows) {
            if (columns == null) {
                DataMarkup.$$$reportNull$$$0(0);
            }
            if (rows == null) {
                DataMarkup.$$$reportNull$$$0(1);
            }
            this.columns = columns;
            this.rows = rows;
        }

        public static int getType(@NotNull TypeMerger merger) {
            if (merger == null) {
                DataMarkup.$$$reportNull$$$0(2);
            }
            return merger == INTEGER_MERGER ? 4 : (merger == DOUBLE_MERGER ? 8 : (merger == BIG_INTEGER_MERGER ? -5 : (merger == BOOLEAN_MERGER ? 16 : 12)));
        }

        public static String getClassName(@NotNull TypeMerger merger) {
            if (merger == null) {
                DataMarkup.$$$reportNull$$$0(3);
            }
            return merger == INTEGER_MERGER ? "java.lang.Integer" : (merger == DOUBLE_MERGER ? "java.lang.Double" : (merger == BIG_INTEGER_MERGER ? BigInteger.class.getName() : (merger == BOOLEAN_MERGER ? Boolean.class.getName() : "java.lang.String")));
        }

        protected abstract boolean deleteRows(@NotNull UpdateSession var1, @NotNull List<GridRow> var2);

        protected abstract boolean insertRow(@NotNull UpdateSession var1);

        protected abstract boolean cloneRow(@NotNull UpdateSession var1, @NotNull GridRow var2);

        protected abstract boolean deleteColumns(@NotNull UpdateSession var1, @NotNull List<GridColumn> var2);

        protected abstract boolean insertColumn(@NotNull UpdateSession var1, @Nullable String var2);

        protected abstract boolean cloneColumn(@NotNull UpdateSession var1, @NotNull GridColumn var2);

        protected abstract boolean update(@NotNull UpdateSession var1, @NotNull List<RowMutation> var2);

        protected abstract boolean renameColumn(@NotNull UpdateSession var1, @NotNull ModelIndex<GridColumn> var2, @NotNull String var3);

        protected String prepareMoveColumn(@NotNull GridColumn fromColumn, @NotNull ModelIndex<GridColumn> toColumn) {
            if (fromColumn == null) {
                DataMarkup.$$$reportNull$$$0(4);
            }
            if (toColumn == null) {
                DataMarkup.$$$reportNull$$$0(5);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "merger";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromColumn";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toColumn";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$DataMarkup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getClassName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareMoveColumn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpdateSession {
        private final Document myDocument;
        private int myRightShift;

        protected UpdateSession(@NotNull Document document, int rightShift) {
            if (document == null) {
                UpdateSession.$$$reportNull$$$0(0);
            }
            this.myDocument = document;
            this.myRightShift = rightShift;
        }

        public void insert(@NotNull CharSequence sequence, int atOffset) {
            if (sequence == null) {
                UpdateSession.$$$reportNull$$$0(1);
            }
            this.myDocument.insertString(atOffset + this.myRightShift, sequence);
            this.myRightShift += sequence.length();
        }

        public void replace(@NotNull TextRange range, @NotNull CharSequence sequence) {
            if (range == null) {
                UpdateSession.$$$reportNull$$$0(2);
            }
            if (sequence == null) {
                UpdateSession.$$$reportNull$$$0(3);
            }
            TextRange shifted = range.shiftRight(this.myRightShift);
            this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), sequence);
            this.myRightShift += sequence.length() - shifted.getLength();
        }

        public void delete(@NotNull TextRange range) {
            if (range == null) {
                UpdateSession.$$$reportNull$$$0(4);
            }
            TextRange shifted = range.shiftRight(this.myRightShift);
            this.myDocument.deleteString(shifted.getStartOffset(), shifted.getEndOffset());
            this.myRightShift -= range.getLength();
        }

        public char charAt(int offset) {
            return this.myDocument.getCharsSequence().charAt(offset + this.myRightShift);
        }

        public boolean isValidOffset(int offset) {
            int shifted = offset + this.myRightShift;
            return shifted >= 0 && shifted < this.myDocument.getTextLength();
        }

        @NotNull
        public String getText() {
            String string = this.myDocument.getText();
            if (string == null) {
                UpdateSession.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "delete";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

