/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShowDiffAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(0);
        }
        AbstractShowDiffAction.updateDiffAction(e.getPresentation(), e.getDataContext());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    protected static void updateDiffAction(@NotNull Presentation presentation, @NotNull DataContext context) {
        if (presentation == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(3);
        }
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(context, true));
        presentation.setVisible(AbstractShowDiffAction.isVisible(context));
    }

    protected static boolean isVisible(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(4);
        }
        return (project = (Project)context.getData(CommonDataKeys.PROJECT)) != null && AbstractShowDiffAction.hasDiffProviders(project);
    }

    private static boolean hasDiffProviders(@NotNull Project project) {
        if (project == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(5);
        }
        return Stream.of(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()).map(AbstractVcs::getDiffProvider).anyMatch(Predicates.nonNull());
    }

    protected static boolean isEnabled(@NotNull DataContext context, boolean disableIfRunning) {
        Project project;
        if (context == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(6);
        }
        if ((project = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        if (!AbstractShowDiffAction.isVisible(context)) {
            return false;
        }
        VirtualFile file = (VirtualFile)VcsContextUtil.selectedFilesIterable(context).single();
        if (file == null || file.isDirectory()) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        if (disableIfRunning && BackgroundableActionLock.isLocked(project, new Object[]{VcsBackgroundableActions.COMPARE_WITH, filePath})) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project);
        if (vcs == null || vcs.getDiffProvider() == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(7);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        VirtualFile file = VcsContextUtil.selectedFile(e.getDataContext());
        if (file == null) {
            return;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project);
        if (vcs == null) {
            return;
        }
        DiffProvider provider = vcs.getDiffProvider();
        if (provider == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        this.getExecutor(provider, file, project, editor).showDiff();
    }

    @NotNull
    protected abstract DiffActionExecutor getExecutor(@NotNull DiffProvider var1, @NotNull VirtualFile var2, @NotNull Project var3, @Nullable Editor var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AbstractShowDiffAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AbstractShowDiffAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasDiffProviders";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

