/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShowAnnotateOperationsPopup
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(0);
        }
        List<AnAction> actions = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
        e.getPresentation().setEnabled(actions != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<AnAction> actions;
        if (e == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(2);
        }
        if ((actions = ShowAnnotateOperationsPopup.getActions(e.getDataContext())) == null) {
            return;
        }
        String title = this.getTemplatePresentation().getText();
        DefaultActionGroup group = new DefaultActionGroup(actions);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(title, (ActionGroup)group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        popup.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    private static List<AnAction> getActions(@NotNull DataContext context) {
        Editor editor;
        if (context == null) {
            ShowAnnotateOperationsPopup.$$$reportNull$$$0(3);
        }
        if ((editor = (Editor)context.getData(CommonDataKeys.EDITOR)) == null) {
            return null;
        }
        TextAnnotationPresentation presentation = AnnotateToggleAction.getAnnotationPresentation(editor);
        if (presentation == null) {
            return null;
        }
        int line = editor.getCaretModel().getLogicalPosition().line;
        List actions = presentation.getActions(line);
        FileAnnotation fileAnnotation = AnnotateToggleAction.getFileAnnotation(editor);
        if (fileAnnotation != null) {
            int annotationLine = presentation.getAnnotationLine(line);
            actions = ContainerUtil.prepend(actions, (Object[])new AnAction[]{new ShowAffectedFilesAction(fileAnnotation, annotationLine)});
        }
        return (List)ContainerUtil.nullize(actions);
    }

    public static int getAnnotationLineNumber(@NonNls DataContext dataContext) {
        return ShowAnnotateOperationsPopup.getAnnotationLineNumber(dataContext, false);
    }

    public static int getAnnotationLineNumber(@NonNls DataContext dataContext, boolean approximate) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return -1;
        }
        TextAnnotationPresentation annotationPresentation = AnnotateToggleAction.getAnnotationPresentation(editor);
        if (annotationPresentation == null) {
            return -1;
        }
        Integer gutterLine = (Integer)dataContext.getData(EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR);
        int editorLine = gutterLine != null ? gutterLine : editor.getCaretModel().getLogicalPosition().line;
        return annotationPresentation.getAnnotationLine(editorLine, approximate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ShowAffectedFilesAction
    extends DumbAwareAction {
        private final FileAnnotation myFileAnnotation;
        private final int myLine;
        private final FileAnnotation.RevisionChangesProvider myChangesProvider;
        private final VcsRevisionNumber myRevisionNumber;
        private final VirtualFile myFile;

        private ShowAffectedFilesAction(@NotNull FileAnnotation fileAnnotation, int line) {
            if (fileAnnotation == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(0);
            }
            super(VcsBundle.messagePointer((String)"action.ShowAffectedFilesAction.show.affected.files.text", (Object[])new Object[0]), AllIcons.Actions.ListChanges);
            this.myFileAnnotation = fileAnnotation;
            this.myLine = line;
            this.myChangesProvider = fileAnnotation.getRevisionsChangesProvider();
            this.myRevisionNumber = fileAnnotation.getLineRevisionNumber(this.myLine);
            this.myFile = fileAnnotation.getFile();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(2);
            }
            boolean visible = this.myChangesProvider != null && this.myFile != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && this.myRevisionNumber != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAffectedFilesAction.$$$reportNull$$$0(3);
            }
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
            AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(this.myFileAnnotation.getProject(), this.myRevisionNumber, filePath, () -> this.myChangesProvider.getChangesIn(this.myLine));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAnnotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup$ShowAffectedFilesAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup$ShowAffectedFilesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class Group
    extends ActionGroup
    implements DumbAware {
        public Group() {
            this.getTemplatePresentation().setHideGroupIfEmpty(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    Group.$$$reportNull$$$0(0);
                }
                return AnAction.EMPTY_ARRAY;
            }
            List<AnAction> actions = ShowAnnotateOperationsPopup.getActions(e.getDataContext());
            AnAction[] anActionArray = actions != null ? actions.toArray(AnAction.EMPTY_ARRAY) : AnAction.EMPTY_ARRAY;
            if (anActionArray == null) {
                Group.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/ShowAnnotateOperationsPopup$Group", "getChildren"));
        }
    }
}

