/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRevision
implements ByteBackedContentRevision {
    private static final Logger LOG = Logger.getInstance(FakeRevision.class);
    private final Project myProject;
    private final FilePath myFile;
    private final boolean myCurrentRevision;

    @Deprecated
    public FakeRevision(@NotNull Project project, @NotNull FilePath file) {
        if (project == null) {
            FakeRevision.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FakeRevision.$$$reportNull$$$0(1);
        }
        this(project, file, false);
    }

    public FakeRevision(@NotNull Project project, @NotNull FilePath file, boolean isCurrentRevision) {
        if (project == null) {
            FakeRevision.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FakeRevision.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myFile = file;
        this.myCurrentRevision = isCurrentRevision;
    }

    public byte @Nullable [] getContentAsBytes() throws VcsException {
        ContentRevision revision = this.createDelegateContentRevision();
        if (revision == null) {
            return null;
        }
        return ChangesUtil.loadContentRevision((ContentRevision)revision);
    }

    @Nullable
    public String getContent() throws VcsException {
        ContentRevision revision = this.createDelegateContentRevision();
        if (revision == null) {
            return null;
        }
        return revision.getContent();
    }

    @Nullable
    private ContentRevision createDelegateContentRevision() {
        DiffProvider diffProvider;
        if (LOG.isDebugEnabled()) {
            LOG.debug("FakeRevision queried for " + this.myFile.getPath() + (this.myCurrentRevision ? " (current)" : ""), new Throwable());
        }
        if (this.myCurrentRevision) {
            return new CurrentContentRevision(this.myFile);
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile);
        DiffProvider diffProvider2 = diffProvider = vcs != null ? vcs.getDiffProvider() : null;
        if (diffProvider == null) {
            return null;
        }
        ContentRevision delegateContent = diffProvider.createCurrentFileContent(virtualFile);
        if (delegateContent == null) {
            return null;
        }
        return delegateContent;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            FakeRevision.$$$reportNull$$$0(4);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
        if (vcsRevisionNumber == null) {
            FakeRevision.$$$reportNull$$$0(5);
        }
        return vcsRevisionNumber;
    }

    public String toString() {
        return "FakeRevision:" + this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/FakeRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/FakeRevision";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

