/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

@ApiStatus.Internal
public final class RelativePathCalculator {
    private static final int MAX_STEPS_UP = 3;
    private static final int MAX_STEPS_DOWN = 4;

    private static boolean stringEqual(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            RelativePathCalculator.$$$reportNull$$$0(0);
        }
        if (s2 == null) {
            RelativePathCalculator.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isFileSystemCaseSensitive) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    @Contract(value="_, _, false -> !null")
    @NlsSafe
    public static @SystemIndependent String computeRelativePath(@NotNull @SystemIndependent String base, @NotNull @SystemIndependent String shifted, boolean relativePathsOnly) {
        int i;
        if (base == null) {
            RelativePathCalculator.$$$reportNull$$$0(2);
        }
        if (shifted == null) {
            RelativePathCalculator.$$$reportNull$$$0(3);
        }
        if (RelativePathCalculator.stringEqual(shifted, base)) {
            return ".";
        }
        String[] baseParts = base.split("/");
        String[] shiftedParts = shifted.split("/");
        int cnt = 0;
        while (true) {
            if (baseParts.length <= cnt || shiftedParts.length <= cnt) {
                --cnt;
                break;
            }
            if (!RelativePathCalculator.stringEqual(baseParts[cnt], shiftedParts[cnt])) break;
            ++cnt;
        }
        int stepsUp = baseParts.length - cnt - 1;
        int stepsDown = shiftedParts.length - cnt - 1;
        if (stepsDown > 4) {
            return relativePathsOnly ? null : shifted;
        }
        StringBuilder sb = new StringBuilder();
        if (stepsUp < 3) {
            for (i = 0; i < stepsUp; ++i) {
                sb.append("../");
            }
        } else {
            sb.append("\u2026/");
        }
        for (i = cnt; i < shiftedParts.length - 1; ++i) {
            String shiftedPart = shiftedParts[i];
            sb.append(shiftedPart);
            sb.append('/');
        }
        String oldName = baseParts[baseParts.length - 1];
        String newName = shiftedParts[shiftedParts.length - 1];
        boolean skipFileName = oldName.equals(newName);
        if (!skipFileName) {
            sb.append(newName);
        }
        return sb.toString();
    }

    public static String[] split(@NotNull String s) {
        if (s == null) {
            RelativePathCalculator.$$$reportNull$$$0(4);
        }
        return s.replace(File.separatorChar, '/').split("/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shifted";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/RelativePathCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stringEqual";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeRelativePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "split";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

