/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.DefaultInclusionModel;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class LocalChangesBrowser
extends AsyncChangesBrowserBase
implements Disposable {
    @NotNull
    private final ToggleChangeDiffAction myToggleChangeDiffAction;

    public LocalChangesBrowser(@NotNull Project project) {
        if (project == null) {
            LocalChangesBrowser.$$$reportNull$$$0(0);
        }
        super(project, true, true);
        this.myToggleChangeDiffAction = new ToggleChangeDiffAction();
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.myViewer.setInclusionModel(new DefaultInclusionModel((HashingStrategy<Object>)ChangeListChange.HASHING_STRATEGY));
    }

    public void dispose() {
        this.shutdown();
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        List list = ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{this.myToggleChangeDiffAction});
        if (list == null) {
            LocalChangesBrowser.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setIncludedChangesBy(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            LocalChangesBrowser.$$$reportNull$$$0(2);
        }
        ArrayList<? extends Change> changesToInclude = new ArrayList<Change>(changes);
        HashSet<Change> otherChanges = new HashSet<Change>();
        for (Change change : changes) {
            if (change instanceof ChangeListChange) continue;
            otherChanges.add(change);
        }
        if (!otherChanges.isEmpty()) {
            for (Change change : this.getAllChanges()) {
                if (!(change instanceof ChangeListChange) || !otherChanges.contains(change)) continue;
                changesToInclude.add((Change)change);
            }
        }
        this.myViewer.setIncludedChanges(changesToInclude);
    }

    public List<Change> getAllChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
    }

    public void setToggleActionTitle(@NlsActions.ActionText @Nullable String title) {
        this.myToggleChangeDiffAction.getTemplatePresentation().setText(title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedChangesBy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class ToggleChangeDiffAction
    extends CheckboxAction
    implements DumbAware {
        ToggleChangeDiffAction() {
            super(VcsBundle.message((String)"checkbox.include", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Change change;
            if (e == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(1);
            }
            if ((change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                return false;
            }
            return LocalChangesBrowser.this.myViewer.isIncluded(change);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Change change;
            if (e == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(2);
            }
            if ((change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                return;
            }
            if (state) {
                LocalChangesBrowser.this.myViewer.includeChange(change);
                LocalChangesBrowser.this.myViewer.logInclusionToggleEvents(false, e);
            } else {
                LocalChangesBrowser.this.myViewer.excludeChange(change);
                LocalChangesBrowser.this.myViewer.logInclusionToggleEvents(true, e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$ToggleChangeDiffAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$ToggleChangeDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;

        private MyChangeListListener() {
            this.myUpdateQueue = new MergingUpdateQueue("LocalChangesViewer", 300, true, (JComponent)LocalChangesBrowser.this, (Disposable)LocalChangesBrowser.this);
        }

        private void doUpdate() {
            this.myUpdateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this.myUpdateQueue, (Object)"update", () -> LocalChangesBrowser.this.myViewer.rebuildTree()));
        }

        public void changeListsChanged() {
            this.doUpdate();
        }
    }

    public static class AllChanges
    extends LocalChangesBrowser {
        public AllChanges(@NotNull Project project) {
            if (project == null) {
                AllChanges.$$$reportNull$$$0(0);
            }
            super(project);
            this.myViewer.rebuildTree();
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> {
                Collection allChanges = ChangeListManager.getInstance((Project)this.myProject).getAllChanges();
                return TreeModelBuilder.buildFromChanges(this.myProject, grouping, allChanges, null);
            });
            if (asyncChangesTreeModel == null) {
                AllChanges.$$$reportNull$$$0(1);
            }
            return asyncChangesTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$AllChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$AllChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class SelectedChangeLists
    extends LocalChangesBrowser {
        @NotNull
        private final Set<String> myChangeListNames;

        public SelectedChangeLists(@NotNull Project project, @NotNull Collection<? extends LocalChangeList> changeLists) {
            if (project == null) {
                SelectedChangeLists.$$$reportNull$$$0(0);
            }
            if (changeLists == null) {
                SelectedChangeLists.$$$reportNull$$$0(1);
            }
            super(project);
            this.myChangeListNames = ContainerUtil.map2Set(changeLists, LocalChangeList::getName);
            this.myViewer.rebuildTree();
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> {
                List allLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
                List selectedLists = ContainerUtil.filter((Collection)allLists, list -> this.myChangeListNames.contains(list.getName()));
                return TreeModelBuilder.buildFromChangeLists(this.myProject, grouping, selectedLists, Registry.is((String)"vcs.skip.single.default.changelist"));
            });
            if (asyncChangesTreeModel == null) {
                SelectedChangeLists.$$$reportNull$$$0(2);
            }
            return asyncChangesTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$SelectedChangeLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$SelectedChangeLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class NonEmptyChangeLists
    extends LocalChangesBrowser {
        public NonEmptyChangeLists(@NotNull Project project) {
            if (project == null) {
                NonEmptyChangeLists.$$$reportNull$$$0(0);
            }
            super(project);
            this.myViewer.rebuildTree();
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> {
                List allLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
                List selectedLists = ContainerUtil.filter((Collection)allLists, list -> !list.getChanges().isEmpty());
                return TreeModelBuilder.buildFromChangeLists(this.myProject, grouping, selectedLists, Registry.is((String)"vcs.skip.single.default.changelist"));
            });
            if (asyncChangesTreeModel == null) {
                NonEmptyChangeLists.$$$reportNull$$$0(1);
            }
            return asyncChangesTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$NonEmptyChangeLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$NonEmptyChangeLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

