/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultVcsRootChecker
extends VcsRootChecker {
    @NotNull
    private final AbstractVcs myVcs;
    @Nullable
    private final VcsDescriptor myVcsDescriptor;

    DefaultVcsRootChecker(@NotNull AbstractVcs vcs, @Nullable VcsDescriptor vcsDescriptor) {
        if (vcs == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myVcsDescriptor = vcsDescriptor;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = this.myVcs.getKeyInstanceMethod();
        if (vcsKey == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(1);
        }
        return vcsKey;
    }

    public boolean isRoot(@NotNull VirtualFile file) {
        if (file == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(2);
        }
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.probablyUnderVcs(file);
    }

    public boolean validateRoot(@NotNull VirtualFile file) {
        if (file == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean isVcsDir(@NotNull String dirName) {
        if (dirName == null) {
            DefaultVcsRootChecker.$$$reportNull$$$0(4);
        }
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.matchesVcsDirPattern(dirName);
    }

    public boolean areChildrenValidMappings() {
        if (this.myVcsDescriptor == null) {
            return false;
        }
        return this.myVcsDescriptor.areChildrenValidMappings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/DefaultVcsRootChecker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/DefaultVcsRootChecker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVcsDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

