/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.util.paths;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.util.paths.FilePathHashUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RootDirtySet {
    private static final Logger LOG = Logger.getInstance(RootDirtySet.class);
    private static final int FOLDER_SIZE_THRESHOLD = 30;
    private static final int DIRTY_SCOPE_SIZE_THRESHOLD = 50000;
    @NotNull
    @NonNls
    private final String myRoot;
    private final boolean myCaseSensitive;
    private final Set<@NonNls String> myPaths;
    private final IntSet myPathHashSet;
    private final Int2IntMap myPathHashCounters;
    private boolean myEverythingDirty;

    public RootDirtySet(@NotNull FilePath root, boolean caseSensitive) {
        if (root == null) {
            RootDirtySet.$$$reportNull$$$0(0);
        }
        this(root.getPath(), caseSensitive);
    }

    private RootDirtySet(@NotNull String root, boolean caseSensitive) {
        if (root == null) {
            RootDirtySet.$$$reportNull$$$0(1);
        }
        this.myPathHashSet = new IntOpenHashSet();
        this.myPathHashCounters = new Int2IntOpenHashMap();
        this.myRoot = root;
        this.myCaseSensitive = caseSensitive;
        this.myPaths = caseSensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
    }

    public void markDirty(@NotNull FilePath filePath) {
        if (filePath == null) {
            RootDirtySet.$$$reportNull$$$0(2);
        }
        if (this.myEverythingDirty) {
            return;
        }
        String path = filePath.getPath();
        if (RootDirtySet.getParentPrefixOf(path, this.myRoot, this.myCaseSensitive) != -1) {
            this.markEverythingDirty();
            return;
        }
        int startIndex = RootDirtySet.getParentPrefixOf(this.myRoot, path, this.myCaseSensitive);
        if (startIndex == -1) {
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.error(new Throwable(String.format("Invalid dirty path for root %s: %s", this.myRoot, path)));
            } else {
                LOG.warn(new Throwable(String.format("Invalid dirty path for root %s: %s", this.myRoot, path)));
            }
            this.markEverythingDirty();
            return;
        }
        this.markDirtyRelative(path, startIndex);
    }

    private void markDirtyRelative(@NotNull String path, int startIndex) {
        if (path == null) {
            RootDirtySet.$$$reportNull$$$0(3);
        }
        if (this.myPaths.size() > 50000) {
            this.markEverythingDirty();
            return;
        }
        int index = startIndex;
        int previousPrefixHash = 0;
        IntArrayList prefixHashes = new IntArrayList();
        prefixHashes.add(0);
        int prevCounter = this.myPathHashCounters.get(0);
        boolean needCutOff = false;
        while (index < path.length()) {
            boolean addParentFolder;
            String prefix;
            int prefixHash;
            int nextIndex = path.indexOf(47, index + 1);
            if (nextIndex == -1) {
                nextIndex = path.length();
            }
            if (this.myPathHashSet.contains(prefixHash = FilePathHashUtil.pathHashCode(this.myCaseSensitive, path, index, nextIndex, previousPrefixHash)) && this.myPaths.contains(prefix = path.substring(startIndex, nextIndex))) {
                return;
            }
            int counter = this.myPathHashCounters.get(prefixHash);
            boolean bl = addParentFolder = needCutOff && counter < prevCounter || prevCounter - counter > 30;
            if (counter < 30 && prevCounter >= 30) {
                needCutOff = true;
            }
            if (addParentFolder) {
                if (startIndex == index) {
                    this.markEverythingDirty();
                    return;
                }
                this.myPaths.add(path.substring(startIndex, index));
                this.myPathHashSet.add(previousPrefixHash);
                for (int i = 0; i < prefixHashes.size(); ++i) {
                    int hash = prefixHashes.getInt(i);
                    this.myPathHashCounters.mergeInt(hash, 1 - prevCounter, (val1, val2) -> Math.max(val1 + val2, 1));
                }
                return;
            }
            if (counter < prevCounter) {
                prevCounter = counter;
            }
            prefixHashes.add(prefixHash);
            previousPrefixHash = prefixHash;
            index = nextIndex;
        }
        this.myPaths.add(path.substring(startIndex, index));
        this.myPathHashSet.add(previousPrefixHash);
        for (int i = 0; i < prefixHashes.size(); ++i) {
            int hash = prefixHashes.getInt(i);
            this.myPathHashCounters.mergeInt(hash, 1, (val1, val2) -> val1 + val2);
        }
    }

    public boolean belongsTo(@NotNull FilePath filePath) {
        String path;
        int startIndex;
        if (filePath == null) {
            RootDirtySet.$$$reportNull$$$0(4);
        }
        if ((startIndex = RootDirtySet.getParentPrefixOf(this.myRoot, path = filePath.getPath(), this.myCaseSensitive)) == -1) {
            return false;
        }
        if (this.myEverythingDirty) {
            return true;
        }
        if (path.length() == this.myRoot.length()) {
            return false;
        }
        int index = startIndex;
        int lastPrefixHash = 0;
        while (index < path.length()) {
            String prefix;
            int prefixHash;
            int nextIndex = path.indexOf(47, index + 1);
            if (nextIndex == -1) {
                nextIndex = path.length();
            }
            if (this.myPathHashSet.contains(prefixHash = FilePathHashUtil.pathHashCode(this.myCaseSensitive, path, index, nextIndex, lastPrefixHash)) && this.myPaths.contains(prefix = path.substring(startIndex, nextIndex))) {
                return true;
            }
            index = nextIndex;
            lastPrefixHash = prefixHash;
        }
        return false;
    }

    public void markEverythingDirty() {
        this.myPaths.clear();
        this.myPathHashSet.clear();
        this.myPathHashCounters.clear();
        this.myEverythingDirty = true;
    }

    public boolean isEmpty() {
        return !this.myEverythingDirty && this.myPathHashCounters.isEmpty();
    }

    public boolean isEverythingDirty() {
        return this.myEverythingDirty;
    }

    @NotNull
    public List<FilePath> collectFilePaths() {
        if (this.myEverythingDirty) {
            List<FilePath> list = Collections.singletonList(VcsUtil.getFilePath((String)this.myRoot, (boolean)true));
            if (list == null) {
                RootDirtySet.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> result2 = RootDirtySet.removeCommonParents(this.myPaths, this.myCaseSensitive);
        List list = ContainerUtil.map(result2, path -> VcsUtil.getFilePath((String)(this.myRoot + "/" + path), (boolean)true));
        if (list == null) {
            RootDirtySet.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public RootDirtySet copy() {
        RootDirtySet copy = new RootDirtySet(this.myRoot, this.myCaseSensitive);
        if (this.myEverythingDirty) {
            copy.markEverythingDirty();
        } else {
            for (String filePath : this.myPaths) {
                copy.markDirtyRelative(filePath, 0);
            }
        }
        RootDirtySet rootDirtySet = copy;
        if (rootDirtySet == null) {
            RootDirtySet.$$$reportNull$$$0(7);
        }
        return rootDirtySet;
    }

    @NotNull
    public RootDirtySet compact() {
        RootDirtySet copy = new RootDirtySet(this.myRoot, this.myCaseSensitive);
        if (this.myEverythingDirty) {
            copy.markEverythingDirty();
        } else {
            for (String filePath : RootDirtySet.removeCommonParents(this.myPaths, this.myCaseSensitive)) {
                copy.markDirtyRelative(filePath, 0);
            }
        }
        RootDirtySet rootDirtySet = copy;
        if (rootDirtySet == null) {
            RootDirtySet.$$$reportNull$$$0(8);
        }
        return rootDirtySet;
    }

    @NotNull
    private static List<String> removeCommonParents(@NotNull Collection<String> paths, boolean caseSensitive) {
        if (paths == null) {
            RootDirtySet.$$$reportNull$$$0(9);
        }
        ArrayList<String> sortedPaths = new ArrayList<String>(paths);
        sortedPaths.sort(null);
        String prevPath = null;
        Iterator it = sortedPaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (prevPath != null && FileUtil.startsWith((String)path, (String)prevPath, (boolean)caseSensitive)) {
                it.remove();
                continue;
            }
            prevPath = path;
        }
        ArrayList<String> arrayList = sortedPaths;
        if (arrayList == null) {
            RootDirtySet.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static int getParentPrefixOf(@NotNull String ancestor, @NotNull String path, boolean caseSensitive) {
        if (ancestor == null) {
            RootDirtySet.$$$reportNull$$$0(11);
        }
        if (path == null) {
            RootDirtySet.$$$reportNull$$$0(12);
        }
        if (caseSensitive ? !path.startsWith(ancestor) : !StringUtil.startsWithIgnoreCase((String)path, (String)ancestor)) {
            return -1;
        }
        if (ancestor.length() == path.length() || path.charAt(ancestor.length()) == '/') {
            return ancestor.length() + 1;
        }
        if (!ancestor.isEmpty() && ancestor.charAt(ancestor.length() - 1) == '/') {
            return ancestor.length();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/util/paths/RootDirtySet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/util/paths/RootDirtySet";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilePaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "compact";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markDirty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyRelative";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "belongsTo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonParents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParentPrefixOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }
}

