/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class I18nUtil {
    @NotNull
    public static List<PropertiesFile> propertiesFilesByBundleName(@Nullable String resourceBundleName, @NotNull PsiElement context) {
        Project project;
        Module module;
        VirtualFile virtualFile;
        if (context == null) {
            I18nUtil.$$$reportNull$$$0(0);
        }
        if (resourceBundleName == null) {
            List<PropertiesFile> list = Collections.emptyList();
            if (list == null) {
                I18nUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiFile containingFile = context.getContainingFile();
        PsiLanguageInjectionHost containingFileContext = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
        if (containingFileContext != null) {
            containingFile = containingFileContext.getContainingFile();
        }
        if ((virtualFile = containingFile.getVirtualFile()) == null) {
            virtualFile = containingFile.getOriginalFile().getVirtualFile();
        }
        if (virtualFile != null && (module = ProjectRootManager.getInstance((Project)(project = containingFile.getProject())).getFileIndex().getModuleForFile(virtualFile)) != null) {
            PropertiesReferenceManager refManager = PropertiesReferenceManager.getInstance(project);
            List<PropertiesFile> list = refManager.findPropertiesFiles(module, resourceBundleName);
            if (list == null) {
                I18nUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PropertiesFile> list = Collections.emptyList();
        if (list == null) {
            I18nUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static void createProperty(@NotNull Project project, @NotNull Collection<? extends PropertiesFile> propertiesFiles, @NotNull String key, @NotNull String value) throws IncorrectOperationException {
        if (project == null) {
            I18nUtil.$$$reportNull$$$0(4);
        }
        if (propertiesFiles == null) {
            I18nUtil.$$$reportNull$$$0(5);
        }
        if (key == null) {
            I18nUtil.$$$reportNull$$$0(6);
        }
        if (value == null) {
            I18nUtil.$$$reportNull$$$0(7);
        }
        I18nUtil.createProperty(project, propertiesFiles, key, value, false);
    }

    public static void createProperty(@NotNull Project project, @NotNull Collection<? extends PropertiesFile> propertiesFiles, @NotNull String key, @NotNull String value, boolean replaceIfExist) throws IncorrectOperationException {
        if (project == null) {
            I18nUtil.$$$reportNull$$$0(8);
        }
        if (propertiesFiles == null) {
            I18nUtil.$$$reportNull$$$0(9);
        }
        if (key == null) {
            I18nUtil.$$$reportNull$$$0(10);
        }
        if (value == null) {
            I18nUtil.$$$reportNull$$$0(11);
        }
        for (PropertiesFile propertiesFile : propertiesFiles) {
            IProperty existingProperty;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(propertiesFile.getContainingFile());
            if (document != null) {
                documentManager.commitDocument(document);
            }
            if ((existingProperty = propertiesFile.findPropertyByKey(key)) == null) {
                propertiesFile.addProperty(key, value, PropertyKeyValueFormat.MEMORY);
                continue;
            }
            if (!replaceIfExist) continue;
            existingProperty.setValue(value, PropertyKeyValueFormat.MEMORY);
        }
    }

    @NotNull
    public static List<String> defaultSuggestPropertiesFiles(@NotNull Project project, @NotNull Set<? extends Module> contextModules) {
        if (project == null) {
            I18nUtil.$$$reportNull$$$0(12);
        }
        if (contextModules == null) {
            I18nUtil.$$$reportNull$$$0(13);
        }
        ArrayList<String> relevantPaths = new ArrayList<String>();
        ArrayList otherPaths = new ArrayList();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PropertiesFileProcessor processor = (baseName, propertiesFile) -> {
            if (propertiesFile instanceof XmlPropertiesFile) {
                return true;
            }
            VirtualFile virtualFile = propertiesFile.getVirtualFile();
            if (projectFileIndex.isInContent(virtualFile)) {
                String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                boolean relevant = contextModules.contains(module);
                (relevant ? relevantPaths : otherPaths).add(path);
            }
            return true;
        };
        if (contextModules.isEmpty()) {
            PropertiesReferenceManager.getInstance(project).processAllPropertiesFiles(processor);
        } else {
            GlobalSearchScope scope = GlobalSearchScope.union((Collection)ContainerUtil.map(contextModules, Module::getModuleWithDependenciesScope));
            PropertiesReferenceManager.getInstance(project).processPropertiesFiles(scope, processor, BundleNameEvaluator.DEFAULT);
        }
        Collections.sort(relevantPaths);
        Collections.sort(otherPaths);
        relevantPaths.addAll(otherPaths);
        ArrayList<String> arrayList = relevantPaths;
        if (arrayList == null) {
            I18nUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/I18nUtil";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFiles";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/I18nUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesFilesByBundleName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSuggestPropertiesFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "propertiesFilesByBundleName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defaultSuggestPropertiesFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 14 -> new IllegalStateException(string);
        };
    }
}

