/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.dynatrace.hash4j.hashing.HashSink;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetHashSupplier;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.builders.java.FilteredResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FileHashUtil;
import org.jetbrains.jps.incremental.JVMModuleBuildTarget;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;

public final class ResourcesTarget
extends JVMModuleBuildTarget<ResourceRootDescriptor>
implements BuildTargetHashSupplier {
    @NotNull
    private final ResourcesTargetType targetType;

    public ResourcesTarget(@NotNull JpsModule module, @NotNull ResourcesTargetType targetType) {
        if (module == null) {
            ResourcesTarget.$$$reportNull$$$0(0);
        }
        if (targetType == null) {
            ResourcesTarget.$$$reportNull$$$0(1);
        }
        super(targetType, module);
        this.targetType = targetType;
    }

    @Nullable
    public File getOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.targetType.isTests());
    }

    @Override
    @NotNull
    public Collection<File> getOutputRoots(@NotNull CompileContext context) {
        File element;
        if (context == null) {
            ResourcesTarget.$$$reportNull$$$0(2);
        }
        List<Object> list = (element = this.getOutputDir()) == null ? List.of() : List.of(element);
        if (list == null) {
            ResourcesTarget.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public boolean isTests() {
        return this.targetType.isTests();
    }

    @Override
    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    @Override
    @NotNull
    public Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        if (targetRegistry == null) {
            ResourcesTarget.$$$reportNull$$$0(4);
        }
        if (outputIndex == null) {
            ResourcesTarget.$$$reportNull$$$0(5);
        }
        List<BuildTarget<?>> list = List.of();
        if (list == null) {
            ResourcesTarget.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<ResourceRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        Path rootFile;
        if (model == null) {
            ResourcesTarget.$$$reportNull$$$0(7);
        }
        if (index == null) {
            ResourcesTarget.$$$reportNull$$$0(8);
        }
        if (ignoredFileIndex == null) {
            ResourcesTarget.$$$reportNull$$$0(9);
        }
        if (dataPaths == null) {
            ResourcesTarget.$$$reportNull$$$0(10);
        }
        ArrayList<ResourceRootDescriptor> roots = new ArrayList<ResourceRootDescriptor>();
        JavaSourceRootType type = this.isTests() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        Iterable excludedRootProviders = JpsServiceManager.getInstance().getExtensions(ExcludedJavaSourceRootProvider.class);
        FileFilter filterForExcludedPatterns = index.getModuleFileFilterHonorExclusionPatterns(this.myModule);
        for (JpsTypedModuleSourceRoot sourceRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)type)) {
            if (this.isExcludedFromCompilation(excludedRootProviders, (JpsModuleSourceRoot)sourceRoot)) continue;
            String packagePrefix = ((JavaSourceRootProperties)sourceRoot.getProperties()).getPackagePrefix();
            rootFile = sourceRoot.getPath();
            roots.add(new FilteredResourceRootDescriptor(rootFile.toFile(), this, packagePrefix, this.computeRootExcludes(rootFile, index), filterForExcludedPatterns));
        }
        JavaResourceRootType resourceType = this.isTests() ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
        for (JpsTypedModuleSourceRoot root : this.myModule.getSourceRoots((JpsModuleSourceRootType)resourceType)) {
            if (this.isExcludedFromCompilation(excludedRootProviders, (JpsModuleSourceRoot)root)) continue;
            rootFile = root.getPath();
            String relativeOutputPath = ((JavaResourceRootProperties)root.getProperties()).getRelativeOutputPath();
            roots.add(new ResourceRootDescriptor(rootFile.toFile(), this, relativeOutputPath.replace('/', '.'), this.computeRootExcludes(rootFile, index), filterForExcludedPatterns));
        }
        ArrayList<ResourceRootDescriptor> arrayList = roots;
        if (arrayList == null) {
            ResourcesTarget.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private boolean isExcludedFromCompilation(Iterable<ExcludedJavaSourceRootProvider> excludedRootProviders, JpsModuleSourceRoot sourceRoot) {
        for (ExcludedJavaSourceRootProvider provider : excludedRootProviders) {
            if (!provider.isExcludedFromCompilation(this.myModule, sourceRoot)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "Resources for '" + this.getModule().getName() + "' " + (this.targetType.isTests() ? "tests" : "production");
        if (string == null) {
            ResourcesTarget.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @ApiStatus.Internal
    public void computeConfigurationDigest(@NotNull ProjectDescriptor projectDescriptor, @NotNull HashSink hash) {
        if (projectDescriptor == null) {
            ResourcesTarget.$$$reportNull$$$0(13);
        }
        if (hash == null) {
            ResourcesTarget.$$$reportNull$$$0(14);
        }
        PathRelativizerService relativizer = projectDescriptor.dataManager.getRelativizer();
        List<ResourceRootDescriptor> roots = projectDescriptor.getBuildRootIndex().getTargetRoots(this, null);
        for (ResourceRootDescriptor root : roots) {
            String path = relativizer.toRelative(root.rootFile.toString());
            FileHashUtil.computePathHashCode(path, hash);
            hash.putString(root.getPackagePrefix());
        }
        hash.putInt(roots.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/ResourcesTarget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/ResourcesTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutputRoots";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeDependencies";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeRootDescriptors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeConfigurationDigest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

