/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.fus;

import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0006\u0010&\u001a\u00020\u0007J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J\t\u0010*\u001a\u00020\tH\u00c6\u0003J\t\u0010+\u001a\u00020\u000bH\u00c6\u0003J\t\u0010,\u001a\u00020\rH\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003JU\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0001J\u0013\u0010/\u001a\u00020\u00072\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%\u00a8\u00064"}, d2={"Lcom/intellij/grazie/ide/fus/AcceptanceRateTracker;", "", "rule", "Lcom/intellij/grazie/text/Rule;", "domain", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "isCommitMessage", "", "programmingLanguage", "Lcom/intellij/lang/Language;", "textLanguage", "Lai/grazie/nlp/langs/Language;", "filepath", "", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/grazie/text/Rule;Lcom/intellij/grazie/text/TextContent$TextDomain;ZLcom/intellij/lang/Language;Lai/grazie/nlp/langs/Language;Ljava/lang/String;Ljava/util/List;)V", "problem", "Lcom/intellij/grazie/text/TextProblem;", "(Lcom/intellij/grazie/text/TextProblem;)V", "getRule", "()Lcom/intellij/grazie/text/Rule;", "getDomain", "()Lcom/intellij/grazie/text/TextContent$TextDomain;", "()Z", "getProgrammingLanguage", "()Lcom/intellij/lang/Language;", "getTextLanguage", "()Lai/grazie/nlp/langs/Language;", "getFilepath", "()Ljava/lang/String;", "getRanges", "()Ljava/util/List;", "shown", "Lkotlin/concurrent/atomics/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "markShown", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "intellij.grazie.core"})
public final class AcceptanceRateTracker {
    @NotNull
    private final Rule rule;
    @NotNull
    private final TextContent.TextDomain domain;
    private final boolean isCommitMessage;
    @NotNull
    private final Language programmingLanguage;
    @NotNull
    private final ai.grazie.nlp.langs.Language textLanguage;
    @NotNull
    private final String filepath;
    @NotNull
    private final List<TextRange> ranges;
    @NotNull
    private final AtomicBoolean shown;

    public AcceptanceRateTracker(@NotNull Rule rule, @NotNull TextContent.TextDomain domain, boolean isCommitMessage, @NotNull Language programmingLanguage, @NotNull ai.grazie.nlp.langs.Language textLanguage, @NotNull String filepath, @NotNull List<? extends TextRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
        Intrinsics.checkNotNullParameter((Object)programmingLanguage, (String)"programmingLanguage");
        Intrinsics.checkNotNullParameter((Object)textLanguage, (String)"textLanguage");
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.rule = rule;
        this.domain = domain;
        this.isCommitMessage = isCommitMessage;
        this.programmingLanguage = programmingLanguage;
        this.textLanguage = textLanguage;
        this.filepath = filepath;
        this.ranges = ranges;
        this.shown = new AtomicBoolean(false);
    }

    @NotNull
    public final Rule getRule() {
        return this.rule;
    }

    @NotNull
    public final TextContent.TextDomain getDomain() {
        return this.domain;
    }

    public final boolean isCommitMessage() {
        return this.isCommitMessage;
    }

    @NotNull
    public final Language getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    @NotNull
    public final ai.grazie.nlp.langs.Language getTextLanguage() {
        return this.textLanguage;
    }

    @NotNull
    public final String getFilepath() {
        return this.filepath;
    }

    @NotNull
    public final List<TextRange> getRanges() {
        return this.ranges;
    }

    public AcceptanceRateTracker(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Rule rule = problem.getRule();
        Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"getRule(...)");
        TextContent.TextDomain textDomain = problem.getText().getDomain();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)textDomain), (String)"getDomain(...)");
        boolean bl = CommitMessage.isCommitMessage((PsiElement)problem.getText().getCommonParent());
        Language language = problem.getText().getCommonParent().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        ai.grazie.nlp.langs.Language language2 = LangDetector.INSTANCE.getLanguage(((Object)problem.getText()).toString());
        if (language2 == null) {
            language2 = ai.grazie.nlp.langs.Language.UNKNOWN;
        }
        String string = problem.getText().getContainingFile().getViewProvider().getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        List<TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        this(rule, textDomain, bl, language, language2, string, list);
    }

    public final boolean markShown() {
        return this.shown.compareAndSet(false, true);
    }

    @NotNull
    public final Rule component1() {
        return this.rule;
    }

    @NotNull
    public final TextContent.TextDomain component2() {
        return this.domain;
    }

    public final boolean component3() {
        return this.isCommitMessage;
    }

    @NotNull
    public final Language component4() {
        return this.programmingLanguage;
    }

    @NotNull
    public final ai.grazie.nlp.langs.Language component5() {
        return this.textLanguage;
    }

    @NotNull
    public final String component6() {
        return this.filepath;
    }

    @NotNull
    public final List<TextRange> component7() {
        return this.ranges;
    }

    @NotNull
    public final AcceptanceRateTracker copy(@NotNull Rule rule, @NotNull TextContent.TextDomain domain, boolean isCommitMessage, @NotNull Language programmingLanguage, @NotNull ai.grazie.nlp.langs.Language textLanguage, @NotNull String filepath, @NotNull List<? extends TextRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
        Intrinsics.checkNotNullParameter((Object)programmingLanguage, (String)"programmingLanguage");
        Intrinsics.checkNotNullParameter((Object)textLanguage, (String)"textLanguage");
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        return new AcceptanceRateTracker(rule, domain, isCommitMessage, programmingLanguage, textLanguage, filepath, ranges);
    }

    public static /* synthetic */ AcceptanceRateTracker copy$default(AcceptanceRateTracker acceptanceRateTracker, Rule rule, TextContent.TextDomain textDomain, boolean bl, Language language, ai.grazie.nlp.langs.Language language2, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            rule = acceptanceRateTracker.rule;
        }
        if ((n & 2) != 0) {
            textDomain = acceptanceRateTracker.domain;
        }
        if ((n & 4) != 0) {
            bl = acceptanceRateTracker.isCommitMessage;
        }
        if ((n & 8) != 0) {
            language = acceptanceRateTracker.programmingLanguage;
        }
        if ((n & 0x10) != 0) {
            language2 = acceptanceRateTracker.textLanguage;
        }
        if ((n & 0x20) != 0) {
            string = acceptanceRateTracker.filepath;
        }
        if ((n & 0x40) != 0) {
            list = acceptanceRateTracker.ranges;
        }
        return acceptanceRateTracker.copy(rule, textDomain, bl, language, language2, string, list);
    }

    @NotNull
    public String toString() {
        return "AcceptanceRateTracker(rule=" + this.rule + ", domain=" + this.domain + ", isCommitMessage=" + this.isCommitMessage + ", programmingLanguage=" + this.programmingLanguage + ", textLanguage=" + this.textLanguage + ", filepath=" + this.filepath + ", ranges=" + this.ranges + ")";
    }

    public int hashCode() {
        int result = this.rule.hashCode();
        result = result * 31 + this.domain.hashCode();
        result = result * 31 + Boolean.hashCode(this.isCommitMessage);
        result = result * 31 + this.programmingLanguage.hashCode();
        result = result * 31 + this.textLanguage.hashCode();
        result = result * 31 + this.filepath.hashCode();
        result = result * 31 + ((Object)this.ranges).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AcceptanceRateTracker)) {
            return false;
        }
        AcceptanceRateTracker acceptanceRateTracker = (AcceptanceRateTracker)other;
        if (!Intrinsics.areEqual((Object)this.rule, (Object)acceptanceRateTracker.rule)) {
            return false;
        }
        if (this.domain != acceptanceRateTracker.domain) {
            return false;
        }
        if (this.isCommitMessage != acceptanceRateTracker.isCommitMessage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.programmingLanguage, (Object)acceptanceRateTracker.programmingLanguage)) {
            return false;
        }
        if (this.textLanguage != acceptanceRateTracker.textLanguage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filepath, (Object)acceptanceRateTracker.filepath)) {
            return false;
        }
        return Intrinsics.areEqual(this.ranges, acceptanceRateTracker.ranges);
    }
}

