/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.async;

import ai.grazie.spell.lists.WordList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.grazie.async.AsyncUtils;
import com.intellij.spellchecker.grazie.async.WordListLoaderKt;
import com.intellij.spellchecker.grazie.dictionary.SimpleWordList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eJ*\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u0016\u001a\u00020\rH\u0002J*\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00b3\u0001\u0010\n\u001a\u00a6\u0001\u0012H\u0012F\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000e \u0012*\"\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000e\u0018\u00010\f0\f \u0012*Q\u0012H\u0012F\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000e \u0012*\"\u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000e\u0018\u00010\f0\f0\u0014\u00a2\u0006\u0002\b\u00130\u000b\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spellchecker/grazie/async/WordListLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isLoadingList", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listsToLoad", "", "Lkotlin/Pair;", "Lcom/intellij/spellchecker/dictionary/Loader;", "Lkotlin/Function2;", "", "Lai/grazie/spell/lists/WordList;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "loadWordList", "loader", "consumer", "doLoadWordListAsync", "readAll", "", "queueWordListLoad", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nWordListLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordListLoader.kt\ncom/intellij/spellchecker/grazie/async/WordListLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n61#2,5:85\n*S KotlinDebug\n*F\n+ 1 WordListLoader.kt\ncom/intellij/spellchecker/grazie/async/WordListLoader\n*L\n44#1:85,5\n*E\n"})
public final class WordListLoader {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicBoolean isLoadingList;
    @NotNull
    private final List<Pair<Loader, Function2<String, WordList, Unit>>> listsToLoad;

    public WordListLoader(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.isLoadingList = new AtomicBoolean(false);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.listsToLoad = list;
    }

    public final void loadWordList(@NotNull Loader loader, @NotNull Function2<? super String, ? super WordList, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (AsyncUtils.INSTANCE.isNonAsyncMode()) {
            String string = loader.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            consumer.invoke((Object)string, (Object)new SimpleWordList(this.readAll(loader)));
        } else if (this.isLoadingList.compareAndSet(false, true)) {
            WordListLoaderKt.access$getLOG$p().debug("Loading " + loader);
            this.doLoadWordListAsync(loader, consumer);
        } else {
            this.queueWordListLoad(loader, consumer);
        }
    }

    private final void doLoadWordListAsync(Loader loader, Function2<? super String, ? super WordList, Unit> consumer) {
        if (this.project.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)this.project).runAfterOpened(() -> WordListLoader.doLoadWordListAsync$lambda$1(this, loader, consumer));
    }

    private final Set<String> readAll(Loader loader) {
        List words = new ArrayList();
        loader.load(arg_0 -> WordListLoader.readAll$lambda$2(words, arg_0));
        Set set = CollectionFactory.createSmallMemoryFootprintSet((Collection)words);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        return set;
    }

    private final void queueWordListLoad(Loader loader, Function2<? super String, ? super WordList, Unit> consumer) {
        WordListLoaderKt.access$getLOG$p().debug("Queuing load for: " + loader.getName());
        this.listsToLoad.add((Pair<Loader, Function2<String, WordList, Unit>>)TuplesKt.to((Object)loader, consumer));
    }

    private static final void doLoadWordListAsync$lambda$1(WordListLoader this$0, Loader $loader, Function2 $consumer) {
        Logger $this$debug_u24default$iv = WordListLoaderKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Loading " + $loader, e$iv);
        }
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($loader, this$0, (Function2<? super String, ? super WordList, Unit>)$consumer, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Loader $loader;
            final /* synthetic */ WordListLoader this$0;
            final /* synthetic */ Function2<String, WordList, Unit> $consumer;
            {
                this.$loader = $loader;
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        WordListLoaderKt.access$getLOG$p().debug(this.$loader + " loaded!");
                        SimpleWordList list = new SimpleWordList(WordListLoader.access$readAll(this.this$0, this.$loader));
                        String string = this.$loader.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this.$consumer.invoke((Object)string, (Object)list);
                        while (!((Collection)WordListLoader.access$getListsToLoad$p(this.this$0)).isEmpty()) {
                            CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                            Pair pair = (Pair)WordListLoader.access$getListsToLoad$p(this.this$0).remove(0);
                            Loader curLoader = (Loader)pair.component1();
                            Function2 currentConsumer = (Function2)pair.component2();
                            WordListLoaderKt.access$getLOG$p().debug(curLoader.getName() + " loaded!");
                            SimpleWordList simpleWordList = new SimpleWordList(WordListLoader.access$readAll(this.this$0, curLoader));
                            String string2 = curLoader.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                            currentConsumer.invoke((Object)string2, (Object)simpleWordList);
                        }
                        WordListLoaderKt.access$getLOG$p().debug("Loading finished, restarting daemon...");
                        WordListLoader.access$isLoadingList$p(this.this$0).set(false);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)list);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Application application = ApplicationManager.getApplication();
                                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                                        AsyncUtils.INSTANCE.restartInspection(application);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        SimpleWordList list = (SimpleWordList)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void readAll$lambda$2(List $words, String it) {
        ProgressManager.checkCanceled();
        Intrinsics.checkNotNull((Object)it);
        $words.add(it);
    }

    public static final /* synthetic */ Set access$readAll(WordListLoader $this, Loader loader) {
        return $this.readAll(loader);
    }

    public static final /* synthetic */ List access$getListsToLoad$p(WordListLoader $this) {
        return $this.listsToLoad;
    }

    public static final /* synthetic */ AtomicBoolean access$isLoadingList$p(WordListLoader $this) {
        return $this.isLoadingList;
    }
}

