/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogSystemCollector;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.ListEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.RegexpIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDataType;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.IllegalMetadataSchemeStateException;
import com.intellij.internal.statistic.eventLog.events.scheme.PluginSchemeDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageCollectorBean;
import com.intellij.internal.statistic.service.fus.collectors.UsageCollectors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002J?\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u001f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010 J4\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\f2\b\u0010#\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0007J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'2\u0006\u0010(\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\b\u0010#\u001a\u0004\u0018\u00010\nJ\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010-\u001a\u0004\u0018\u00010\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0010\u0010.\u001a\u00020+2\u0006\u0010#\u001a\u00020\nH\u0002J(\u0010/\u001a\u0004\u0018\u00010\n2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u000204H\u0002J,\u00105\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J0\u00106\u001a\u0004\u0018\u00010\n2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J.\u00109\u001a\u00020\u00182\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010:\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J.\u0010;\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010:\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilder;", "", "<init>", "()V", "pluginInfoFields", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDescriptor;", "getPluginInfoFields", "()Ljava/util/Set;", "classValidationRuleNames", "", "classValidationRules", "", "fieldSchema", "field", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "fieldName", "eventName", "groupId", "buildFieldDescriptors", "validationRules", "fieldDataType", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDataType;", "shouldBeAnonymized", "", "description", "validateRegexp", "", "regexp", "buildObjectEvenScheme", "fields", "", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;Ljava/lang/String;Ljava/lang/String;)Ljava/util/Set;", "buildEventsScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "recorder", "pluginId", "brokenPluginIds", "collectGroupsFromExtensions", "", "groupType", "collectors", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilder$FeatureUsageCollectorInfo;", "getObjectArrays", "parentPath", "calculateEventLogSystemCollector", "getEventDescription", "events", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "validateGroupId", "collector", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "buildFields", "getFieldDescription", "values", "event", "getShouldBeAnonymized", "name", "getDataType", "FeatureUsageCollectorInfo", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventsSchemeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsSchemeBuilder.kt\ncom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,278:1\n1761#2,3:279\n1869#2,2:282\n1011#2,2:284\n1491#2:286\n1516#2,3:287\n1519#2,3:297\n1374#2:303\n1460#2,2:304\n1374#2:306\n1460#2,5:307\n1462#2,3:312\n1625#2:321\n1869#2:322\n1870#2:324\n1626#2:325\n1374#2:343\n1460#2,5:344\n1625#2:350\n1869#2:351\n1870#2:353\n1626#2:354\n1761#2,3:355\n1761#2,3:358\n1563#2:361\n1634#2,3:362\n382#3,7:290\n382#3,7:330\n126#4:300\n153#4,2:301\n155#4:315\n126#4:340\n153#4,2:341\n155#4:349\n1#5:316\n1#5:323\n1#5:352\n13472#6,2:317\n13472#6,2:319\n996#7:326\n1025#7,3:327\n1028#7,3:337\n*S KotlinDebug\n*F\n+ 1 EventsSchemeBuilder.kt\ncom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilder\n*L\n65#1:279,3\n137#1:282,2\n141#1:284,2\n161#1:286\n161#1:287,3\n161#1:297,3\n164#1:303\n164#1:304,2\n165#1:306\n165#1:307,5\n164#1:312,3\n214#1:321\n214#1:322\n214#1:324\n214#1:325\n242#1:343\n242#1:344,5\n248#1:350\n248#1:351\n248#1:353\n248#1:354\n257#1:355,3\n266#1:358,3\n25#1:361\n25#1:362,3\n161#1:290,7\n237#1:330,7\n162#1:300\n162#1:301,2\n162#1:315\n238#1:340\n238#1:341,2\n238#1:349\n214#1:323\n248#1:352\n189#1:317,2\n194#1:319,2\n237#1:326\n237#1:327,3\n237#1:337,3\n*E\n"})
public final class EventsSchemeBuilder {
    @NotNull
    public static final EventsSchemeBuilder INSTANCE;
    @NotNull
    private static final Set<FieldDescriptor> pluginInfoFields;
    @NotNull
    private static final Set<String> classValidationRuleNames;
    @NotNull
    private static final List<String> classValidationRules;

    private EventsSchemeBuilder() {
    }

    @NotNull
    public final Set<FieldDescriptor> getPluginInfoFields() {
        return pluginInfoFields;
    }

    private final Set<FieldDescriptor> fieldSchema(EventField<?> field, String fieldName, String eventName, String groupId) {
        Set<FieldDescriptor> set;
        if (StringsKt.contains$default((CharSequence)field.getName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            throw new IllegalMetadataSchemeStateException("Field name should not contains dots, because dots are used to express hierarchy. Group=" + groupId + ", event=" + eventName + ", field=" + field.getName());
        }
        EventField<?> eventField = field;
        if (Intrinsics.areEqual(eventField, EventFields.PluginInfo) || Intrinsics.areEqual(eventField, EventFields.PluginInfoFromInstance) || Intrinsics.areEqual(eventField, EventFields.PluginInfoByDescriptor)) {
            set = pluginInfoFields;
        } else if (eventField instanceof ObjectEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectEventField)field).getFields(), eventName, groupId);
        } else if (eventField instanceof ObjectListEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectListEventField)field).getFields(), eventName, groupId);
        } else if (eventField instanceof ListEventField) {
            if (field instanceof StringListEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringListEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            set = this.buildFieldDescriptors(fieldName, ((ListEventField)field).getValidationRule(), FieldDataType.ARRAY, ((ListEventField)field).getShouldBeAnonymized(), ((ListEventField)field).getDescription());
        } else if (eventField instanceof PrimitiveEventField) {
            if (field instanceof StringEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            if (field instanceof RegexpIntEventField) {
                this.validateRegexp(((RegexpIntEventField)field).getRegexp());
            }
            set = this.buildFieldDescriptors(fieldName, ((PrimitiveEventField)field).getValidationRule(), FieldDataType.PRIMITIVE, ((PrimitiveEventField)field).getShouldBeAnonymized(), ((PrimitiveEventField)field).getDescription());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final Set<FieldDescriptor> buildFieldDescriptors(String fieldName, List<String> validationRules, FieldDataType fieldDataType, boolean shouldBeAnonymized, String description) {
        boolean bl;
        Set fields;
        block4: {
            Object[] objectArray = new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toSet((Iterable)validationRules), shouldBeAnonymized, fieldDataType, description)};
            fields = SetsKt.mutableSetOf((Object[])objectArray);
            Iterable $this$any$iv = validationRules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!classValidationRules.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            fields.addAll((Collection)pluginInfoFields);
        }
        return fields;
    }

    private final void validateRegexp(String regexp) {
        if (Intrinsics.areEqual((Object)regexp, (Object)".*")) {
            throw new IllegalMetadataSchemeStateException("Regexp should be more strict to prevent accidentally reporting sensitive data.");
        }
        Pattern.compile(regexp);
    }

    private final Set<FieldDescriptor> buildObjectEvenScheme(String fieldName, EventField<?>[] fields, String eventName, String groupId) {
        Set fieldsDescriptors = new LinkedHashSet();
        for (EventField<?> eventField : fields) {
            fieldsDescriptors.addAll((Collection)this.fieldSchema(eventField, fieldName + "." + eventField.getName(), eventName, groupId));
        }
        return fieldsDescriptors;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme(@Nullable String recorder, @Nullable String pluginId, @NotNull Set<String> brokenPluginIds) {
        Intrinsics.checkNotNullParameter(brokenPluginIds, (String)"brokenPluginIds");
        List result = new ArrayList();
        Set recorders = new LinkedHashSet();
        ArrayList counterCollectors = new ArrayList();
        UsageCollectors.COUNTER_EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> EventsSchemeBuilder.buildEventsScheme$lambda$2(pluginId, brokenPluginIds, recorders, counterCollectors, arg_0, arg_1));
        result.addAll(INSTANCE.collectGroupsFromExtensions("counter", counterCollectors, recorder));
        ArrayList stateCollectors = new ArrayList();
        UsageCollectors.APPLICATION_EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> EventsSchemeBuilder.buildEventsScheme$lambda$3(pluginId, brokenPluginIds, recorders, stateCollectors, arg_0, arg_1));
        UsageCollectors.PROJECT_EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> EventsSchemeBuilder.buildEventsScheme$lambda$4(pluginId, brokenPluginIds, recorders, stateCollectors, arg_0, arg_1));
        result.addAll(INSTANCE.collectGroupsFromExtensions("state", stateCollectors, recorder));
        ArrayList<FeatureUsageCollectorInfo> systemCollectors = new ArrayList<FeatureUsageCollectorInfo>();
        if (recorder != null) {
            systemCollectors.add(INSTANCE.calculateEventLogSystemCollector(recorder));
        } else {
            Iterable $this$forEach$iv = recorders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                systemCollectors.add(INSTANCE.calculateEventLogSystemCollector(it));
            }
        }
        result.addAll(INSTANCE.collectGroupsFromExtensions("counter", (Collection<FeatureUsageCollectorInfo>)systemCollectors, recorder));
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GroupDescriptor p0 = (GroupDescriptor)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getId());
                    p0 = (GroupDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getId())));
                }
            });
        }
        return result;
    }

    public static /* synthetic */ List buildEventsScheme$default(String string, String string2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        return EventsSchemeBuilder.buildEventsScheme(string, string2, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<GroupDescriptor> collectGroupsFromExtensions(@NotNull String groupType, @NotNull Collection<FeatureUsageCollectorInfo> collectors, @Nullable String recorder) {
        Intrinsics.checkNotNullParameter((Object)groupType, (String)"groupType");
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        HashMap result = new HashMap();
        for (FeatureUsageCollectorInfo featureUsageCollectorInfo : collectors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable answer$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            EventLogGroup group;
            FeatureUsagesCollector collector = featureUsageCollectorInfo.component1();
            PluginSchemeDescriptor plugin = featureUsageCollectorInfo.component2();
            Class<?> collectorClass = collector.getClass().getEnclosingClass() != null ? collector.getClass().getEnclosingClass() : collector.getClass();
            this.validateGroupId(collector);
            if (collector.getGroup() == null || recorder != null && !Intrinsics.areEqual((Object)group.getRecorder(), (Object)recorder)) continue;
            GroupDescriptor existingGroup = (GroupDescriptor)result.get(group.getId());
            if (existingGroup != null && group.getVersion() != existingGroup.getVersion()) {
                throw new IllegalMetadataSchemeStateException("If group is reused in multiple collectors classes (e.g Project and Application collector), it should have the same version (group=" + group.getId() + ")");
            }
            Object object = existingGroup;
            if (object == null || (object = ((GroupDescriptor)object).getSchema()) == null) {
                object = new HashSet();
            }
            Object existingScheme = object;
            Object object2 = group.getEvents();
            Object object3 = existingScheme;
            boolean $i$f$groupBy = false;
            GroupDescriptor groupDescriptor = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object4;
                BaseEventId it = (BaseEventId)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getEventId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$flatMapTo$iv$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
                Object object5 = destination$iv$iv;
                boolean bl = false;
                String eventId = (String)entry.getKey();
                List events = (List)entry.getValue();
                Iterable $this$flatMap$iv = events;
                boolean $i$f$flatMap = false;
                answer$iv$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$flatMapTo$iv$iv2;
                    BaseEventId event = (BaseEventId)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$flatMap$iv2 = event.getFields();
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable = $this$flatMap$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        EventField field = (EventField)element$iv$iv2;
                        boolean bl4 = false;
                        Iterable list$iv$iv = INSTANCE.getObjectArrays(null, field);
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List arrays = (List)destination$iv$iv2;
                object5.add(new EventDescriptor(eventId, INSTANCE.buildFields(events, eventId, group.getId()), INSTANCE.getEventDescription(events, eventId, group.getId()), arrays));
            }
            Set eventsDescriptors = SetsKt.plus((Set)object3, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            object2 = result;
            String string = group.getId();
            String string2 = group.getId();
            int n = group.getVersion();
            String string3 = collectorClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            groupDescriptor = new GroupDescriptor(string2, groupType, n, eventsDescriptors, string3, group.getRecorder(), new PluginSchemeDescriptor(plugin.getId()), group.getDescription(), collector.getFileName());
            object2.put(string, groupDescriptor);
        }
        Collection<GroupDescriptor> collection = result.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @NotNull
    public final List<String> getObjectArrays(@Nullable String parentPath, @NotNull EventField<?> field) {
        EventField<?> it;
        EventField<?> element$iv;
        int n;
        int n2;
        EventField<?>[] $this$forEach$iv;
        Object object;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(field, (String)"field");
                object = parentPath;
                if (object == null) break block7;
                String it2 = object;
                boolean bl = false;
                String string = it2 + "." + field.getName();
                object = string;
                if (string != null) break block8;
            }
            object = field.getName();
        }
        String path = object;
        List objectArrays = new ArrayList();
        if (field instanceof ObjectListEventField) {
            objectArrays.add(path);
            $this$forEach$iv = ((ObjectListEventField)field).getFields();
            boolean $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                CollectionsKt.addAll((Collection)objectArrays, (Iterable)INSTANCE.getObjectArrays(path, it));
            }
        }
        if (field instanceof ObjectEventField) {
            $this$forEach$iv = ((ObjectEventField)field).getFields();
            boolean $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                CollectionsKt.addAll((Collection)objectArrays, (Iterable)INSTANCE.getObjectArrays(path, it));
            }
        }
        return objectArrays;
    }

    private final FeatureUsageCollectorInfo calculateEventLogSystemCollector(String recorder) {
        StatisticsEventLoggerProvider eventLogProvider = StatisticsEventLogProviderUtil.getEventLogProvider(recorder);
        EventLogSystemCollector eventLogSystemCollector = eventLogProvider.getEventLogSystemLogger$intellij_platform_statistics();
        PluginDescriptor pluginDescriptor = PluginManager.getPluginByClass(eventLogProvider.getClass());
        String eventLogProviderPlugin = pluginDescriptor != null && (pluginDescriptor = pluginDescriptor.getPluginId()) != null ? pluginDescriptor.getIdString() : null;
        FeatureUsagesCollector featureUsagesCollector = eventLogSystemCollector;
        String string = eventLogProviderPlugin;
        if (string == null) {
            string = "com.intellij";
        }
        return new FeatureUsageCollectorInfo(featureUsagesCollector, new PluginSchemeDescriptor(string));
    }

    /*
     * WARNING - void declaration
     */
    private final String getEventDescription(List<? extends BaseEventId> events, String eventName, String groupId) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = events;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            BaseEventId it = (BaseEventId)element$iv;
            boolean bl2 = false;
            if (it.getDescription() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet eventDescriptions = (HashSet)destination$iv;
        if (eventDescriptions.size() > 1) {
            throw new IllegalMetadataSchemeStateException("Events couldn't be defined twice with different descriptions (group=" + groupId + ", event=" + eventName + ")");
        }
        return (String)CollectionsKt.firstOrNull((Iterable)eventDescriptions);
    }

    private final void validateGroupId(FeatureUsagesCollector collector) {
        try {
            collector.getGroupId();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e.getMessage() + " in " + collector.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FieldDescriptor> buildFields(List<? extends BaseEventId> events, String eventName, String groupId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Sequence sequence = SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)events), EventsSchemeBuilder::buildFields$lambda$14), arg_0 -> EventsSchemeBuilder.buildFields$lambda$15(eventName, groupId, arg_0));
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FieldDescriptor it = (FieldDescriptor)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getPath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            FieldDataType type = INSTANCE.getDataType(values, name, eventName, groupId);
            boolean shouldBeAnonymized = INSTANCE.getShouldBeAnonymized(values, name, eventName, groupId);
            String fieldDescription = INSTANCE.getFieldDescription(values, name, eventName, groupId);
            Iterable iterable = values;
            String string = name;
            boolean $i$f$flatMap = false;
            void var21_24 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                FieldDescriptor it = (FieldDescriptor)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            String string2 = fieldDescription;
            FieldDataType fieldDataType = type;
            boolean bl4 = shouldBeAnonymized;
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            String string3 = string;
            object.add(new FieldDescriptor(string3, set, bl4, fieldDataType, string2));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final String getFieldDescription(List<FieldDescriptor> values, String field, String event, String groupId) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = values;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            FieldDescriptor it = (FieldDescriptor)element$iv;
            boolean bl2 = false;
            if (it.getDescription() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet fieldsDescriptions = (HashSet)destination$iv;
        if (fieldsDescriptions.size() > 1) {
            throw new IllegalMetadataSchemeStateException("Fields couldn't be defined twice with different descriptions (group=" + groupId + ", event=" + event + ", field=" + field + ")");
        }
        return (String)CollectionsKt.firstOrNull((Iterable)fieldsDescriptions);
    }

    private final boolean getShouldBeAnonymized(List<FieldDescriptor> values, String name, String eventName, String groupId) {
        boolean bl;
        boolean shouldBeAnonymized;
        block4: {
            shouldBeAnonymized = ((FieldDescriptor)CollectionsKt.first(values)).getShouldBeAnonymized();
            Iterable $this$any$iv = values;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FieldDescriptor it = (FieldDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getShouldBeAnonymized() != shouldBeAnonymized)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalMetadataSchemeStateException("Field couldn't be defined twice with different shouldBeAnonymized value (group=" + groupId + ", event=" + eventName + ", field=" + name + ")");
        }
        return shouldBeAnonymized;
    }

    private final FieldDataType getDataType(List<FieldDescriptor> values, String name, String eventName, String groupId) {
        boolean bl;
        FieldDataType dataType;
        block4: {
            dataType = ((FieldDescriptor)CollectionsKt.first(values)).getDataType();
            Iterable $this$any$iv = values;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FieldDescriptor it = (FieldDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDataType() != dataType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalMetadataSchemeStateException("Field couldn't have multiple types (group=" + groupId + ", event=" + eventName + ", field=" + name + ")");
        }
        return dataType;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme(@Nullable String recorder, @Nullable String pluginId) {
        return EventsSchemeBuilder.buildEventsScheme$default(recorder, pluginId, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme(@Nullable String recorder) {
        return EventsSchemeBuilder.buildEventsScheme$default(recorder, null, null, 6, null);
    }

    private static final Unit buildEventsScheme$lambda$2(String $pluginId, Set $brokenPluginIds, Set $recorders, ArrayList $counterCollectors, CounterUsageCollectorEP counterUsageCollectorEP, PluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)counterUsageCollectorEP, (String)"counterUsageCollectorEP");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (counterUsageCollectorEP.implementationClass != null) {
            String collectorPlugin = descriptor.getPluginId().getIdString();
            if ($pluginId == null && !$brokenPluginIds.contains(collectorPlugin) || Intrinsics.areEqual((Object)$pluginId, (Object)collectorPlugin)) {
                Object object = ApplicationManager.getApplication().instantiateClass(counterUsageCollectorEP.implementationClass, descriptor);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"instantiateClass(...)");
                FeatureUsagesCollector collector = (FeatureUsagesCollector)object;
                $recorders.add(collector.getGroup().getRecorder());
                $counterCollectors.add(new FeatureUsageCollectorInfo(collector, new PluginSchemeDescriptor(collectorPlugin)));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildEventsScheme$lambda$3(String $pluginId, Set $brokenPluginIds, Set $recorders, ArrayList $stateCollectors, UsageCollectorBean bean, PluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String collectorPlugin = descriptor.getPluginId().getIdString();
        if ($pluginId == null && !$brokenPluginIds.contains(collectorPlugin) || Intrinsics.areEqual((Object)$pluginId, (Object)collectorPlugin)) {
            $recorders.add(bean.getCollector().getGroup().getRecorder());
            FeatureUsagesCollector featureUsagesCollector = bean.getCollector();
            Intrinsics.checkNotNullExpressionValue((Object)featureUsagesCollector, (String)"getCollector(...)");
            $stateCollectors.add(new FeatureUsageCollectorInfo(featureUsagesCollector, new PluginSchemeDescriptor(collectorPlugin)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildEventsScheme$lambda$4(String $pluginId, Set $brokenPluginIds, Set $recorders, ArrayList $stateCollectors, UsageCollectorBean bean, PluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String collectorPlugin = descriptor.getPluginId().getIdString();
        if ($pluginId == null && !$brokenPluginIds.contains(collectorPlugin) || Intrinsics.areEqual((Object)$pluginId, (Object)collectorPlugin)) {
            $recorders.add(bean.getCollector().getGroup().getRecorder());
            FeatureUsagesCollector featureUsagesCollector = bean.getCollector();
            Intrinsics.checkNotNullExpressionValue((Object)featureUsagesCollector, (String)"getCollector(...)");
            $stateCollectors.add(new FeatureUsageCollectorInfo(featureUsagesCollector, new PluginSchemeDescriptor(collectorPlugin)));
        }
        return Unit.INSTANCE;
    }

    private static final Iterable buildFields$lambda$14(BaseEventId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFields();
    }

    private static final Iterable buildFields$lambda$15(String $eventName, String $groupId, EventField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return INSTANCE.fieldSchema(field, field.getName(), $eventName, $groupId);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new EventsSchemeBuilder();
        Object[] objectArray = new FieldDescriptor[]{new FieldDescriptor("plugin", SetsKt.setOf((Object)"{util#plugin}"), false, null, null, 24, null), new FieldDescriptor("plugin_type", SetsKt.setOf((Object)"{util#plugin_type}"), false, null, null, 24, null), new FieldDescriptor("plugin_version", SetsKt.setOf((Object)"{util#plugin_version}"), false, null, null, 24, null)};
        pluginInfoFields = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"class_name", "dialog_class", "quick_fix_class_name", "run_config_factory", "tip_info", "run_config_factory", "run_config_id", "facets_type", "registry_key"};
        classValidationRuleNames = SetsKt.setOf((Object[])objectArray);
        Iterable $this$map$iv = classValidationRuleNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("{util#" + (String)it + "}");
        }
        classValidationRules = (List)var3_3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilder$FeatureUsageCollectorInfo;", "", "collector", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "plugin", "Lcom/intellij/internal/statistic/eventLog/events/scheme/PluginSchemeDescriptor;", "<init>", "(Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;Lcom/intellij/internal/statistic/eventLog/events/scheme/PluginSchemeDescriptor;)V", "getCollector", "()Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "getPlugin", "()Lcom/intellij/internal/statistic/eventLog/events/scheme/PluginSchemeDescriptor;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.statistics"})
    public static final class FeatureUsageCollectorInfo {
        @NotNull
        private final FeatureUsagesCollector collector;
        @NotNull
        private final PluginSchemeDescriptor plugin;

        public FeatureUsageCollectorInfo(@NotNull FeatureUsagesCollector collector, @NotNull PluginSchemeDescriptor plugin) {
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            this.collector = collector;
            this.plugin = plugin;
        }

        @NotNull
        public final FeatureUsagesCollector getCollector() {
            return this.collector;
        }

        @NotNull
        public final PluginSchemeDescriptor getPlugin() {
            return this.plugin;
        }

        @NotNull
        public final FeatureUsagesCollector component1() {
            return this.collector;
        }

        @NotNull
        public final PluginSchemeDescriptor component2() {
            return this.plugin;
        }

        @NotNull
        public final FeatureUsageCollectorInfo copy(@NotNull FeatureUsagesCollector collector, @NotNull PluginSchemeDescriptor plugin) {
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            return new FeatureUsageCollectorInfo(collector, plugin);
        }

        public static /* synthetic */ FeatureUsageCollectorInfo copy$default(FeatureUsageCollectorInfo featureUsageCollectorInfo, FeatureUsagesCollector featureUsagesCollector, PluginSchemeDescriptor pluginSchemeDescriptor, int n, Object object) {
            if ((n & 1) != 0) {
                featureUsagesCollector = featureUsageCollectorInfo.collector;
            }
            if ((n & 2) != 0) {
                pluginSchemeDescriptor = featureUsageCollectorInfo.plugin;
            }
            return featureUsageCollectorInfo.copy(featureUsagesCollector, pluginSchemeDescriptor);
        }

        @NotNull
        public String toString() {
            return "FeatureUsageCollectorInfo(collector=" + this.collector + ", plugin=" + this.plugin + ")";
        }

        public int hashCode() {
            int result = this.collector.hashCode();
            result = result * 31 + this.plugin.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureUsageCollectorInfo)) {
                return false;
            }
            FeatureUsageCollectorInfo featureUsageCollectorInfo = (FeatureUsageCollectorInfo)other;
            if (!Intrinsics.areEqual((Object)this.collector, (Object)featureUsageCollectorInfo.collector)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.plugin, (Object)featureUsageCollectorInfo.plugin);
        }
    }
}

