/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;
import org.jetbrains.idea.svn.commandLine.WinTerminalExecutor;

public class TerminalExecutor
extends CommandExecutor {
    private final List<InteractiveCommandListener> myInteractiveListeners;

    public TerminalExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        if (exePath == null) {
            TerminalExecutor.$$$reportNull$$$0(0);
        }
        if (command == null) {
            TerminalExecutor.$$$reportNull$$$0(1);
        }
        super(exePath, command);
        this.myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener2) {
        if (listener2 == null) {
            TerminalExecutor.$$$reportNull$$$0(2);
        }
        this.myInteractiveListeners.add(listener2);
    }

    @Override
    public Boolean wasError() {
        return Boolean.FALSE;
    }

    @Override
    protected void startHandlingStreams() {
        for (InteractiveCommandListener listener2 : this.myInteractiveListeners) {
            ((TerminalProcessHandler)this.myHandler).addInteractiveListener(listener2);
        }
        super.startHandlingStreams();
    }

    @Override
    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        return new TerminalProcessHandler(this.myProcess, this.myCommandLine, this.needsUtf8Output(), false);
    }

    @Override
    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        if (this instanceof WinTerminalExecutor) {
            ByteArrayOutputStream byteArrayOutputStream = super.getBinaryOutput();
            if (byteArrayOutputStream == null) {
                TerminalExecutor.$$$reportNull$$$0(3);
            }
            return byteArrayOutputStream;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] outputBytes = this.getOutput().getBytes(StandardCharsets.UTF_8);
        result.write(outputBytes, 0, outputBytes.length);
        ByteArrayOutputStream byteArrayOutputStream = result;
        if (byteArrayOutputStream == null) {
            TerminalExecutor.$$$reportNull$$$0(4);
        }
        return byteArrayOutputStream;
    }

    @Override
    @NotNull
    protected GeneralCommandLine createCommandLine() {
        return new PtyCommandLine();
    }

    @Override
    @NotNull
    protected Process createProcess() throws ExecutionException {
        List<String> parameters = this.escapeArguments(this.buildParameters());
        Process process = this.createProcess(parameters);
        if (process == null) {
            TerminalExecutor.$$$reportNull$$$0(5);
        }
        return process;
    }

    @NotNull
    protected List<String> buildParameters() {
        List list = CommandLineUtil.toCommandLine((String)this.myCommandLine.getExePath(), (List)this.myCommandLine.getParametersList().getList());
        if (list == null) {
            TerminalExecutor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected Process createProcess(@NotNull List<String> parameters) throws ExecutionException {
        Process process;
        if (parameters == null) {
            TerminalExecutor.$$$reportNull$$$0(7);
        }
        try {
            process = ((PtyCommandLine)this.myCommandLine).withConsoleMode(false).startProcessWithPty(parameters);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (process == null) {
            TerminalExecutor.$$$reportNull$$$0(8);
        }
        return process;
    }

    @Override
    public void logCommand() {
        super.logCommand();
        LOG.info("Terminal output " + ((TerminalProcessHandler)this.myHandler).getTerminalOutput());
    }

    @NotNull
    protected List<String> escapeArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            TerminalExecutor.$$$reportNull$$$0(9);
        }
        List<String> list = arguments;
        if (list == null) {
            TerminalExecutor.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/TerminalExecutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/TerminalExecutor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryOutput";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addInteractiveListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "escapeArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

