/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenWorkspaceMap
implements Serializable {
    private final Map<MavenId, Data> myMapping = new HashMap<MavenId, Data>();
    private final Map<String, Serializable> myAdditionalContext = new HashMap<String, Serializable>();

    public void register(@NotNull MavenId id, @NotNull File file) {
        if (id == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(1);
        }
        this.register(id, file, null);
    }

    public void register(@NotNull MavenId id, @NotNull File file, @Nullable File outputFile) {
        if (id == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(2);
        }
        if (file == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(3);
        }
        for (MavenId each : MavenWorkspaceMap.getAllIDs(id)) {
            this.myMapping.put(each, new Data(id, file, outputFile));
        }
    }

    public void addContext(String id, Serializable contextData) {
        this.myAdditionalContext.put(id, contextData);
    }

    @Nullable
    public Serializable getAdditionalContext(String id) {
        return this.myAdditionalContext.get(id);
    }

    @NotNull
    public Set<String> getAvailableContextIds() {
        Set<String> set = this.myAdditionalContext.keySet();
        if (set == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(4);
        }
        return set;
    }

    public void unregister(@NotNull MavenId id) {
        if (id == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(5);
        }
        for (MavenId each : MavenWorkspaceMap.getAllIDs(id)) {
            this.myMapping.remove(each);
        }
    }

    @Nullable
    public Data findFileAndOriginalId(@NotNull MavenId dependencyId) {
        if (dependencyId == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(6);
        }
        return this.myMapping.get(dependencyId);
    }

    @NotNull
    public Set<MavenId> getAvailableIds() {
        Set<MavenId> set = this.myMapping.keySet();
        if (set == null) {
            MavenWorkspaceMap.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static MavenId[] getAllIDs(MavenId id) {
        String version = id.getVersion();
        if (version != null && version.contains("SNAPSHOT")) {
            return new MavenId[]{id, new MavenId(id.getGroupId(), id.getArtifactId(), "LATEST")};
        }
        return new MavenId[]{id, new MavenId(id.getGroupId(), id.getArtifactId(), "LATEST"), new MavenId(id.getGroupId(), id.getArtifactId(), "RELEASE")};
    }

    public MavenWorkspaceMap copy() {
        MavenWorkspaceMap result = new MavenWorkspaceMap();
        result.myMapping.putAll(this.myMapping);
        return result;
    }

    public static MavenWorkspaceMap copy(MavenWorkspaceMap workspaceMap, Function<? super String, String> transformer) {
        MavenWorkspaceMap result = new MavenWorkspaceMap();
        for (Map.Entry<MavenId, Data> entry : workspaceMap.myMapping.entrySet()) {
            Data data = entry.getValue();
            File outputFile = data.outputFile == null ? null : new File(transformer.apply(data.outputFile.getAbsolutePath()));
            File file = new File(transformer.apply(data.file.getAbsolutePath()));
            result.myMapping.put(entry.getKey(), new Data(data.originalId, file, outputFile));
        }
        return result;
    }

    public MavenWorkspaceMap copyInto(MavenWorkspaceMap recipient) {
        recipient.myMapping.clear();
        recipient.myMapping.putAll(this.myMapping);
        return recipient;
    }

    public static MavenWorkspaceMap empty() {
        return new MavenWorkspaceMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/model/MavenWorkspaceMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/model/MavenWorkspaceMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableContextIds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileAndOriginalId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Data
    implements Serializable {
        public final MavenId originalId;
        private final File file;
        private final File outputFile;

        private Data(MavenId originalId, File file, File outputFile) {
            this.originalId = originalId;
            this.file = file;
            this.outputFile = outputFile;
        }

        public File getFile(String type) {
            return this.outputFile == null || "pom".equalsIgnoreCase(type) ? this.file : this.outputFile;
        }
    }
}

