/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/OpenEventsSchemeFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "recorderId", "", "(Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "e", "Manager", "intellij.platform.statistics.devkit"})
public final class OpenEventsSchemeFileAction
extends DumbAwareAction {
    @NotNull
    private final String recorderId;

    public OpenEventsSchemeFileAction() {
        this.recorderId = "FUS";
    }

    public OpenEventsSchemeFileAction(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Object[] objectArray = new Object[]{recorderId};
        super(StatisticsBundle.message((String)"stats.open.0.scheme.file", (Object[])objectArray), ActionsBundle.message((String)"action.OpenEventsSchemeFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Config);
        this.recorderId = recorderId;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabled(event.getProject() != null && StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Manager.INSTANCE.openFileInEditor(Manager.INSTANCE.getEventsSchemeFile(this.recorderId), project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/OpenEventsSchemeFileAction$Manager;", "", "<init>", "()V", "openFileInEditor", "", "file", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getEventsSchemeFile", "recorderId", "", "intellij.platform.statistics.devkit"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        public final void openFileInEditor(@NotNull Path file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
            if (virtualFile == null) {
                Object[] objectArray = new Object[]{((Object)file).toString()};
                String string = StatisticsBundle.message((String)"stats.file.0.does.not.exist", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                StatisticsDevKitUtil.INSTANCE.showNotification(project, NotificationType.WARNING, string);
                return;
            }
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }

        @NotNull
        public final Path getEventsSchemeFile(@NotNull String recorderId) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(recorderId);
            if (settings != null && settings.isUseCustomPath()) {
                Path path2 = Path.of(settings.getCustomPath(), new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                path = path2;
            } else {
                Path path3 = BaseEventLogMetadataPersistence.getDefaultMetadataFile((String)recorderId, (String)"events-scheme.json", null);
                Intrinsics.checkNotNull((Object)path3);
                path = path3;
            }
            return path;
        }
    }
}

