/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import java.util.Arrays;
import korlibs.crypto.Cipher;
import korlibs.crypto.CipherModeBase;
import korlibs.crypto.CipherPadding;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH$J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH$J,\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ,\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0014"}, d2={"Lkorlibs/crypto/CipherModeIV;", "Lkorlibs/crypto/CipherModeBase;", "name", "", "(Ljava/lang/String;)V", "coreDecrypt", "", "pData", "", "cipher", "Lkorlibs/crypto/Cipher;", "ivb", "coreEncrypt", "decrypt", "data", "padding", "Lkorlibs/crypto/CipherPadding;", "Lkorlibs/crypto/Padding;", "iv", "encrypt", "krypto"})
abstract class CipherModeIV
extends CipherModeBase {
    public CipherModeIV(@NotNull String name) {
        super(name);
    }

    @Override
    @NotNull
    public final byte[] encrypt(@NotNull byte[] data, @NotNull Cipher cipher, @NotNull CipherPadding padding, @Nullable byte[] iv) {
        byte[] ivb = KryptoToolsKt.getIV(iv, cipher.getBlockSize());
        byte[] pData = padding.add(data, cipher.getBlockSize());
        this.coreEncrypt(pData, cipher, ivb);
        return pData;
    }

    @Override
    @NotNull
    public final byte[] decrypt(@NotNull byte[] data, @NotNull Cipher cipher, @NotNull CipherPadding padding, @Nullable byte[] iv) {
        byte[] ivb = KryptoToolsKt.getIV(iv, cipher.getBlockSize());
        byte[] byArray = Arrays.copyOf(data, data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        byte[] pData = byArray;
        this.coreDecrypt(pData, cipher, ivb);
        return padding.remove(pData);
    }

    protected abstract void coreEncrypt(@NotNull byte[] var1, @NotNull Cipher var2, @NotNull byte[] var3);

    protected abstract void coreDecrypt(@NotNull byte[] var1, @NotNull Cipher var2, @NotNull byte[] var3);
}

