/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.Maven40ServerEmbedderImpl;
import com.intellij.maven.server.m40.utils.Maven40AetherModelConverter;
import com.intellij.maven.server.m40.utils.Maven40EffectivePomDumper;
import com.intellij.maven.server.m40.utils.Maven40ImporterSpy;
import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import com.intellij.maven.server.m40.utils.Maven40ResolverUtil;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceMapReader;
import com.intellij.maven.server.telemetry.MavenServerOpenTelemetry;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.resolver.MavenChainedWorkspaceReader;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.PomHashMap;

public class Maven40ProjectResolver {
    @NotNull
    private final Maven40ServerEmbedderImpl myEmbedder;
    @NotNull
    private final MavenServerOpenTelemetry myTelemetry;
    private final boolean myUpdateSnapshots;
    @NotNull
    private final Maven40ImporterSpy myImporterSpy;
    private final LongRunningTask myLongRunningTask;
    @NotNull
    @NotNull List<@NotNull File> myFilesToResolve;
    private final PomHashMap myPomHashMap;
    private final List<String> myActiveProfiles;
    private final List<String> myInactiveProfiles;
    @Nullable
    private final MavenWorkspaceMap myWorkspaceMap;
    @NotNull
    private final File myLocalRepositoryFile;
    @NotNull
    private final Properties userProperties;
    private final boolean myResolveInParallel;

    public Maven40ProjectResolver(@NotNull Maven40ServerEmbedderImpl embedder, @NotNull MavenServerOpenTelemetry telemetry, boolean updateSnapshots, @NotNull Maven40ImporterSpy importerSpy, @NotNull LongRunningTask longRunningTask, @NotNull @NotNull List<@NotNull File> filesToResolve, @NotNull PomHashMap pomHashMap, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @Nullable MavenWorkspaceMap workspaceMap, @NotNull File localRepositoryFile, @NotNull Properties userProperties, boolean resolveInParallel) {
        if (embedder == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(0);
        }
        if (telemetry == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(1);
        }
        if (importerSpy == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(2);
        }
        if (longRunningTask == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(3);
        }
        if (filesToResolve == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(4);
        }
        if (pomHashMap == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(6);
        }
        if (inactiveProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(7);
        }
        if (localRepositoryFile == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(8);
        }
        if (userProperties == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(9);
        }
        this.myEmbedder = embedder;
        this.myTelemetry = telemetry;
        this.myUpdateSnapshots = updateSnapshots;
        this.myImporterSpy = importerSpy;
        this.myLongRunningTask = longRunningTask;
        this.myFilesToResolve = filesToResolve;
        this.myPomHashMap = pomHashMap;
        this.myActiveProfiles = activeProfiles;
        this.myInactiveProfiles = inactiveProfiles;
        this.myWorkspaceMap = workspaceMap;
        this.myLocalRepositoryFile = localRepositoryFile;
        this.userProperties = userProperties;
        this.myResolveInParallel = resolveInParallel;
    }

    @NotNull
    public ArrayList<MavenServerExecutionResult> resolveProjects() {
        ArrayList arrayList;
        try {
            arrayList = (ArrayList)this.myTelemetry.callWithSpan("doResolveProject", () -> this.doResolveProject());
        }
        catch (Exception e) {
            throw this.myEmbedder.wrapToSerializableRuntimeException(e);
        }
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private ArrayList<MavenServerExecutionResult> doResolveProject() {
        List<File> files = this.myFilesToResolve;
        File file = !files.isEmpty() ? files.iterator().next() : null;
        MavenExecutionRequest request = this.myEmbedder.createRequest(file, this.myActiveProfiles, this.myInactiveProfiles, this.userProperties);
        request.setUpdateSnapshots(this.myUpdateSnapshots);
        ArrayList<MavenServerExecutionResult> executionResults = new ArrayList<MavenServerExecutionResult>();
        this.myEmbedder.executeWithMavenSession(request, this.myWorkspaceMap, this.myLongRunningTask.getIndicator(), session -> executionResults.addAll(this.getExecutionResults((MavenSession)session, (Collection<File>)files, request)));
        ArrayList<MavenServerExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private ArrayList<MavenServerExecutionResult> getExecutionResults(MavenSession session, Collection<File> files, MavenExecutionRequest request) {
        ArrayList<MavenServerExecutionResult> executionResults = new ArrayList<MavenServerExecutionResult>();
        try {
            List buildingResults = (List)this.myTelemetry.callWithSpan("getProjectBuildingResults " + files.size(), () -> this.getProjectBuildingResults(request, files, session));
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
            for (ProjectBuildingResult result : buildingResults) {
                MavenProject project = result.getProject();
                if (project == null) continue;
                projects.add(project);
            }
            session.setProjects(projects);
            this.afterProjectsRead(session, exceptions);
            Maven40ProjectResolver.fillSessionCache(session, session.getRepositorySession(), buildingResults);
            boolean runInParallel = this.myResolveInParallel;
            Map<File, String> fileToNewDependencyHash = this.collectHashes(runInParallel, buildingResults);
            ArrayList<ProjectBuildingResultInfo> buildingResultInfos = new ArrayList<ProjectBuildingResultInfo>();
            for (ProjectBuildingResult buildingResult : buildingResults) {
                MavenProject project = buildingResult.getProject();
                String projectId = buildingResult.getProjectId();
                File pomFile = buildingResult.getPomFile();
                List modelProblems = buildingResult.getProblems();
                if (project == null || pomFile == null) {
                    executionResults.add(this.createExecutionResult(pomFile, modelProblems));
                    continue;
                }
                String newDependencyHash = fileToNewDependencyHash.get(pomFile);
                if (!this.transitiveDependenciesChanged(pomFile, newDependencyHash, fileToNewDependencyHash)) {
                    executionResults.add(this.createExecutionResult(project, newDependencyHash));
                    continue;
                }
                buildingResultInfos.add(new ProjectBuildingResultInfo(projectId, project, modelProblems, exceptions, newDependencyHash));
                this.myLongRunningTask.updateTotalRequests(buildingResultInfos.size());
            }
            List execResults = this.myTelemetry.executeWithSpan("resolveBuildingResults", runInParallel, buildingResultInfos, br -> {
                if (this.myLongRunningTask.isCanceled()) {
                    return MavenServerExecutionResult.EMPTY;
                }
                MavenServerExecutionResult result = (MavenServerExecutionResult)this.myTelemetry.callWithSpan("resolveBuildingResult " + br.projectId, () -> this.resolveBuildingResult(session.getRepositorySession(), br.mavenProject, br.modelProblems, br.exceptions, br.dependencyHash));
                this.myLongRunningTask.incrementFinishedRequests();
                return result;
            });
            executionResults.addAll(execResults);
        }
        catch (Exception e) {
            executionResults.add(this.createExecutionResult(e));
        }
        ArrayList<MavenServerExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private boolean transitiveDependenciesChanged(@NotNull File pomFile, String newDependencyHash, Map<File, String> fileToNewDependencyHash) {
        if (pomFile == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(13);
        }
        if (this.dependenciesChanged(pomFile, newDependencyHash)) {
            return true;
        }
        for (File dependencyPomFile : this.myPomHashMap.getFileDependencies(pomFile)) {
            if (!this.dependenciesChanged(dependencyPomFile, fileToNewDependencyHash.get(dependencyPomFile))) continue;
            return true;
        }
        return false;
    }

    private boolean dependenciesChanged(@NotNull File pomFile, String newDependencyHash) {
        String previousDependencyHash;
        if (pomFile == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(14);
        }
        return (previousDependencyHash = this.myPomHashMap.getDependencyHash(pomFile)) == null || !previousDependencyHash.equals(newDependencyHash);
    }

    @NotNull
    private Map<File, String> collectHashes(boolean runInParallel, List<ProjectBuildingResult> buildingResults) {
        ConcurrentHashMap<File, String> fileToNewDependencyHash = new ConcurrentHashMap<File, String>();
        this.myTelemetry.executeWithSpan("dependencyHashes", runInParallel, buildingResults, br -> {
            String newDependencyHash = Maven40EffectivePomDumper.dependencyHash(br.getProject());
            if (null != newDependencyHash) {
                fileToNewDependencyHash.put(br.getPomFile(), newDependencyHash);
            }
            return br;
        });
        ConcurrentHashMap<File, String> concurrentHashMap = fileToNewDependencyHash;
        if (concurrentHashMap == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(15);
        }
        return concurrentHashMap;
    }

    @NotNull
    private MavenServerExecutionResult resolveBuildingResult(RepositorySystemSession repositorySession, MavenProject project, @NotNull List<ModelProblem> modelProblems, List<Exception> exceptions, String dependencyHash) {
        if (modelProblems == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(16);
        }
        try {
            DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
            Set<Artifact> artifacts = this.resolveArtifacts(dependencyResolutionResult);
            project.setArtifacts(artifacts);
            return this.createExecutionResult(exceptions, modelProblems, project, dependencyResolutionResult, dependencyHash);
        }
        catch (Exception e) {
            return this.createExecutionResult(project, e);
        }
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.myEmbedder.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            try {
                RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), null == project.getArtifact() ? Collections.emptyList() : Collections.singletonList(project.getArtifact().getId()), null);
            }
            catch (Exception resolution) {
                // empty catch block
            }
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@NotNull MavenProject mavenProject, String dependencyHash) {
        if (mavenProject == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(17);
        }
        return this.createExecutionResult(mavenProject.getFile(), Collections.emptyList(), Collections.emptyList(), mavenProject, null, dependencyHash, true);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(Exception exception) {
        return this.createExecutionResult(null, exception);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable MavenProject mavenProject, Exception exception) {
        return this.createExecutionResult(Collections.singletonList(exception), Collections.emptyList(), mavenProject, null, null);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(List<Exception> exceptions, List<ModelProblem> modelProblems, @Nullable MavenProject mavenProject, DependencyResolutionResult dependencyResolutionResult, String dependencyHash) {
        File file = null == mavenProject ? null : mavenProject.getFile();
        return this.createExecutionResult(file, exceptions, modelProblems, mavenProject, dependencyResolutionResult, dependencyHash, false);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, List<ModelProblem> modelProblems) {
        return this.createExecutionResult(file, Collections.emptyList(), modelProblems, null, null, null, false);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, @NotNull List<Exception> exceptions, @NotNull List<ModelProblem> modelProblems, @Nullable MavenProject mavenProject, DependencyResolutionResult dependencyResolutionResult, String dependencyHash, boolean dependencyResolutionSkipped) {
        if (exceptions == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(18);
        }
        if (modelProblems == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(19);
        }
        if (null != dependencyResolutionResult && null != dependencyResolutionResult.getCollectionErrors()) {
            exceptions.addAll(dependencyResolutionResult.getCollectionErrors());
        }
        if (null == file && null != mavenProject) {
            file = mavenProject.getFile();
        }
        Collection<MavenProjectProblem> problems = this.myEmbedder.collectProblems(file, exceptions, modelProblems);
        HashSet<MavenProjectProblem> unresolvedProblems = new HashSet<MavenProjectProblem>();
        this.collectUnresolvedArtifactProblems(file, dependencyResolutionResult, unresolvedProblems);
        if (mavenProject == null) {
            return new MavenServerExecutionResult(file, null, problems, Collections.emptySet());
        }
        MavenModel model = new MavenModel();
        Model nativeModel = mavenProject.getModel();
        try {
            DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
            List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
            model = Maven40AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject, nativeModel, dependencyNodes, this.myLocalRepositoryFile);
        }
        catch (Exception e) {
            problems.addAll(this.myEmbedder.collectProblems(mavenProject.getFile(), Collections.singleton(e), modelProblems));
        }
        Map injectedProfilesMap = mavenProject.getInjectedProfileIds();
        ArrayList activatedProfiles = new ArrayList();
        for (List profileList : injectedProfilesMap.values()) {
            activatedProfiles.addAll(profileList);
        }
        Map<String, String> mavenModelMap = Maven40ModelConverter.convertToMap(nativeModel);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, Maven40ProjectResolver.getManagedDependencies(mavenProject), dependencyHash, dependencyResolutionSkipped, mavenModelMap, activatedProfiles);
        if (null == model.getBuild() || null == model.getBuild().getDirectory()) {
            data = null;
        }
        return new MavenServerExecutionResult(file, data, problems, Collections.emptySet(), unresolvedProblems);
    }

    @NotNull
    private static List<MavenArtifactInfo> getManagedDependencies(@Nullable MavenProject project) {
        if (project == null || project.getDependencyManagement() == null || project.getDependencyManagement().getDependencies() == null) {
            List<MavenArtifactInfo> list = Collections.emptyList();
            if (list == null) {
                Maven40ProjectResolver.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<MavenArtifactInfo> list = project.getDependencyManagement().getDependencies().stream().map(dep -> new MavenArtifactInfo(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier())).collect(Collectors.toList());
        if (list == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(21);
        }
        return list;
    }

    private void collectUnresolvedArtifactProblems(@Nullable File file, @Nullable DependencyResolutionResult result, Collection<MavenProjectProblem> problems) {
        if (result == null) {
            return;
        }
        String path = file == null ? "" : file.getPath();
        for (Dependency unresolvedDependency : result.getUnresolvedDependencies()) {
            Iterator iterator = result.getResolutionErrors(unresolvedDependency).iterator();
            if (!iterator.hasNext()) continue;
            Exception exception = (Exception)iterator.next();
            String message = Maven40ServerEmbedderImpl.getRootMessage(exception);
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)unresolvedDependency.getArtifact());
            MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(artifact, this.myLocalRepositoryFile);
            problems.add(MavenProjectProblem.createUnresolvedArtifactProblem((String)path, (String)message, (boolean)false, (MavenArtifact)mavenArtifact));
        }
    }

    @NotNull
    private Set<Artifact> resolveArtifacts(DependencyResolutionResult dependencyResolutionResult) {
        IdentityHashMap<Dependency, Artifact> winnerDependencyMap = new IdentityHashMap<Dependency, Artifact>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Set addedDependencies = Collections.newSetFromMap(new IdentityHashMap());
        Maven40ProjectResolver.resolveConflicts(dependencyResolutionResult, winnerDependencyMap);
        for (Dependency dependency : dependencyResolutionResult.getDependencies()) {
            Artifact artifact = dependency == null ? null : (Artifact)winnerDependencyMap.get(dependency);
            if (artifact == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        ArrayDeque queue = new ArrayDeque(dependencyResolutionResult.getDependencyGraph().getChildren());
        while (!queue.isEmpty()) {
            Artifact artifact;
            DependencyNode node = (DependencyNode)queue.poll();
            queue.addAll(node.getChildren());
            Dependency dependency = node.getDependency();
            if (dependency == null || !addedDependencies.add(dependency) || (artifact = (Artifact)winnerDependencyMap.get(dependency)) == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        LinkedHashSet<Artifact> linkedHashSet = artifacts;
        if (linkedHashSet == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(22);
        }
        return linkedHashSet;
    }

    private static void fillSessionCache(MavenSession mavenSession, RepositorySystemSession session, List<ProjectBuildingResult> buildingResults) {
        int initialCapacity = (int)((double)buildingResults.size() * 1.5);
        HashMap<MavenId, org.apache.maven.api.model.Model> cacheMavenModelMap = new HashMap<MavenId, org.apache.maven.api.model.Model>(initialCapacity);
        HashMap<String, MavenProject> mavenProjectMap = new HashMap<String, MavenProject>(initialCapacity);
        for (ProjectBuildingResult result : buildingResults) {
            if (result.getProblems() != null && !result.getProblems().isEmpty()) continue;
            org.apache.maven.api.model.Model model = result.getProject().getModel().getDelegate();
            String key = ArtifactUtils.key((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion());
            mavenProjectMap.put(key, result.getProject());
            cacheMavenModelMap.put(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
        }
        mavenSession.setProjectMap(mavenProjectMap);
        Maven40WorkspaceMapReader maven40WorkspaceMapReader = null;
        WorkspaceReader reader = session.getWorkspaceReader();
        if (reader instanceof Maven40WorkspaceMapReader) {
            maven40WorkspaceMapReader = (Maven40WorkspaceMapReader)reader;
        } else if (reader instanceof MavenChainedWorkspaceReader) {
            for (WorkspaceReader chainedReader : ((MavenChainedWorkspaceReader)reader).getReaders()) {
                if (!(chainedReader instanceof Maven40WorkspaceMapReader)) continue;
                maven40WorkspaceMapReader = (Maven40WorkspaceMapReader)chainedReader;
                break;
            }
        }
        if (null != maven40WorkspaceMapReader) {
            maven40WorkspaceMapReader.setCacheModelMap(cacheMavenModelMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterProjectsRead(MavenSession session, List<Exception> exceptions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.myEmbedder.getExtensionComponents(Collections.emptyList(), AbstractMavenLifecycleParticipant.class);
        for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
            Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
            try {
                listener.afterProjectsRead(session);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(Maven40ModelConverter.createMavenId(a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private static void resolveConflicts(DependencyResolutionResult dependencyResolutionResult, final Map<Dependency, Artifact> winnerDependencyMap) {
        dependencyResolutionResult.getDependencyGraph().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                Object winner = node.getData().get("conflict.winner");
                Dependency dependency = node.getDependency();
                if (dependency != null && winner == null) {
                    Artifact winnerArtifact = Maven40AetherModelConverter.toArtifact(dependency);
                    winnerDependencyMap.put(dependency, winnerArtifact);
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        }));
    }

    @NotNull
    private List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files, MavenSession session) {
        if (request == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(23);
        }
        if (files == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(24);
        }
        ProjectBuilder builder = this.myEmbedder.getComponent(ProjectBuilder.class);
        ArrayList<ProjectBuildingResult> buildingResults = new ArrayList<ProjectBuildingResult>();
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        projectBuildingRequest.setRepositorySession(session.getRepositorySession());
        projectBuildingRequest.setValidationLevel(30);
        projectBuildingRequest.setActiveProfileIds(request.getActiveProfiles());
        projectBuildingRequest.setInactiveProfileIds(request.getInactiveProfiles());
        projectBuildingRequest.setResolveDependencies(false);
        Maven40ProjectResolver.buildSinglePom(builder, buildingResults, projectBuildingRequest, request.getPom());
        HashSet<File> processedFiles = new HashSet<File>();
        for (ProjectBuildingResult buildingResult : buildingResults) {
            processedFiles.add(buildingResult.getPomFile());
        }
        HashSet<File> nonProcessedFiles = new HashSet<File>(files);
        nonProcessedFiles.removeAll(processedFiles);
        for (File file : nonProcessedFiles) {
            Maven40ProjectResolver.buildSinglePom(builder, buildingResults, projectBuildingRequest, file);
        }
        ArrayList<ProjectBuildingResult> arrayList = buildingResults;
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private static void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            List build = builder.build(Collections.singletonList(pomFile), true, projectBuildingRequest);
            buildingResults.addAll(build);
        }
        catch (ProjectBuildingException e) {
            Maven40ResolverUtil.handleProjectBuildingException(buildingResults, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 15, 20, 21, 22, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerSpy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToResolve";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomHashMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepositoryFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userProperties";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomFile";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProblems";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionResults";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectHashes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagedDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "transitiveDependenciesChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dependenciesChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveBuildingResult";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionResult";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 15, 20, 21, 22, 25 -> new IllegalStateException(string);
        };
    }

    private static class ProjectBuildingResultInfo {
        @NotNull
        String projectId;
        @NotNull
        MavenProject mavenProject;
        @NotNull
        List<ModelProblem> modelProblems;
        @NotNull
        List<Exception> exceptions;
        String dependencyHash;

        private ProjectBuildingResultInfo(@NotNull String projectId, @NotNull MavenProject mavenProject, @NotNull List<ModelProblem> modelProblems, @NotNull List<Exception> exceptions, String dependencyHash) {
            if (projectId == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(0);
            }
            if (mavenProject == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(1);
            }
            if (modelProblems == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(2);
            }
            if (exceptions == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(3);
            }
            this.projectId = projectId;
            this.mavenProject = mavenProject;
            this.modelProblems = modelProblems;
            this.exceptions = exceptions;
            this.dependencyHash = dependencyHash;
        }

        public String toString() {
            return "ProjectBuildingResultData{projectId=" + this.projectId + ", dependencyHash=" + this.dependencyHash + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mavenProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modelProblems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptions";
                    break;
                }
            }
            objectArray[1] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver$ProjectBuildingResultInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

