/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import org.apache.maven.api.cli.Logger;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorWrapper;

public class Maven40ServerConsoleLogger
extends MavenRemoteObject
implements Logger,
MavenServerConsoleIndicatorWrapper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private MavenServerConsoleIndicatorImpl myWrappee;
    private int myThreshold;

    void doPrint(int level, String message, Throwable throwable) {
        if (level < this.myThreshold) {
            return;
        }
        if (!((String)message).endsWith(LINE_SEPARATOR)) {
            message = (String)message + LINE_SEPARATOR;
        }
        if (this.myWrappee != null) {
            this.myWrappee.printMessage(level, (String)message, this.wrapException(throwable));
        }
    }

    public void setWrappee(MavenServerConsoleIndicatorImpl wrappee) {
        this.myWrappee = wrappee;
    }

    public void debug(String string, Throwable throwable) {
        this.doPrint(0, string, throwable);
    }

    public void info(String string, Throwable throwable) {
        this.doPrint(1, string, throwable);
    }

    public void warn(String string, Throwable throwable) {
        this.doPrint(2, string, throwable);
    }

    public void error(String string, Throwable throwable) {
        this.doPrint(3, string, throwable);
    }

    public void fatalError(String string, Throwable throwable) {
        this.doPrint(4, string, throwable);
    }

    public void log(Logger.Level level, String message, Throwable error) {
        switch (level) {
            case DEBUG: {
                this.debug(message, error);
                break;
            }
            case INFO: {
                this.info(message, error);
                break;
            }
            case WARN: {
                this.warn(message, error);
                break;
            }
            case ERROR: {
                this.error(message, error);
            }
        }
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public boolean isDebugEnabled() {
        return this.getThreshold() <= 0;
    }

    public void info(String message) {
        this.info(message, null);
    }

    public boolean isInfoEnabled() {
        return this.getThreshold() <= 1;
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public boolean isWarnEnabled() {
        return this.getThreshold() <= 2;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public boolean isErrorEnabled() {
        return this.getThreshold() <= 3;
    }

    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    public boolean isFatalErrorEnabled() {
        return this.getThreshold() <= 4;
    }

    public void setThreshold(int threshold) {
        this.myThreshold = threshold;
    }

    public int getThreshold() {
        return this.myThreshold;
    }

    public Logger getChildLogger(String s) {
        return null;
    }

    public String getName() {
        return ((Object)((Object)this)).toString();
    }
}

