/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.StringDigestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscriminatingNameMapper
implements NameMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscriminatingNameMapper.class);
    private final NameMapper delegate;
    private final String hostname;

    public DiscriminatingNameMapper(NameMapper delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.hostname = this.getHostname();
    }

    @Override
    public boolean isFileSystemFriendly() {
        return false;
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        String discriminator = this.createDiscriminator(session);
        return this.delegate.nameLocks(session, artifacts, metadatas).stream().map(s -> discriminator + ":" + s).collect(Collectors.toList());
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to get hostname, using '{}'", (Object)"localhost", (Object)e);
            return "localhost";
        }
    }

    private String createDiscriminator(RepositorySystemSession session) {
        String discriminator = ConfigUtils.getString(session, null, "aether.syncContext.named.discriminating.discriminator");
        if (discriminator == null || discriminator.isEmpty()) {
            String hostname = ConfigUtils.getString(session, this.hostname, "aether.syncContext.named.discriminating.hostname");
            File basedir = session.getLocalRepository().getBasedir();
            discriminator = hostname + ":" + basedir;
            try {
                return StringDigestUtil.sha1(discriminator);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to calculate discriminator digest, using '{}'", (Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709", (Object)e);
                return "da39a3ee5e6b4b0d3255bfef95601890afd80709";
            }
        }
        return discriminator;
    }
}

