/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.applet.AppletViewer;
import org.assertj.swing.applet.StatusDisplay;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Maps;

public class BasicAppletContext
implements AppletContext {
    private static final Enumeration<Applet> NO_APPLETS = new EmptyAppletEnumeration();
    private final Map<String, InputStream> streamMap = Maps.newHashMap();
    private final StatusDisplay statusDisplay;

    public BasicAppletContext(@Nonnull StatusDisplay statusDisplay) {
        this.statusDisplay = (StatusDisplay)Preconditions.checkNotNull((Object)statusDisplay);
    }

    @Override
    @Nullable
    public Applet getApplet(@Nullable String name) {
        return BasicAppletContext.appletFrom(this.statusDisplay);
    }

    @Override
    @Nonnull
    public Enumeration<Applet> getApplets() {
        Applet applet = BasicAppletContext.appletFrom(this.statusDisplay);
        return applet == null ? NO_APPLETS : Collections.enumeration(Lists.newArrayList((Object[])new Applet[]{applet}));
    }

    @Nullable
    private static Applet appletFrom(@Nullable StatusDisplay statusDisplay) {
        if (!(statusDisplay instanceof AppletViewer)) {
            return null;
        }
        AppletViewer viewer = (AppletViewer)statusDisplay;
        return viewer.getApplet();
    }

    @Override
    @Nullable
    public AudioClip getAudioClip(@Nullable URL url) {
        return null;
    }

    @Override
    @Nullable
    public Image getImage(@Nullable URL url) {
        return null;
    }

    @Override
    @Nullable
    public InputStream getStream(@Nullable String key) {
        return this.streamMap.get(key);
    }

    @Override
    @Nonnull
    public Iterator<String> getStreamKeys() {
        return this.streamMap.keySet().iterator();
    }

    @Override
    public void setStream(@Nullable String key, @Nullable InputStream stream) {
        if (stream == null) {
            this.streamMap.remove(key);
            return;
        }
        this.streamMap.put(key, stream);
    }

    @Override
    public void showDocument(@Nullable URL url) {
    }

    @Override
    public void showDocument(@Nullable URL url, @Nullable String target) {
    }

    @Override
    public void showStatus(String status) {
        this.statusDisplay.showStatus((String)Preconditions.checkNotNull((Object)status));
    }

    private static final class EmptyAppletEnumeration
    implements Enumeration<Applet> {
        EmptyAppletEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        @Nullable
        public Applet nextElement() {
            return null;
        }
    }
}

