/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core.matcher;

import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.matcher.NamedComponentMatcherTemplate;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class JTextComponentMatcher
extends NamedComponentMatcherTemplate<JTextComponent> {
    private Object text;

    @Nonnull
    public static JTextComponentMatcher withName(@Nullable String name) {
        return new JTextComponentMatcher(name, JTextComponentMatcher.anyValue());
    }

    @Nonnull
    public static JTextComponentMatcher withText(@Nonnull String text) {
        return new JTextComponentMatcher(JTextComponentMatcher.anyValue(), (Object)text);
    }

    @Nonnull
    public static JTextComponentMatcher withText(@Nonnull Pattern textPattern) {
        return new JTextComponentMatcher(JTextComponentMatcher.anyValue(), (Object)textPattern);
    }

    @Nonnull
    public static JTextComponentMatcher any() {
        return new JTextComponentMatcher(JTextComponentMatcher.anyValue(), JTextComponentMatcher.anyValue());
    }

    private JTextComponentMatcher(@Nullable Object name, @Nullable Object text) {
        super(JTextComponent.class, name);
        this.text = text;
    }

    @Nonnull
    public JTextComponentMatcher andText(@Nonnull String newText) {
        this.text = newText;
        return this;
    }

    @Nonnull
    public JTextComponentMatcher andText(@Nonnull Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    @Nonnull
    public JTextComponentMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull JTextComponent textComponent) {
        return this.isNameMatching(textComponent.getName()) && this.arePropertyValuesMatching(this.text, textComponent.getText());
    }

    public String toString() {
        String format = "%s[name=%s, text=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.text), this.requireShowing());
    }
}

