/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.FieldImpl;
import com.jetbrains.jdi.InvokableTypeImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.Packet;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ClassTypeImpl
extends InvokableTypeImpl
implements ClassType {
    private volatile ClassType superclass = null;
    private volatile InterfaceType[] interfaces = null;
    private static final ClassTypeImpl NULL = new ClassTypeImpl(null, -1L);

    protected ClassTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public ClassType superclass() {
        if (this.superclass == null) {
            ClassTypeImpl sup;
            try {
                sup = JDWP.ClassType.Superclass.process((VirtualMachineImpl)this.vm, (ClassTypeImpl)this).superclass;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            this.superclass = ClassTypeImpl.notnullize(sup, NULL);
            return sup;
        }
        return ClassTypeImpl.nullize(this.superclass, NULL);
    }

    @Override
    public CompletableFuture<ClassType> superclassAsync() {
        if (this.superclass != null) {
            return CompletableFuture.completedFuture((ClassType)ClassTypeImpl.nullize(this.superclass, NULL));
        }
        return JDWP.ClassType.Superclass.processAsync(this.vm, this).thenApply(s -> {
            ClassTypeImpl sup = s.superclass;
            this.superclass = ClassTypeImpl.notnullize(sup, NULL);
            return sup;
        });
    }

    @Override
    public List<InterfaceType> interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        return ClassTypeImpl.unmodifiableList(this.interfaces);
    }

    @Override
    public CompletableFuture<List<InterfaceType>> interfacesAsync() {
        if (this.interfaces != null) {
            return CompletableFuture.completedFuture(ClassTypeImpl.unmodifiableList(this.interfaces));
        }
        return this.getInterfacesAsync().thenApply(r -> {
            this.interfaces = r;
            return ClassTypeImpl.unmodifiableList(r);
        });
    }

    @Override
    public List<InterfaceType> allInterfaces() {
        return this.getAllInterfaces();
    }

    @Override
    public List<ClassType> subclasses() {
        ArrayList<ClassType> subs = new ArrayList<ClassType>();
        this.vm.forEachClass(refType -> {
            ClassType clazz;
            ClassType superclass;
            if (refType instanceof ClassType && (superclass = (clazz = (ClassType)refType).superclass()) != null && superclass.equals(this)) {
                subs.add(clazz);
            }
        });
        return subs;
    }

    @Override
    public boolean isEnum() {
        ClassType superclass = this.superclass();
        return superclass != null && superclass.name().equals("java.lang.Enum");
    }

    @Override
    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block5: {
            this.validateMirror(field);
            this.validateMirrorOrNull(value);
            this.validateFieldSet(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Must set non-static field through an instance");
            }
            try {
                JDWP.ClassType.SetValues.FieldValue[] values = new JDWP.ClassType.SetValues.FieldValue[]{new JDWP.ClassType.SetValues.FieldValue(((FieldImpl)field).ref(), ValueImpl.prepareForAssignment(value, (FieldImpl)field))};
                try {
                    JDWP.ClassType.SetValues.process(this.vm, this, values);
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
            }
            catch (ClassNotLoadedException e) {
                if (value == null) break block5;
                throw e;
            }
        }
    }

    PacketStream sendNewInstanceCommand(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        CommandSender sender = () -> JDWP.ClassType.NewInstance.enqueueCommand(this.vm, this, thread, method.ref(), args, options);
        PacketStream stream = (options & 1) != 0 ? thread.sendResumingCommand(sender) : this.vm.sendResumingCommand(sender);
        return stream;
    }

    @Override
    public ObjectReference newInstance(ThreadReference threadIntf, Method methodIntf, List<? extends Value> origArguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        JDWP.ClassType.NewInstance ret;
        this.validateMirror(threadIntf);
        this.validateMirror(methodIntf);
        this.validateMirrorsOrNulls(origArguments);
        MethodImpl method = (MethodImpl)methodIntf;
        ThreadReferenceImpl thread = (ThreadReferenceImpl)threadIntf;
        this.validateConstructorInvocation(method);
        List<Value> arguments = method.validateAndPrepareArgumentsForInvoke(origArguments, options);
        ValueImpl[] args = arguments.toArray(new ValueImpl[0]);
        try {
            PacketStream stream = this.sendNewInstanceCommand(thread, method, args, options);
            ret = JDWP.ClassType.NewInstance.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw exc.toJDIException();
        }
        if ((options & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (ret.exception != null) {
            throw new InvocationException(ret.exception);
        }
        ObjectReferenceImpl newObject = ret.newObject;
        newObject.setType(this);
        return newObject;
    }

    @Override
    public Method concreteMethodByName(String name, String signature) {
        Method method = null;
        for (Method candidate : this.visibleMethods()) {
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature) || candidate.isAbstract()) continue;
            method = candidate;
            break;
        }
        return method;
    }

    void validateConstructorInvocation(Method method) {
        ReferenceTypeImpl declType = (ReferenceTypeImpl)method.declaringType();
        if (!declType.equals(this)) {
            throw new IllegalArgumentException("Invalid constructor");
        }
        if (!method.isConstructor()) {
            throw new IllegalArgumentException("Cannot create instance with non-constructor");
        }
    }

    @Override
    public String toString() {
        return "class " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    CommandSender getInvokeMethodSender(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        return () -> JDWP.ClassType.InvokeMethod.enqueueCommand(this.vm, this, thread, method.ref(), args, options);
    }

    @Override
    InvokableTypeImpl.InvocationResult waitForReply(PacketStream stream) throws JDWPException {
        return new IResult(JDWP.ClassType.InvokeMethod.waitForReply(this.vm, stream));
    }

    @Override
    CompletableFuture<InvokableTypeImpl.InvocationResult> readReply(PacketStream stream) {
        return stream.readReply((Packet packet) -> new JDWP.ClassType.InvokeMethod(this.vm, stream)).thenApply(IResult::new);
    }

    @Override
    boolean canInvoke(Method method) {
        return ((ReferenceTypeImpl)method.declaringType()).isAssignableFrom(this);
    }

    private static class IResult
    implements InvokableTypeImpl.InvocationResult {
        private final JDWP.ClassType.InvokeMethod rslt;

        public IResult(JDWP.ClassType.InvokeMethod rslt) {
            this.rslt = rslt;
        }

        @Override
        public ObjectReferenceImpl getException() {
            return this.rslt.exception;
        }

        @Override
        public ValueImpl getResult() {
            return this.rslt.returnValue;
        }
    }
}

