/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IAnnotationTransformer;
import org.testng.ITestNGMethod;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IIgnoreAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Ignore;
import org.testng.annotations.Listeners;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.annotations.TestInstance;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.JDK15TagFactory;
import org.testng.internal.collections.Pair;

public class JDK15AnnotationFinder
implements IAnnotationFinder {
    private final JDK15TagFactory m_tagFactory = new JDK15TagFactory();
    private final Map<Class<? extends IAnnotation>, Class<? extends Annotation>> m_annotationMap = new ConcurrentHashMap<Class<? extends IAnnotation>, Class<? extends Annotation>>();
    private final Map<String, IAnnotation> m_annotations = new ConcurrentHashMap<String, IAnnotation>();
    private final IAnnotationTransformer m_transformer;

    public JDK15AnnotationFinder(IAnnotationTransformer transformer) {
        this.m_transformer = transformer;
        this.m_annotationMap.put(IListenersAnnotation.class, Listeners.class);
        this.m_annotationMap.put(IDataProviderAnnotation.class, DataProvider.class);
        this.m_annotationMap.put(IFactoryAnnotation.class, Factory.class);
        this.m_annotationMap.put(IObjectFactoryAnnotation.class, ObjectFactory.class);
        this.m_annotationMap.put(IParametersAnnotation.class, Parameters.class);
        this.m_annotationMap.put(ITestAnnotation.class, Test.class);
        this.m_annotationMap.put(IIgnoreAnnotation.class, Ignore.class);
        this.m_annotationMap.put(IBeforeSuite.class, BeforeSuite.class);
        this.m_annotationMap.put(IAfterSuite.class, AfterSuite.class);
        this.m_annotationMap.put(IBeforeTest.class, BeforeTest.class);
        this.m_annotationMap.put(IAfterTest.class, AfterTest.class);
        this.m_annotationMap.put(IBeforeClass.class, BeforeClass.class);
        this.m_annotationMap.put(IAfterClass.class, AfterClass.class);
        this.m_annotationMap.put(IBeforeGroups.class, BeforeGroups.class);
        this.m_annotationMap.put(IAfterGroups.class, AfterGroups.class);
        this.m_annotationMap.put(IBeforeMethod.class, BeforeMethod.class);
        this.m_annotationMap.put(IAfterMethod.class, AfterMethod.class);
    }

    private <A extends Annotation> A findAnnotationInSuperClasses(Class<?> cls, Class<A> a) {
        if (a.equals(Listeners.class)) {
            return AnnotationHelper.getAnnotationFromClass(cls, a);
        }
        while (cls != null) {
            A result = AnnotationHelper.getAnnotationFromClass(cls, a);
            if (result != null) {
                return result;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Method m, Class<A> annotationClass) {
        return this.findAnnotation(null, m, annotationClass);
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Class<?> clazz, Method m, Class<A> annotationClass) {
        Class<? extends Annotation> a = this.m_annotationMap.get(annotationClass);
        if (a == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + annotationClass + "' not found.");
        }
        Annotation annotation = AnnotationHelper.getAnnotationFromMethod(m, a);
        return this.findAnnotation(m.getDeclaringClass(), annotation, annotationClass, null, null, m, new Pair<Annotation, Method>(annotation, m), clazz);
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(ITestNGMethod tm, Class<A> annotationClass) {
        Annotation annotation;
        Class<? extends Annotation> a = this.m_annotationMap.get(annotationClass);
        if (a == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + annotationClass + "' not found.");
        }
        Method m = tm.getConstructorOrMethod().getMethod();
        Class<?> testClass = m.getDeclaringClass();
        if (tm.getInstance() != null) {
            testClass = tm.getInstance().getClass();
        }
        if ((annotation = AnnotationHelper.getAnnotationFromMethod(m, a)) == null) {
            annotation = AnnotationHelper.getAnnotationFromClass(testClass, a);
        }
        return this.findAnnotation(testClass, annotation, annotationClass, null, null, m, new Pair<Annotation, Method>(annotation, m), null);
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(ConstructorOrMethod com, Class<A> annotationClass) {
        if (com.getConstructor() != null) {
            return this.findAnnotation(com.getConstructor(), annotationClass);
        }
        if (com.getMethod() != null) {
            return this.findAnnotation(com.getMethod(), annotationClass);
        }
        return null;
    }

    private void transform(IAnnotation a, Class<?> testClass, Constructor<?> testConstructor, Method testMethod, Class<?> whichClass) {
        if (a instanceof ITestAnnotation) {
            if (this.m_transformer instanceof org.testng.internal.annotations.IAnnotationTransformer) {
                org.testng.internal.annotations.IAnnotationTransformer transformer = (org.testng.internal.annotations.IAnnotationTransformer)this.m_transformer;
                transformer.transform((ITestAnnotation)a, testClass, testConstructor, testMethod, whichClass);
            } else {
                this.m_transformer.transform((ITestAnnotation)a, testClass, testConstructor, testMethod);
            }
        } else if (a instanceof IConfigurationAnnotation) {
            IConfigurationAnnotation configuration = (IConfigurationAnnotation)a;
            this.m_transformer.transform(configuration, testClass, testConstructor, testMethod);
        } else if (a instanceof IDataProviderAnnotation) {
            this.m_transformer.transform((IDataProviderAnnotation)a, testMethod);
        } else if (a instanceof IFactoryAnnotation) {
            this.m_transformer.transform((IFactoryAnnotation)a, testMethod);
        } else if (a instanceof IListenersAnnotation) {
            this.m_transformer.transform((IListenersAnnotation)a, testClass);
        }
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Class<?> cls, Class<A> annotationClass) {
        Class<? extends Annotation> a = this.m_annotationMap.get(annotationClass);
        if (a == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + annotationClass + "' not found.");
        }
        Annotation annotation = this.findAnnotationInSuperClasses(cls, a);
        return this.findAnnotation(cls, annotation, annotationClass, cls, null, null, new Pair(annotation, cls), null);
    }

    @Override
    public <A extends IAnnotation> A findAnnotation(Constructor<?> cons, Class<A> annotationClass) {
        Class<? extends Annotation> a = this.m_annotationMap.get(annotationClass);
        if (a == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + annotationClass + "' not found.");
        }
        Annotation annotation = AnnotationHelper.getAnnotationFromConstructor(cons, a);
        return this.findAnnotation(cons.getDeclaringClass(), annotation, annotationClass, null, cons, null, new Pair(annotation, cons), null);
    }

    @Override
    public <A extends IAnnotation> List<A> findInheritedAnnotations(Class<?> cls, Class<A> annotationClass) {
        Objects.requireNonNull(cls, "Cannot retrieve annotations from a null class.");
        Objects.requireNonNull(annotationClass, "Cannot work with a null annotation");
        Class<? extends Annotation> a = this.m_annotationMap.get(annotationClass);
        if (a == null) {
            throw new IllegalArgumentException("Java @Annotation class for '" + annotationClass + "' not found.");
        }
        ArrayList annotations = new ArrayList();
        if (!a.equals(Listeners.class)) {
            return Collections.emptyList();
        }
        for (Class<?> inter : cls.getInterfaces()) {
            this.findSuperInterface(cls, inter, annotationClass, a, annotations);
        }
        return annotations;
    }

    private <A extends IAnnotation> void findSuperInterface(Class<?> cls, Class<?> inter, Class<A> annotationClass, Class<? extends Annotation> a, List<A> annotations) {
        if (inter.getAnnotation(a) != null) {
            annotations.add(this.findAnnotation(cls, inter.getAnnotation(a), annotationClass, cls, null, null, new Pair<Annotation, Class<A>>(inter.getAnnotation(a), annotationClass), null));
        }
        for (Class<?> superInterface : inter.getInterfaces()) {
            this.findSuperInterface(cls, superInterface, annotationClass, a, annotations);
        }
    }

    private <A extends IAnnotation> A findAnnotation(Class<?> cls, Annotation a, Class<A> annotationClass, Class<?> testClass, Constructor<?> testConstructor, Method testMethod, Pair<Annotation, ?> p, Class<?> whichClass) {
        if (a == null) {
            return null;
        }
        IAnnotation result = this.m_annotations.computeIfAbsent(p.toString(), key -> {
            Object obj = this.m_tagFactory.createTag(cls, testMethod, a, annotationClass);
            this.transform((IAnnotation)obj, testClass, testConstructor, testMethod, whichClass);
            return obj;
        });
        if (whichClass == null && testClass != null) {
            this.transform(result, testClass, testConstructor, testMethod, whichClass);
        }
        return (A)result;
    }

    @Override
    public boolean hasTestInstance(Method method, int i) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length > 0 && annotations[i].length > 0) {
            Annotation[] pa;
            for (Annotation a : pa = annotations[i]) {
                if (!(a instanceof TestInstance)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] findOptionalValues(Method method) {
        return this.optionalValues(method.getParameterAnnotations());
    }

    @Override
    public String[] findOptionalValues(Constructor<?> method) {
        return this.optionalValues(method.getParameterAnnotations());
    }

    private String[] optionalValues(Annotation[][] annotations) {
        String[] result = new String[annotations.length];
        block0: for (int i = 0; i < annotations.length; ++i) {
            for (Annotation a : annotations[i]) {
                if (!(a instanceof Optional)) continue;
                result[i] = ((Optional)a).value();
                continue block0;
            }
        }
        return result;
    }
}

