/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.FileTypeInspectionDisablerKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0000\u00a8\u0006\u0010"}, d2={"enhanceInspectionToolPanel", "Lcom/intellij/codeInspection/options/OptPane;", "tool", "Lcom/intellij/codeInspection/LocalInspectionTool;", "pane", "getFileTypeController", "Lcom/intellij/codeInspection/options/OptionController;", "explicitlyEnabledFileTypes", "", "", "checkInspectionEnabledByFileType", "", "element", "Lcom/intellij/psi/PsiElement;", "explicitlyAllowedFileTypes", "", "intellij.groovy.psi"})
@JvmName(name="GrInspectionUIUtil")
@SourceDebugExtension(value={"SMAP\nui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ui.kt\norg/jetbrains/plugins/groovy/codeInspection/utils/GrInspectionUIUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n37#2:56\n36#2,3:57\n774#3:60\n865#3,2:61\n*S KotlinDebug\n*F\n+ 1 ui.kt\norg/jetbrains/plugins/groovy/codeInspection/utils/GrInspectionUIUtil\n*L\n24#1:56\n24#1:57,3\n45#1:60\n45#1:61,2\n*E\n"})
public final class GrInspectionUIUtil {
    @NotNull
    public static final OptPane enhanceInspectionToolPanel(@NotNull LocalInspectionTool tool, @NotNull OptPane pane) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
        Set<FileType> disableableFileTypes = FileTypeInspectionDisablerKt.getDisableableFileTypes(tool.getClass());
        if (disableableFileTypes.isEmpty()) {
            return pane;
        }
        ArrayList<OptCheckbox> checkboxes = new ArrayList<OptCheckbox>();
        for (FileType fileType : disableableFileTypes) {
            checkboxes.add(OptPane.checkbox((String)fileType.getName(), (String)fileType.getDisplayName(), (OptRegularComponent[])new OptRegularComponent[0]));
        }
        List list = pane.components();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"components(...)");
        Collection $this$toTypedArray$iv = checkboxes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        OptCheckbox[] optCheckboxArray = thisCollection$iv.toArray(new OptCheckbox[0]);
        return new OptPane(CollectionsKt.plus((Collection)list, (Object)OptPane.group((String)GroovyBundle.message("inspection.separator.disable.in.file.types", new Object[0]), (OptRegularComponent[])((OptRegularComponent[])Arrays.copyOf(optCheckboxArray, optCheckboxArray.length))).prefix("fileType")));
    }

    @NotNull
    public static final OptionController getFileTypeController(@NotNull Set<String> explicitlyEnabledFileTypes) {
        Intrinsics.checkNotNullParameter(explicitlyEnabledFileTypes, (String)"explicitlyEnabledFileTypes");
        OptionController optionController = OptionController.of(explicitlyEnabledFileTypes::contains, (arg_0, arg_1) -> GrInspectionUIUtil.getFileTypeController$lambda$0(explicitlyEnabledFileTypes, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"of(...)");
        return optionController;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkInspectionEnabledByFileType(@NotNull LocalInspectionTool tool, @NotNull PsiElement element, @NotNull Set<String> explicitlyAllowedFileTypes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(explicitlyAllowedFileTypes, (String)"explicitlyAllowedFileTypes");
        Set<FileType> disableableFileTypes = FileTypeInspectionDisablerKt.getDisableableFileTypes(tool.getClass());
        if (disableableFileTypes.isEmpty()) {
            return true;
        }
        Iterable $this$filter$iv = disableableFileTypes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType it = (FileType)element$iv$iv;
            boolean bl = false;
            if (!(!explicitlyAllowedFileTypes.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List forbiddenFileTypes = (List)destination$iv$iv;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileTypeRegistry registry = FileTypeRegistry.getInstance();
        for (FileType forbiddenFileType : forbiddenFileTypes) {
            if (!registry.isFileOfType(virtualFile2, forbiddenFileType)) continue;
            return false;
        }
        return true;
    }

    private static final void getFileTypeController$lambda$0(Set $explicitlyEnabledFileTypes, String bindId, Object value) {
        Intrinsics.checkNotNullParameter((Object)bindId, (String)"bindId");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl = (Boolean)value != false ? $explicitlyEnabledFileTypes.add(bindId) : $explicitlyEnabledFileTypes.remove(bindId);
    }
}

