/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class ClassContextFilter {
    private static final Key<Map<String, PsiType>> CACHED_TYPES = Key.create((String)"Cached types");

    public static ContextFilter fromClassPattern(ElementPattern pattern) {
        return (descriptor, ctx) -> {
            PsiType type = descriptor.getPsiType();
            return type instanceof PsiClassType && pattern.accepts((Object)((PsiClassType)type).resolve());
        };
    }

    public static ContextFilter subtypeOf(String typeText) {
        return (descriptor, ctx) -> ClassContextFilter.isSubtype(descriptor.getPsiType(), descriptor.justGetPlaceFile(), typeText);
    }

    public static boolean isSubtype(PsiType checked, PsiFile placeFile, String typeText) {
        PsiClass psiClass;
        boolean isClassType = checked instanceof PsiClassType;
        if (isClassType && (psiClass = ((PsiClassType)checked).resolve()) != null) {
            String rawName;
            int i2 = typeText.indexOf("<");
            String string = rawName = i2 > 0 ? typeText.substring(0, i2) : typeText;
            if (!ClassUtil.getSuperClassesWithCache(psiClass).containsKey(rawName)) {
                return false;
            }
        }
        PsiType myType = ClassContextFilter.getCachedType(typeText, placeFile);
        if (checked == PsiTypes.nullType()) {
            return myType == PsiTypes.nullType();
        }
        return TypesUtil.isAssignableByMethodCallConversion(myType, checked, (PsiElement)placeFile);
    }

    public static PsiType getCachedType(String typeText, PsiFile context) {
        PsiType type;
        ConcurrentHashMap<String, PsiType> map2 = (ConcurrentHashMap<String, PsiType>)context.getUserData(CACHED_TYPES);
        if (map2 == null) {
            map2 = new ConcurrentHashMap<String, PsiType>();
            context.putUserData(CACHED_TYPES, map2);
        }
        if ((type = (PsiType)map2.get(typeText)) == null || !type.isValid()) {
            type = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeText, (PsiElement)context);
            map2.put(typeText, type);
        }
        return type;
    }
}

