/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Consumer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolverKt;
import org.jetbrains.plugins.groovy.lang.resolve.ReferencesKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.StaticMembersFilteringProcessor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\t\u001a\u0014\u0010\n\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\r\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0005H\u0002\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0005H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u0015H\u0002*\u0018\b\u0002\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0016"}, d2={"LookupConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "complete", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "matcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "consumer", "Lorg/jetbrains/plugins/groovy/lang/completion/LookupConsumer;", "processPackageDeclarations", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "processClassDeclarations", "processTypeParameters", "findTypeParameterListCandidate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeParameterList;", "getRootTypeElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeElement;", "isTypeElementChild", "", "Lcom/intellij/psi/PsiElement;", "intellij.groovy"})
@JvmName(name="CompleteCodeReferenceElement")
public final class CompleteCodeReferenceElement {
    public static final void complete(@NotNull GrCodeReferenceElement $this$complete, @NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer) {
        Intrinsics.checkNotNullParameter((Object)$this$complete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement parent = $this$complete.getParent();
        boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)$this$complete);
        CompleteReferenceProcessor processor = new CompleteReferenceProcessor(matcher, consumer, afterNew);
        if (parent instanceof GrImportStatement) {
            if (((GrImportStatement)parent).isStatic()) {
                CompleteCodeReferenceElement.processClassDeclarations($this$complete, processor);
            }
            ElementClassHint.DeclarationKind[] declarationKindArray = new ElementClassHint.DeclarationKind[]{ElementClassHint.DeclarationKind.PACKAGE};
            CompleteCodeReferenceElement.processPackageDeclarations($this$complete, new GrDelegatingScopeProcessorWithHints((PsiScopeProcessor)processor, ElementClassHint.DeclarationKind.CLASS, declarationKindArray));
            return;
        }
        GrDelegatingScopeProcessorWithHints packageProcessor = new GrDelegatingScopeProcessorWithHints((PsiScopeProcessor)processor, ElementClassHint.DeclarationKind.PACKAGE, new ElementClassHint.DeclarationKind[0]);
        if (parent instanceof GrPackageDefinition) {
            CompleteCodeReferenceElement.processPackageDeclarations($this$complete, packageProcessor);
            return;
        }
        CompleteCodeReferenceElement.processTypeParameters($this$complete, processor);
        GrDelegatingScopeProcessorWithHints classProcessor = new GrDelegatingScopeProcessorWithHints((PsiScopeProcessor)processor, ElementClassHint.DeclarationKind.CLASS, new ElementClassHint.DeclarationKind[0]);
        PsiScopeProcessor psiScopeProcessor = classProcessor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"initial(...)");
        GrCodeReferenceResolverKt.processClasses($this$complete, psiScopeProcessor, resolveState);
        if ($this$complete.getQualifier() != null) {
            CompleteCodeReferenceElement.processPackageDeclarations($this$complete, classProcessor);
        }
        CompleteCodeReferenceElement.processPackageDeclarations($this$complete, packageProcessor);
    }

    private static final void processPackageDeclarations(GrCodeReferenceElement $this$processPackageDeclarations, PsiScopeProcessor processor) {
        String string;
        GrCodeReferenceElement qualifier;
        GrCodeReferenceElement grCodeReferenceElement = qualifier = (GrCodeReferenceElement)$this$processPackageDeclarations.getQualifier();
        if (grCodeReferenceElement == null) {
            string = "";
        } else {
            string = grCodeReferenceElement.getQualifiedReferenceName();
            if (string == null) {
                return;
            }
        }
        String qualifierFqn = string;
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)$this$processPackageDeclarations.getProject()).findPackage(qualifierFqn);
        if (psiPackage == null) {
            return;
        }
        PsiPackage parentPackage = psiPackage;
        parentPackage.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)$this$processPackageDeclarations);
    }

    private static final void processClassDeclarations(GrCodeReferenceElement $this$processClassDeclarations, PsiScopeProcessor processor) {
        GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)$this$processClassDeclarations.getQualifier();
        if (grCodeReferenceElement == null) {
            return;
        }
        GrCodeReferenceElement qualifier = grCodeReferenceElement;
        PsiClass psiClass = ReferencesKt.resolveClassFqn(qualifier);
        if (psiClass == null) {
            return;
        }
        PsiClass clazz = psiClass;
        clazz.processDeclarations((PsiScopeProcessor)new StaticMembersFilteringProcessor(processor, null), ResolveState.initial(), null, (PsiElement)$this$processClassDeclarations);
    }

    private static final void processTypeParameters(GrCodeReferenceElement $this$processTypeParameters, PsiScopeProcessor processor) {
        Set set = SetsKt.emptySet();
        GroovyResolveKind.Hint typeParameterProcessor2 = new GroovyResolveKind.Hint(processor, set){

            public <T> T getHint(Key<T> hintKey) {
                Intrinsics.checkNotNullParameter(hintKey, (String)"hintKey");
                return (T)(hintKey == GroovyResolveKind.HINT_KEY ? (Object)this : super.getHint(hintKey));
            }

            public boolean shouldProcess(GroovyResolveKind kind) {
                Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                return kind == GroovyResolveKind.TYPE_PARAMETER;
            }
        };
        GrTypeParameterList grTypeParameterList = CompleteCodeReferenceElement.findTypeParameterListCandidate($this$processTypeParameters);
        if (grTypeParameterList != null) {
            grTypeParameterList.processDeclarations((PsiScopeProcessor)typeParameterProcessor2, ResolveState.initial(), null, $this$processTypeParameters);
        }
        PsiElement psiElement = $this$processTypeParameters;
        PsiScopeProcessor psiScopeProcessor = (PsiScopeProcessor)typeParameterProcessor2;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"initial(...)");
        PsiTreeUtilKt.treeWalkUp$default(psiElement, psiScopeProcessor, resolveState, null, 4, null);
    }

    private static final GrTypeParameterList findTypeParameterListCandidate(GrCodeReferenceElement $this$findTypeParameterListCandidate) {
        GrTypeParameterList grTypeParameterList;
        GrTypeElement grTypeElement = CompleteCodeReferenceElement.getRootTypeElement($this$findTypeParameterListCandidate);
        if (grTypeElement == null) {
            return null;
        }
        GrTypeElement typeElement = grTypeElement;
        PsiElement psiElement = typeElement.getParent();
        if (psiElement instanceof GrTypeDefinitionBody) {
            PsiElement psiElement2 = PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false);
            grTypeParameterList = psiElement2 instanceof GrTypeParameterList ? (GrTypeParameterList)psiElement2 : null;
        } else if (psiElement instanceof GrVariableDeclaration) {
            PsiErrorElement errorElement;
            PsiElement psiElement3 = PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false);
            PsiErrorElement psiErrorElement = errorElement = psiElement3 instanceof PsiErrorElement ? (PsiErrorElement)psiElement3 : null;
            Object object = psiElement3 = psiErrorElement != null ? psiErrorElement.getFirstChild() : null;
            grTypeParameterList = psiElement3 instanceof GrTypeParameterList ? (GrTypeParameterList)psiElement3 : null;
        } else {
            grTypeParameterList = null;
        }
        return grTypeParameterList;
    }

    private static final GrTypeElement getRootTypeElement(GrCodeReferenceElement $this$getRootTypeElement) {
        PsiElement current = $this$getRootTypeElement.getParent();
        while (CompleteCodeReferenceElement.isTypeElementChild(current)) {
            PsiElement parent;
            PsiElement psiElement = current;
            Object object = parent = psiElement != null ? psiElement.getParent() : null;
            if (current instanceof GrTypeElement && !CompleteCodeReferenceElement.isTypeElementChild(parent)) {
                return (GrTypeElement)current;
            }
            current = parent;
        }
        return null;
    }

    private static final boolean isTypeElementChild(PsiElement $this$isTypeElementChild) {
        return $this$isTypeElementChild instanceof GrCodeReferenceElement || $this$isTypeElementChild instanceof GrTypeArgumentList || $this$isTypeElementChild instanceof GrTypeElement;
    }
}

