/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.javaView;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyClassFinder
extends PsiElementFinder {
    private final GroovyShortNamesCache myCache;

    public GroovyClassFinder(Project project) {
        this.myCache = GroovyShortNamesCache.getGroovyShortNamesCache(project);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> classes;
        if (qualifiedName == null) {
            GroovyClassFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GroovyClassFinder.$$$reportNull$$$0(1);
        }
        if ((classes = this.myCache.getClassesByFQName(qualifiedName, scope, true)).isEmpty()) {
            return null;
        }
        if (classes.size() == 1) {
            return classes.get(0);
        }
        return Collections.min(classes, PsiClassUtil.createScopeComparator((GlobalSearchScope)scope).thenComparing(c -> c.getQualifiedName(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(c -> {
            String string;
            PsiFile patt1478$temp = c.getContainingFile();
            if (patt1478$temp instanceof GroovyFileBase) {
                GroovyFileBase groovyFile = (GroovyFileBase)patt1478$temp;
                string = groovyFile.getPackageName();
            } else {
                string = "";
            }
            return string;
        }, Comparator.reverseOrder()));
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> classes;
        if (qualifiedName == null) {
            GroovyClassFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            GroovyClassFinder.$$$reportNull$$$0(3);
        }
        PsiClass[] psiClassArray = (classes = this.myCache.getClassesByFQName(qualifiedName, scope, true)).isEmpty() ? PsiClass.EMPTY_ARRAY : classes.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            GroovyClassFinder.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

