/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;

class CurriedSignature
implements CallSignature<CallParameter> {
    private final CallSignature<?> myOriginal;
    private final int myPosition;
    private final List<? extends Argument> myArguments;

    CurriedSignature(@NotNull CallSignature<?> original, int position, @NotNull List<? extends Argument> arguments2) {
        if (original == null) {
            CurriedSignature.$$$reportNull$$$0(0);
        }
        if (arguments2 == null) {
            CurriedSignature.$$$reportNull$$$0(1);
        }
        this.myOriginal = original;
        this.myPosition = position;
        this.myArguments = arguments2;
    }

    @Override
    public boolean isVararg() {
        return this.myOriginal.isVararg();
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myOriginal.getReturnType();
    }

    @Override
    public int getParameterCount() {
        return this.myOriginal.getParameterCount() - this.myArguments.size();
    }

    @Override
    @NotNull
    public List<CallParameter> getParameters() {
        int argumentCount = this.myArguments.size();
        List<?> originalParameters = this.myOriginal.getParameters();
        int originalParameterCount = originalParameters.size();
        if (this.isVararg()) {
            CallParameter varargParameter = (CallParameter)ContainerUtil.getLastItem(originalParameters);
            List<?> nonVarargParameters = originalParameters.subList(0, originalParameterCount - 1);
            List list = ContainerUtil.concat((List[])new List[]{nonVarargParameters.subList(0, this.myPosition), nonVarargParameters.subList(this.myPosition + argumentCount, nonVarargParameters.size() - 1), Collections.singletonList(varargParameter)});
            if (list == null) {
                CurriedSignature.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.concat(originalParameters.subList(0, this.myPosition), originalParameters.subList(this.myPosition + argumentCount, originalParameterCount));
        if (list == null) {
            CurriedSignature.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public ArgumentMapping<? extends CallParameter> applyTo(@NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        int position;
        if (arguments2 == null) {
            CurriedSignature.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CurriedSignature.$$$reportNull$$$0(5);
        }
        int argumentCount = arguments2.size();
        int n = this.myPosition < 0 ? (this.isVararg() ? this.myPosition + argumentCount + this.myArguments.size() : this.myPosition + this.getParameterCount()) : (position = this.myPosition);
        if (position < 0 || argumentCount < position) {
            return null;
        }
        List uncurriedArguments = ContainerUtil.concat((List[])new List[]{arguments2.subList(0, position), this.myArguments, arguments2.subList(position, argumentCount)});
        return this.myOriginal.applyTo(uncurriedArguments, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/typing/CurriedSignature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/typing/CurriedSignature";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

