/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;

public final class GrMethodConflictUtil {
    private GrMethodConflictUtil() {
    }

    public static void checkMethodConflicts(PsiClass clazz, GrMethod prototype, GrMethod refactoredMethod, MultiMap<PsiElement, String> conflicts, boolean excludeJavaConflicts) {
        List<MethodSignature> prototypeSignatures = GrClosureSignatureUtil.generateAllSignaturesForMethod(prototype, PsiSubstitutor.EMPTY);
        GrMethodConflictUtil.checkForClosurePropertySignatureOverload(clazz, prototype, refactoredMethod, conflicts, prototypeSignatures);
        GrMethodConflictUtil.checkForMethodSignatureOverload(clazz, prototype, refactoredMethod, conflicts, excludeJavaConflicts, prototypeSignatures);
        GrMethodConflictUtil.checkForAccessorOverloading(clazz, prototype, conflicts);
    }

    private static void checkForClosurePropertySignatureOverload(PsiClass clazz, GrMethod prototype, GrMethod refactoredMethod, MultiMap<PsiElement, String> conflicts, List<MethodSignature> prototypeSignatures) {
        PsiType returnType;
        boolean isStatic = prototype.hasModifierProperty("static");
        String name = prototype.getName();
        if (!GroovyPropertyUtils.isProperty(clazz, name, isStatic)) {
            return;
        }
        PsiMethod getter = GroovyPropertyUtils.findPropertyGetter(clazz, name, isStatic, true);
        if (getter instanceof GrMethod) {
            returnType = ((GrMethod)getter).getInferredReturnType();
        } else if (getter instanceof GrAccessorMethod) {
            returnType = ((GrAccessorMethod)getter).getInferredReturnType();
        } else {
            return;
        }
        if (!(returnType instanceof GrClosureType)) {
            return;
        }
        List<GrSignature> signatures2 = ((GrClosureType)returnType).getSignatures();
        for (GrSignature signature : signatures2) {
            block1: for (MethodSignature prototypeSignature : prototypeSignatures) {
                GrClosureParameter[] params = signature.getParameters();
                PsiType[] types = prototypeSignature.getParameterTypes();
                if (types.length != params.length) continue;
                for (int i2 = 0; i2 < types.length; ++i2) {
                    if (!TypesUtil.isAssignableByMethodCallConversion(types[i2], params[i2].getType(), refactoredMethod.getParameterList())) continue block1;
                }
                conflicts.putValue((Object)getter, (Object)GroovyRefactoringBundle.message("refactored.method.will.cover.closure.property", name, RefactoringUIUtil.getDescription((PsiElement)getter.getContainingClass(), (boolean)false)));
            }
        }
    }

    private static void checkForMethodSignatureOverload(PsiClass clazz, GrMethod prototype, GrMethod refactoredMethod, MultiMap<PsiElement, String> conflicts, boolean excludeJavaConflicts, List<MethodSignature> prototypeSignatures) {
        if (excludeJavaConflicts) {
            prototypeSignatures.remove(prototype.getSignature(PsiSubstitutor.EMPTY));
        }
        String newName = prototype.getName();
        PsiMethod[] methods = clazz.findMethodsByName(newName, false);
        MultiMap<MethodSignature, PsiMethod> signatures2 = GrClosureSignatureUtil.findRawMethodSignatures(methods, clazz);
        block0: for (MethodSignature prototypeSignature : prototypeSignatures) {
            for (PsiMethod method : signatures2.get((Object)prototypeSignature)) {
                if (method == refactoredMethod) continue;
                String signaturePresentation = GroovyPresentationUtil.getSignaturePresentation(prototypeSignature);
                conflicts.putValue((Object)method, (Object)GroovyRefactoringBundle.message("method.duplicate", signaturePresentation, RefactoringUIUtil.getDescription((PsiElement)clazz, (boolean)false)));
                continue block0;
            }
        }
    }

    private static void checkForAccessorOverloading(PsiClass clazz, GrMethod prototype, MultiMap<PsiElement, String> conflicts) {
        if (GroovyPropertyUtils.isSimplePropertySetter(prototype)) {
            String propertyName = GroovyPropertyUtils.getPropertyNameBySetter(prototype);
            PsiMethod setter = GroovyPropertyUtils.findPropertySetter(clazz, propertyName, prototype.hasModifierProperty("static"), false);
            if (setter instanceof GrAccessorMethod) {
                conflicts.putValue((Object)setter, (Object)GroovyRefactoringBundle.message("replace.setter.for.property", propertyName));
            }
        } else if (GroovyPropertyUtils.isSimplePropertyGetter(prototype)) {
            boolean isStatic = prototype.hasModifierProperty("static");
            String propertyName = GroovyPropertyUtils.getPropertyNameByGetter(prototype);
            PsiMethod getter = GroovyPropertyUtils.findPropertyGetter(clazz, propertyName, isStatic, false);
            if (getter instanceof GrAccessorMethod) {
                conflicts.putValue((Object)getter, (Object)GroovyRefactoringBundle.message("replace.getter.for.property", propertyName));
            }
        }
    }
}

