/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.externalSystem.ImportedLibraryProperties;
import com.intellij.externalSystem.ImportedLibraryType;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterInterface;
import org.jetbrains.idea.maven.importing.MavenSourceFoldersModuleExtension;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenPathWrapper;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Url;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenRootModelAdapterLegacyImpl
implements MavenRootModelAdapterInterface {
    private final MavenProject myMavenProject;
    private final ModifiableModuleModel myModuleModel;
    private final ModifiableRootModel myRootModel;
    private final MavenSourceFoldersModuleExtension myRootModelModuleExtension;
    private final Set<String> myOrderEntriesBeforeJdk;
    private volatile Map<String, Library> myLibrariesTable;

    public MavenRootModelAdapterLegacyImpl(@NotNull MavenProject p, @NotNull Module module, IdeModifiableModelsProvider rootModelsProvider) {
        if (p == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(1);
        }
        this.myOrderEntriesBeforeJdk = new HashSet<String>();
        this.myMavenProject = p;
        this.myModuleModel = rootModelsProvider.getModifiableModuleModel();
        this.myRootModel = rootModelsProvider.getModifiableRootModel(module);
        this.myRootModelModuleExtension = (MavenSourceFoldersModuleExtension)((Object)this.myRootModel.getModuleExtension(MavenSourceFoldersModuleExtension.class));
        this.myRootModelModuleExtension.init(module, this.myRootModel);
    }

    @Override
    public void init(boolean isNewlyCreatedModule) {
        this.setupInitialValues(isNewlyCreatedModule);
        this.initContentRoots();
        this.initOrderEntries();
    }

    private void setupInitialValues(boolean newlyCreatedModule) {
        if (newlyCreatedModule || this.myRootModel.getSdk() == null) {
            this.myRootModel.inheritSdk();
        }
        if (newlyCreatedModule) {
            this.getCompilerExtension().setExcludeOutput(true);
        }
    }

    private void initContentRoots() {
        Url url = this.toUrl(this.myMavenProject.getDirectory());
        if (this.getContentRootFor(url) != null) {
            return;
        }
        this.myRootModel.addContentEntry(url.getUrl(), MavenRootModelAdapterLegacyImpl.getMavenExternalSource());
    }

    private ContentEntry getContentRootFor(Url url) {
        for (ContentEntry e : this.myRootModel.getContentEntries()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)e.getUrl(), (String)url.getUrl())) continue;
            return e;
        }
        return null;
    }

    private void initOrderEntries() {
        boolean jdkProcessed = false;
        for (OrderEntry e : this.myRootModel.getOrderEntries()) {
            Module m;
            if (e instanceof ModuleSourceOrderEntry || e instanceof JdkOrderEntry) {
                jdkProcessed = true;
                continue;
            }
            if (e instanceof LibraryOrderEntry) {
                if (Registry.is((String)"maven.always.remove.bad.entries")) {
                    if (!MavenRootModelAdapterLegacyImpl.isMavenLibrary((LibraryOrderEntry)e)) {
                        MavenImportCollector.HAS_USER_ADDED_LIBRARY_DEP.log(this.myRootModel.getProject());
                        continue;
                    }
                } else if (!MavenRootModelAdapterLegacyImpl.isMavenLibrary(((LibraryOrderEntry)e).getLibrary())) {
                    MavenImportCollector.HAS_USER_ADDED_LIBRARY_DEP.log(this.myRootModel.getProject());
                    continue;
                }
            }
            if (e instanceof ModuleOrderEntry && (m = ((ModuleOrderEntry)e).getModule()) != null && !MavenProjectsManager.getInstance(this.myRootModel.getProject()).isMavenizedModule(m) && ExternalSystemModulePropertyManager.getInstance((Module)m).getExternalSystemId() == null) {
                MavenImportCollector.HAS_USER_ADDED_MODULE_DEP.log(this.myRootModel.getProject());
                continue;
            }
            if (!jdkProcessed) {
                if (e instanceof ModuleOrderEntry) {
                    this.myOrderEntriesBeforeJdk.add(((ModuleOrderEntry)e).getModuleName());
                } else if (e instanceof LibraryOrderEntry) {
                    this.myOrderEntriesBeforeJdk.add(((LibraryOrderEntry)e).getLibraryName());
                }
            }
            this.myRootModel.removeOrderEntry(e);
        }
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.myRootModel;
    }

    @Override
    public Module getModule() {
        return this.myRootModel.getModule();
    }

    @Override
    public <P extends JpsElement> void addSourceFolder(String path, JpsModuleSourceRootType<P> rootType) {
        this.addSourceFolder(path, rootType, false, (JpsElement)rootType.createDefaultProperties());
    }

    @Override
    public void addGeneratedJavaSourceFolder(String path, JavaSourceRootType rootType) {
        this.addSourceFolder(path, (JpsModuleSourceRootType)rootType, true, (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties("", true));
    }

    private <P extends JpsElement> void addSourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<P> rootType, boolean ifNotEmpty, @NotNull P properties) {
        String[] childs;
        if (path == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(2);
        }
        if (rootType == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(4);
        }
        if (ifNotEmpty ? (childs = new File(this.toPath(path).getPath()).list()) == null || childs.length == 0 : !this.exists(path)) {
            return;
        }
        Url url = this.toUrl(path);
        this.myRootModelModuleExtension.addSourceFolder(url, rootType, properties);
    }

    @Override
    public boolean isAlreadyExcluded(File f) {
        String url = this.toUrl(f.getPath()).getUrl();
        return VfsUtilCore.isUnder((String)url, Arrays.asList(this.myRootModel.getExcludeRootUrls()));
    }

    private boolean exists(String path) {
        return Files.exists(Paths.get(this.toPath(path).getPath(), new String[0]), new LinkOption[0]);
    }

    @Override
    public void addExcludedFolder(String path) {
        this.unregisterAll(path, true, false);
        Url url = this.toUrl(path);
        ContentEntry e = this.getContentRootFor(url);
        if (e == null) {
            return;
        }
        if (e.getUrl().equals(url.getUrl())) {
            return;
        }
        e.addExcludeFolder(url.getUrl(), true);
    }

    @Override
    public void unregisterAll(String path, boolean under, boolean unregisterSources) {
        Url url = this.toUrl(path);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            if (unregisterSources) {
                this.myRootModelModuleExtension.unregisterAll(url, under);
            }
            for (String excludedUrl : eachEntry.getExcludeFolderUrls()) {
                String child;
                String ancestor = under ? url.getUrl() : excludedUrl;
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = under ? excludedUrl : url.getUrl()))) continue;
                eachEntry.removeExcludeFolder(excludedUrl);
            }
            for (String outputUrl : this.getCompilerExtension().getOutputRootUrls(true)) {
                String child;
                String ancestor = under ? url.getUrl() : outputUrl;
                String string = child = under ? outputUrl : url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)child)) continue;
                this.getCompilerExtension().setExcludeOutput(false);
            }
        }
    }

    @Override
    public boolean hasCollision(String sourceRootPath) {
        Url url = this.toUrl(sourceRootPath);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                String child;
                String ancestor = url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = eachFolder.getUrl())) && !VfsUtilCore.isEqualOrAncestor((String)child, (String)ancestor)) continue;
                return true;
            }
            for (String excludeUrl : eachEntry.getExcludeFolderUrls()) {
                String ancestor = url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)excludeUrl) && !VfsUtilCore.isEqualOrAncestor((String)excludeUrl, (String)ancestor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void useModuleOutput(String production, String test) {
        this.getCompilerExtension().inheritCompilerOutputPath(false);
        if (Strings.isEmpty((String)production) && Strings.isEmpty((String)test)) {
            this.getCompilerExtension().inheritCompilerOutputPath(true);
        } else if (Strings.isEmpty((String)test)) {
            this.getCompilerExtension().setCompilerOutputPath(this.toUrl(production).getUrl());
            this.getCompilerExtension().setExcludeOutput(true);
        } else if (Strings.isEmpty((String)production)) {
            this.getCompilerExtension().setCompilerOutputPathForTests(this.toUrl(test).getUrl());
            this.getCompilerExtension().setExcludeOutput(true);
        } else {
            this.getCompilerExtension().setCompilerOutputPath(this.toUrl(production).getUrl());
            this.getCompilerExtension().setCompilerOutputPathForTests(this.toUrl(test).getUrl());
        }
    }

    private CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.myRootModel.getModuleExtension(CompilerModuleExtension.class);
    }

    private Url toUrl(String path) {
        return this.toPath(path).toUrl();
    }

    @Override
    public MavenPathWrapper toPath(String path) {
        return MavenUtil.toPath(this.myMavenProject, path);
    }

    @Override
    public void addModuleDependency(@NotNull String moduleName, @NotNull DependencyScope scope, boolean testJar) {
        if (moduleName == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(6);
        }
        this.myLibrariesTable = null;
        Module m = this.findModuleByName(moduleName);
        ModuleOrderEntry e = m != null ? this.myRootModel.addModuleOrderEntry(m) : (ModuleOrderEntry)ReadAction.compute(() -> this.myRootModel.addInvalidModuleEntry(moduleName));
        e.setScope(scope);
        if (testJar) {
            e.setProductionOnTestDependency(true);
        }
        if (this.myOrderEntriesBeforeJdk.contains(moduleName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    @Override
    @Nullable
    public Module findModuleByName(String moduleName) {
        return this.myModuleModel.findModuleByName(moduleName);
    }

    @Override
    public void addSystemDependency(MavenArtifact artifact, DependencyScope scope) {
        assert ("system".equals(artifact.getScope()));
        String libraryName = artifact.getLibraryName();
        Library library = this.myRootModel.getModuleLibraryTable().getLibraryByName(libraryName);
        if (library == null) {
            library = this.myRootModel.getModuleLibraryTable().createLibrary(libraryName);
        }
        LibraryOrderEntry orderEntry = this.myRootModel.findLibraryOrderEntry(library);
        assert (orderEntry != null);
        orderEntry.setScope(scope);
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        MavenRootModelAdapterLegacyImpl.updateUrl(modifiableModel, OrderRootType.CLASSES, artifact, null, null, true);
        modifiableModel.commit();
        if (this.myOrderEntriesBeforeJdk.contains(libraryName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    @Override
    public LibraryOrderEntry addLibraryDependency(MavenArtifact artifact, DependencyScope scope, IdeModifiableModelsProvider provider, MavenProject project) {
        assert (!"system".equals(artifact.getScope()));
        this.myLibrariesTable = null;
        String libraryName = artifact.getLibraryName();
        Library library = provider.getLibraryByName(libraryName);
        if (library == null) {
            library = provider.createLibrary(libraryName, MavenRootModelAdapterLegacyImpl.getMavenExternalSource());
        }
        Library.ModifiableModel libraryModel = provider.getModifiableLibraryModel(library);
        if (library.getExternalSource() == null) {
            ((LibraryEx.ModifiableModelEx)libraryModel).setExternalSource(MavenRootModelAdapterLegacyImpl.getMavenExternalSource());
        }
        MavenRootModelAdapterLegacyImpl.updateUrl(libraryModel, OrderRootType.CLASSES, artifact, null, null, true);
        MavenRootModelAdapterLegacyImpl.updateUrl(libraryModel, OrderRootType.SOURCES, artifact, MavenExtraArtifactType.SOURCES, project, false);
        MavenRootModelAdapterLegacyImpl.updateUrl(libraryModel, JavadocOrderRootType.getInstance(), artifact, MavenExtraArtifactType.DOCS, project, false);
        if (libraryModel != null) {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)libraryModel;
            PersistentLibraryKind importedLibraryKind = ImportedLibraryType.Companion.getIMPORTED_LIBRARY_KIND();
            if (model.getKind() != importedLibraryKind) {
                model.setKind(importedLibraryKind);
                model.setProperties((LibraryProperties)new ImportedLibraryProperties(new MavenCoordinates(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getPackaging(), artifact.getClassifier())));
            }
        }
        LibraryOrderEntry e = this.myRootModel.addLibraryEntry(library);
        e.setScope(scope);
        if (this.myOrderEntriesBeforeJdk.contains(libraryName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
        return e;
    }

    private void moveLastOrderEntryBeforeJdk() {
        int i2;
        OrderEntry[] entries = (OrderEntry[])this.myRootModel.getOrderEntries().clone();
        for (i2 = entries.length - 1; i2 > 0 && (entries[i2 - 1] instanceof ModuleSourceOrderEntry || entries[i2 - 1] instanceof JdkOrderEntry); --i2) {
            OrderEntry e = entries[i2 - 1];
            entries[i2 - 1] = entries[i2];
            entries[i2] = e;
        }
        if (i2 < entries.length) {
            this.myRootModel.rearrangeOrderEntries(entries);
        }
    }

    private static void updateUrl(Library.ModifiableModel library, OrderRootType type, MavenArtifact artifact, MavenExtraArtifactType artifactType, MavenProject project, boolean clearAll) {
        String classifier = null;
        String extension = null;
        if (artifactType != null) {
            Pair<String, String> result2 = project.getClassifierAndExtension(artifact, artifactType);
            classifier = (String)result2.first;
            extension = (String)result2.second;
        }
        String newPath = artifact.getPathForExtraArtifact(classifier, extension);
        String newUrl = VirtualFileManager.constructUrl((String)"jar", (String)newPath) + "!/";
        boolean urlExists = false;
        for (String url : library.getUrls(type)) {
            if (newUrl.equals(url)) {
                urlExists = true;
                continue;
            }
            if (!clearAll && (!MavenRootModelAdapterLegacyImpl.isRepositoryUrl(artifact, url) || url.startsWith(newUrl))) continue;
            library.removeRoot(url, type);
        }
        if (!urlExists) {
            library.addRoot(newUrl, type);
        }
    }

    private static boolean isRepositoryUrl(MavenArtifact artifact, String url) {
        return url.contains(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + artifact.getBaseVersion() + "/" + artifact.getArtifactId() + "-");
    }

    @Override
    public Library findLibrary(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(7);
        }
        return this.getOrCreateLibrariesTable().get(artifact.getLibraryName());
    }

    private Map<String, Library> getOrCreateLibrariesTable() {
        Map<String, Library> table = this.myLibrariesTable;
        if (table == null) {
            HashMap<String, Library> temp = new HashMap<String, Library>();
            this.myRootModel.orderEntries().forEachLibrary(library -> {
                temp.put(library.getName(), (Library)library);
                return true;
            });
            this.myLibrariesTable = temp;
            return temp;
        }
        return table;
    }

    public static boolean isMavenLibrary(@Nullable Library library) {
        return library != null && MavenArtifact.isMavenLibrary((String)library.getName());
    }

    public static boolean isMavenLibrary(@Nullable LibraryOrderEntry entry) {
        return entry != null && MavenArtifact.isMavenLibrary((String)entry.getLibraryName());
    }

    public static ProjectModelExternalSource getMavenExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getSourceById("Maven");
    }

    @Override
    public void setLanguageLevel(LanguageLevel level) {
        try {
            level = MavenImportUtil.adjustLevelAndNotify(this.myRootModel.getProject(), level);
            ((LanguageLevelModuleExtension)this.myRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenRootModelAdapterLegacyImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourceFolder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleDependency";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

