/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import icons.ExternalSystemIcons;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.navigator.structure.GoalNode;
import org.jetbrains.idea.maven.navigator.structure.GoalsGroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.project.MavenProject;

abstract class MavenGoalNode
extends MavenSimpleNode
implements GoalNode {
    private final MavenProject myMavenProject = this.findParentProjectNode().getMavenProject();
    private final String myGoal;
    private final String myDisplayName;

    MavenGoalNode(MavenProjectsStructure structure, GoalsGroupNode parent, String goal, String displayName) {
        super(structure, parent);
        this.myGoal = goal;
        this.myDisplayName = displayName;
        this.getTemplatePresentation().setIcon(ExternalSystemIcons.Task);
    }

    @Override
    public MavenSimpleNode.MavenNodeType getType() {
        return MavenSimpleNode.MavenNodeType.GOAL;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.myMavenProject;
    }

    @Override
    public String getProjectPath() {
        return this.myMavenProject.getPath();
    }

    @Override
    public String getGoal() {
        return this.myGoal;
    }

    public String getName() {
        return this.myDisplayName;
    }

    @Override
    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            MavenGoalNode.$$$reportNull$$$0(0);
        }
        String s1 = StringUtil.nullize((String)this.myMavenProjectsStructure.getShortcutsManager().getDescription(this.myMavenProject, this.myGoal));
        String s2 = StringUtil.nullize((String)this.myMavenProjectsStructure.getTasksManager().getDescription(this.myMavenProject, this.myGoal));
        Object hint = s1 == null ? s2 : (s2 == null ? s1 : s1 + ", " + s2);
        this.setNameAndTooltip(presentation, this.getName(), null, (String)hint);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        SimpleTextAttributes original = super.getPlainAttributes();
        int style = original.getStyle();
        Color color = original.getFgColor();
        boolean custom = false;
        if ("test".equals(this.myGoal) && MavenRunner.getInstance(this.myProject).getSettings().isSkipTests()) {
            color = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
            style |= 4;
            custom = true;
        }
        if (this.myGoal.equals(this.myMavenProject.getDefaultGoal())) {
            style |= 1;
            custom = true;
        }
        if (custom) {
            return original.derive(style, color, null, null);
        }
        return original;
    }

    @Override
    @Nullable
    @NonNls
    protected String getActionId() {
        return "Maven.RunBuild";
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "Maven.BuildMenu";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "org/jetbrains/idea/maven/navigator/structure/MavenGoalNode", "doUpdate"));
    }
}

