/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.icons.AllIcons;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.idea.maven.navigator.structure.GroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.PluginNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectNode;
import org.jetbrains.idea.maven.project.MavenPluginWithArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

@ApiStatus.Internal
public final class PluginsNode
extends GroupNode {
    private final List<PluginNode> myPluginNodes = new CopyOnWriteArrayList<PluginNode>();

    PluginsNode(MavenProjectsStructure structure, ProjectNode parent) {
        super(structure, parent);
        this.getTemplatePresentation().setIcon(AllIcons.Nodes.ConfigFolder);
    }

    public String getName() {
        return MavenProjectBundle.message("view.node.plugins", new Object[0]);
    }

    @Override
    protected List<? extends MavenSimpleNode> doGetChildren() {
        return this.myPluginNodes;
    }

    public void updatePlugins(MavenProject mavenProject) {
        List<MavenPluginWithArtifact> pluginsInfos = mavenProject.getDeclaredPluginInfos();
        this.myMavenProjectsStructure.updatePluginsTree(this, pluginsInfos);
    }

    public List<PluginNode> getPluginNodes() {
        return this.myPluginNodes;
    }
}

