/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenWrapperEventLogNotification;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.MavenLog;

public final class MavenWrapperDownloader {
    public static void checkOrInstall(@NotNull Project project, @Nullable String workingDir) {
        if (project == null) {
            MavenWrapperDownloader.$$$reportNull$$$0(0);
        }
        MavenWrapperDownloader.checkOrInstall(project, workingDir, null, true);
    }

    public static void checkOrInstallForSync(@NotNull Project project, @Nullable String workingDir, boolean showNotificationIfUrlMissing) {
        if (project == null) {
            MavenWrapperDownloader.$$$reportNull$$$0(1);
        }
        MavenWrapperDownloader.checkOrInstall(project, workingDir, MavenProjectsManager.getInstance(project).getSyncConsole(), showNotificationIfUrlMissing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void checkOrInstall(@NotNull Project project, @Nullable String workingDir, @Nullable MavenSyncConsole syncConsole, boolean showNotificationIfUrlMissing) {
        String multiModuleDir;
        if (project == null) {
            MavenWrapperDownloader.$$$reportNull$$$0(2);
        }
        if (workingDir == null) {
            return;
        }
        MavenDistributionsCache distributionsCache = MavenDistributionsCache.getInstance(project);
        String distributionUrl = distributionsCache.getWrapperDistributionUrl(multiModuleDir = distributionsCache.getMultimoduleDirectory(workingDir));
        if (distributionUrl == null) {
            if (showNotificationIfUrlMissing) {
                MavenWrapperEventLogNotification.noDistributionUrlEvent(project, multiModuleDir);
            }
            return;
        }
        MavenDistribution distribution = MavenWrapperSupport.getCurrentDistribution(project, distributionUrl);
        if (distribution != null) {
            return;
        }
        MavenLog.LOG.info("start install wrapper " + distributionUrl);
        if (syncConsole != null) {
            syncConsole.startWrapperResolving();
        }
        Task.Backgroundable task = MavenWrapperDownloader.getTaskInfo();
        WrapperProgressIndicator indicator = new WrapperProgressIndicator(project, task, syncConsole);
        try {
            distribution = new MavenWrapperSupport().downloadAndInstallMaven(distributionUrl, (ProgressIndicator)indicator, project);
            if (syncConsole != null && distributionUrl.toLowerCase(Locale.ENGLISH).startsWith("http:")) {
                MavenWrapperSupport.showUnsecureWarning(syncConsole, LocalFileSystem.getInstance().findFileByPath(multiModuleDir));
            }
            distributionsCache.addWrapper(multiModuleDir, distribution);
            if (syncConsole != null) {
                syncConsole.finishWrapperResolving(null);
            }
        }
        catch (Exception e) {
            MavenLog.LOG.warn("error install wrapper", (Throwable)e);
            if (syncConsole != null) {
                syncConsole.finishWrapperResolving(e);
            }
            MavenWrapperEventLogNotification.errorDownloading(project, e.getLocalizedMessage());
            if (syncConsole != null) {
                MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
                settings.getGeneralSettings().setMavenHomeType(BundledMaven3.INSTANCE);
            }
        }
        finally {
            indicator.finish((TaskInfo)task);
            MavenLog.LOG.info("finish install wrapper " + distributionUrl);
        }
    }

    @NotNull
    private static Task.Backgroundable getTaskInfo() {
        return new Task.Backgroundable(null, SyncBundle.message("maven.sync.wrapper.downloading", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/server/MavenWrapperDownloader$1", "run"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/idea/maven/server/MavenWrapperDownloader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrInstall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrInstallForSync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WrapperProgressIndicator
    extends BackgroundableProcessIndicator {
        private long myFraction;
        private final MavenSyncConsole mySyncConsole;

        private WrapperProgressIndicator(@NotNull Project project, @NotNull Task.Backgroundable task, @Nullable MavenSyncConsole syncConsole) {
            if (project == null) {
                WrapperProgressIndicator.$$$reportNull$$$0(0);
            }
            if (task == null) {
                WrapperProgressIndicator.$$$reportNull$$$0(1);
            }
            super(project, (TaskInfo)task);
            this.myFraction = 0L;
            this.mySyncConsole = syncConsole;
        }

        public void setText(String text) {
            super.setText(text);
            if (this.mySyncConsole != null && text != null) {
                this.mySyncConsole.addWrapperProgressText(text);
            }
        }

        public void setFraction(double fraction) {
            super.setFraction(fraction);
            if (this.mySyncConsole != null) {
                long newFraction = Math.round(fraction * 100.0);
                if (this.myFraction == newFraction) {
                    return;
                }
                this.myFraction = newFraction;
                ProgressBuildEventImpl event = new ProgressBuildEventImpl((Object)SyncBundle.message("maven.sync.wrapper", new Object[0]), (Object)SyncBundle.message("maven.sync.wrapper", new Object[0]), System.currentTimeMillis(), SyncBundle.message("maven.sync.wrapper.downloading.progress", this.myFraction, 100), 100L, this.myFraction, "%");
                this.mySyncConsole.addBuildEvent((BuildEvent)event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/server/MavenWrapperDownloader$WrapperProgressIndicator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

