/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRProjectViewModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRSelectPullRequestForFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRSelectPullRequestForFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRSelectPullRequestForFileAction.kt\norg/jetbrains/plugins/github/pullrequest/action/GHPRSelectPullRequestForFileAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,50:1\n58#2:51\n30#2,2:74\n4135#3,11:52\n4135#3,11:63\n*S KotlinDebug\n*F\n+ 1 GHPRSelectPullRequestForFileAction.kt\norg/jetbrains/plugins/github/pullrequest/action/GHPRSelectPullRequestForFileAction\n*L\n30#1:51\n44#1:74,2\n37#1:52,11\n43#1:63,11\n*E\n"})
public final class GHPRSelectPullRequestForFileAction
extends DumbAwareAction {
    public GHPRSelectPullRequestForFileAction() {
        super(GithubBundle.messagePointer("pull.request.select.action", new Object[0]), GHPRSelectPullRequestForFileAction::_init_$lambda$0, AllIcons.General.Locate);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        void $this$filterIsInstanceTo$iv$iv;
        GHPRConnectedProjectViewModel projectVm;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
        boolean $i$f$serviceIfCreated = false;
        StateFlow<GHPRConnectedProjectViewModel> stateFlow = (StateFlow<GHPRConnectedProjectViewModel>)$this$serviceIfCreated$iv.getServiceIfCreated(GHPRProjectViewModel.class);
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel = stateFlow != null && (stateFlow = stateFlow.getConnectedProjectVm()) != null ? (GHPRConnectedProjectViewModel)stateFlow.getValue() : (projectVm = null);
        if (projectVm == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        Object[] $this$filterIsInstance$iv = virtualFileArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GHPRTimelineVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GHPRTimelineVirtualFile file = (GHPRTimelineVirtualFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        e.getPresentation().setEnabled(file != null && Intrinsics.areEqual((Object)file.getRepository(), (Object)projectVm.getRepository()));
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project2).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        Object[] $this$filterIsInstance$iv = virtualFileArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GHPRTimelineVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GHPRTimelineVirtualFile file = (GHPRTimelineVirtualFile)CollectionsKt.first((List)((List)destination$iv$iv));
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<GHPRProjectViewModel> serviceClass$iv = GHPRProjectViewModel.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GHPRProjectViewModel)object).activateAndAwaitProject((Function1<? super GHPRConnectedProjectViewModel, Unit>)((Function1)arg_0 -> GHPRSelectPullRequestForFileAction.actionPerformed$lambda$1(file, arg_0)));
    }

    private static final String _init_$lambda$0() {
        return null;
    }

    private static final Unit actionPerformed$lambda$1(GHPRTimelineVirtualFile $file, GHPRConnectedProjectViewModel $this$activateAndAwaitProject) {
        Intrinsics.checkNotNullParameter((Object)$this$activateAndAwaitProject, (String)"$this$activateAndAwaitProject");
        if (Intrinsics.areEqual((Object)$file.getRepository(), (Object)$this$activateAndAwaitProject.getRepository())) {
            GHPRConnectedProjectViewModel.viewPullRequest$default($this$activateAndAwaitProject, $file.getPullRequest(), false, 2, null);
        }
        return Unit.INSTANCE;
    }
}

