/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.DefaultModuleComponentIdentifier;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.AuxiliaryArtifactResolver;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.AuxiliaryConfigurationArtifacts;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyAuxiliaryArtifactResolver
implements AuxiliaryArtifactResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final GradleDependencyDownloadPolicy policy;
    @NotNull
    private final Map<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts;

    public LegacyAuxiliaryArtifactResolver(@NotNull Project project, @NotNull GradleDependencyDownloadPolicy policy, @NotNull Map<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts) {
        if (project == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(1);
        }
        if (resolvedArtifacts == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(2);
        }
        this.project = project;
        this.policy = policy;
        this.resolvedArtifacts = resolvedArtifacts;
    }

    @Override
    @NotNull
    public AuxiliaryConfigurationArtifacts resolve(@NotNull Configuration configuration) {
        List<Class<? extends Artifact>> artifactTypes;
        if (configuration == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(3);
        }
        if ((artifactTypes = this.getRequiredArtifactTypes()).isEmpty()) {
            return new AuxiliaryConfigurationArtifacts(Collections.emptyMap(), Collections.emptyMap());
        }
        ArrayList<ModuleComponentIdentifier> components = new ArrayList<ModuleComponentIdentifier>();
        for (Collection collection : this.resolvedArtifacts.values()) {
            for (ResolvedArtifact artifact : collection) {
                if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) continue;
                ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                components.add(DefaultModuleComponentIdentifier.create(id));
            }
        }
        if (components.isEmpty()) {
            return new AuxiliaryConfigurationArtifacts(Collections.emptyMap(), Collections.emptyMap());
        }
        Set componentResults = this.getDependencyHandler(configuration).createArtifactResolutionQuery().forComponents(components).withArtifacts(JvmLibrary.class, artifactTypes).execute().getResolvedComponents();
        return LegacyAuxiliaryArtifactResolver.classify(componentResults);
    }

    @NotNull
    private List<Class<? extends Artifact>> getRequiredArtifactTypes() {
        ArrayList<Class<? extends Artifact>> artifactTypes = new ArrayList<Class<? extends Artifact>>(2);
        if (this.policy.isDownloadSources()) {
            artifactTypes.add(SourcesArtifact.class);
        }
        if (this.policy.isDownloadJavadoc()) {
            artifactTypes.add(JavadocArtifact.class);
        }
        ArrayList<Class<? extends Artifact>> arrayList = artifactTypes;
        if (arrayList == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private DependencyHandler getDependencyHandler(@NotNull Configuration configuration) {
        ScriptHandler buildscript;
        boolean isBuildScriptConfiguration;
        if (configuration == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(5);
        }
        DependencyHandler dependencyHandler = (isBuildScriptConfiguration = (buildscript = this.project.getBuildscript()).getConfigurations().contains((Object)configuration)) ? buildscript.getDependencies() : this.project.getDependencies();
        if (dependencyHandler == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(6);
        }
        return dependencyHandler;
    }

    @NotNull
    private static AuxiliaryConfigurationArtifacts classify(@NotNull Set<ComponentArtifactsResult> components) {
        if (components == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(7);
        }
        HashMap<ComponentIdentifier, Set<File>> sources = new HashMap<ComponentIdentifier, Set<File>>();
        HashMap<ComponentIdentifier, Set<File>> javadocs = new HashMap<ComponentIdentifier, Set<File>>();
        for (ComponentArtifactsResult component : components) {
            ComponentIdentifier componentId = component.getId();
            LegacyAuxiliaryArtifactResolver.putIfNotNull(sources, componentId, LegacyAuxiliaryArtifactResolver.getResolvedAuxiliaryArtifactFiles(component, SourcesArtifact.class));
            LegacyAuxiliaryArtifactResolver.putIfNotNull(javadocs, componentId, LegacyAuxiliaryArtifactResolver.getResolvedAuxiliaryArtifactFiles(component, JavadocArtifact.class));
        }
        return new AuxiliaryConfigurationArtifacts(sources, javadocs);
    }

    @NotNull
    private static Set<File> getResolvedAuxiliaryArtifactFiles(@NotNull ComponentArtifactsResult artifactsResult, @NotNull Class<? extends Artifact> artifactType) {
        if (artifactsResult == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(8);
        }
        if (artifactType == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(9);
        }
        Set<File> set = artifactsResult.getArtifacts(artifactType).stream().filter(ResolvedArtifactResult.class::isInstance).map(ResolvedArtifactResult.class::cast).map(ResolvedArtifactResult::getFile).collect(Collectors.toSet());
        if (set == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static <K, V> void putIfNotNull(@NotNull Map<K, V> target, @NotNull K key, @Nullable V value) {
        if (target == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(11);
        }
        if (key == null) {
            LegacyAuxiliaryArtifactResolver.$$$reportNull$$$0(12);
        }
        if (value != null) {
            target.put(key, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArtifacts";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/auxiliary/LegacyAuxiliaryArtifactResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsResult";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/auxiliary/LegacyAuxiliaryArtifactResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredArtifactTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedAuxiliaryArtifactFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedAuxiliaryArtifactFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

