/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.StructureVisitor;

public class Element
extends Particle
implements Structure {
    private final Name name;
    private final ComplexType complexType;

    public Element(SourceLocation sourceLocation, Annotation annotation, Name name, ComplexType complexType) {
        super(sourceLocation, annotation);
        this.name = name;
        this.complexType = complexType;
    }

    public Name getName() {
        return this.name;
    }

    public ComplexType getComplexType() {
        return this.complexType;
    }

    public Object accept(ParticleVisitor particleVisitor) {
        return particleVisitor.visitElement(this);
    }

    public Object accept(StructureVisitor structureVisitor) {
        return structureVisitor.visitElement(this);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Element element = (Element)object;
        return this.name.equals(element.name) && this.complexType.equals(element.complexType);
    }

    public int hashCode() {
        return super.hashCode() ^ this.name.hashCode() ^ this.complexType.hashCode();
    }
}

