/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.swift;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.swiftinc.relax.schema.Grammar;
import jp.co.swiftinc.relax.schema.SchemaLoader;
import jp.co.swiftinc.relax.schema.SchemaSyntaxErrorException;
import jp.gr.xml.relax.sax.RELAXEntityResolver;
import jp.gr.xml.relax.swift.SwiftSchema;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierException;
import org.iso_relax.verifier.VerifierFactory;
import org.iso_relax.verifier.VerifierFactoryLoader;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SwiftVerifierFactory
extends VerifierFactory
implements VerifierFactoryLoader {
    public Schema compileSchema(InputSource source) throws VerifierConfigurationException, SAXException {
        return new SwiftSchema(this.loadSchema(source));
    }

    private DocumentBuilder _getDocumentBuilder() throws VerifierConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RELAXEntityResolver());
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new VerifierConfigurationException(e);
        }
    }

    private Grammar loadSchema(InputSource source) throws VerifierConfigurationException, SAXException {
        try {
            DocumentBuilder builder = this._getDocumentBuilder();
            Document doc = builder.parse(source);
            return SchemaLoader.load((Document)doc, (String)source.getSystemId());
        }
        catch (SchemaSyntaxErrorException e) {
            throw new VerifierException((Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new VerifierException(e);
        }
        catch (IOException e) {
            throw new VerifierException(e);
        }
    }

    public VerifierFactory createFactory(String schemaLanguage) {
        if (schemaLanguage.equals("http://www.xml.gr.jp/xmlns/relaxCore")) {
            return this;
        }
        return null;
    }
}

