/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Iterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class CacheOneStepIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> myProbableIterator;
    private T myPreCalculated;

    public CacheOneStepIterator(Iterator<? extends T> probableIterator) {
        this.myProbableIterator = probableIterator;
        this.step();
    }

    private void step() {
        this.myPreCalculated = !this.myProbableIterator.hasNext() ? null : this.myProbableIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.myPreCalculated != null;
    }

    @Override
    public T next() {
        T result = this.myPreCalculated;
        this.step();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

