/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import java.util.concurrent.ThreadLocalRandom;

public final class FrugalQuantileEstimator {
    private int targetPercentileToEstimate;
    private double currentEstimation;
    private final double step;

    public FrugalQuantileEstimator(int percentileToEstimate, double step) {
        this(percentileToEstimate, step, 0.0);
    }

    public FrugalQuantileEstimator(int percentileToEstimate, double step, double initialEstimation) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("step(=" + step + ") must be >0");
        }
        this.updateTargetPercentile(percentileToEstimate);
        this.currentEstimation = initialEstimation;
        this.step = step;
    }

    public double updateEstimation(int value) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int randomValue100 = rnd.nextInt(100);
        if ((double)value > this.currentEstimation && randomValue100 <= this.targetPercentileToEstimate) {
            this.currentEstimation += this.step;
        } else if ((double)value < this.currentEstimation && randomValue100 > this.targetPercentileToEstimate) {
            this.currentEstimation -= this.step;
        }
        return this.currentEstimation();
    }

    public void updateTargetPercentile(int newPercentileToEstimate) {
        if (newPercentileToEstimate <= 0 || newPercentileToEstimate >= 100) {
            throw new IllegalArgumentException("percentileToEstimate(=" + newPercentileToEstimate + ") must be in (0, 100)");
        }
        this.targetPercentileToEstimate = newPercentileToEstimate;
    }

    public int percentileToEstimate() {
        return this.targetPercentileToEstimate;
    }

    public double currentEstimation() {
        return this.currentEstimation;
    }

    public String toString() {
        return "FrugalQuantileEstimator[target: " + this.targetPercentileToEstimate + " %-ile, current: " + this.currentEstimation + ", step: " + this.step + ']';
    }
}

