/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage.lf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.IAppenderStream;
import com.intellij.util.io.storage.IDataTable;
import com.intellij.util.io.storage.IRecordsTable;
import com.intellij.util.io.storage.IStorage;
import com.intellij.util.io.storage.IStorageDataOutput;
import com.intellij.util.io.storage.RecordIdIterator;
import com.intellij.util.io.storage.lf.AbstractRecordsTableLF;
import com.intellij.util.io.storage.lf.DataTableLF;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractStorageLF
implements IStorage,
CleanableStorage {
    public static final StorageLockContext SHARED = new StorageLockContext(true, true);
    public static final int PAGE_SIZE = SystemProperties.getIntProperty("idea.io.page.size", 8192);
    protected static final Logger LOG = Logger.getInstance(AbstractStorageLF.class);
    @NonNls
    public static final String INDEX_EXTENSION = ".storageRecordIndex";
    @NonNls
    public static final String DATA_EXTENSION = ".storageData";
    private final Path storagePath;
    protected IRecordsTable recordsTable;
    protected IDataTable dataTable;
    protected StorageLockContext context;
    private final CapacityAllocationPolicy capacityAllocationPolicy;

    public static boolean deleteFiles(String storageFilePath) {
        File recordsFile = new File(storageFilePath + INDEX_EXTENSION);
        File dataFile = new File(storageFilePath + DATA_EXTENSION);
        boolean deletedRecordsFile = FileUtil.delete(recordsFile);
        boolean deletedDataFile = FileUtil.delete(dataFile);
        return deletedRecordsFile && deletedDataFile;
    }

    public static boolean deleteFiles(@NotNull Path storageFilePath) {
        if (storageFilePath == null) {
            AbstractStorageLF.$$$reportNull$$$0(0);
        }
        Path recordsFile = storageFilePath.getParent().resolve(storageFilePath.getFileName() + INDEX_EXTENSION);
        Path dataFile = storageFilePath.getParent().resolve(storageFilePath.getFileName() + DATA_EXTENSION);
        boolean deletedRecordsFile = false;
        try {
            deletedRecordsFile = Files.deleteIfExists(recordsFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean deletedDataFile = false;
        try {
            deletedDataFile = Files.deleteIfExists(dataFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return deletedRecordsFile && deletedDataFile;
    }

    protected AbstractStorageLF(@NotNull Path storageFilePath) throws IOException {
        if (storageFilePath == null) {
            AbstractStorageLF.$$$reportNull$$$0(1);
        }
        this(storageFilePath, SHARED);
    }

    protected AbstractStorageLF(@NotNull Path storageFilePath, @NotNull StorageLockContext context) throws IOException {
        if (storageFilePath == null) {
            AbstractStorageLF.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AbstractStorageLF.$$$reportNull$$$0(3);
        }
        this(storageFilePath, context, CapacityAllocationPolicy.DEFAULT);
    }

    protected AbstractStorageLF(@NotNull Path storageFilePath, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        if (storageFilePath == null) {
            AbstractStorageLF.$$$reportNull$$$0(4);
        }
        this(storageFilePath, SHARED, capacityAllocationPolicy);
    }

    protected AbstractStorageLF(@NotNull Path storageFilePath, @NotNull StorageLockContext context, @Nullable CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        if (storageFilePath == null) {
            AbstractStorageLF.$$$reportNull$$$0(5);
        }
        if (context == null) {
            AbstractStorageLF.$$$reportNull$$$0(6);
        }
        this.storagePath = storageFilePath;
        this.capacityAllocationPolicy = capacityAllocationPolicy != null ? capacityAllocationPolicy : CapacityAllocationPolicy.DEFAULT;
        this.tryInit(storageFilePath, context, 0);
    }

    private void tryInit(@NotNull Path storageFilePath, StorageLockContext context, int retryCount) throws IOException {
        IDataTable dataTable;
        boolean dFExists;
        if (storageFilePath == null) {
            AbstractStorageLF.$$$reportNull$$$0(7);
        }
        Path parentDir = storageFilePath.getParent();
        Path recordsFile = parentDir.resolve(storageFilePath.getFileName() + INDEX_EXTENSION);
        Path dataFile = parentDir.resolve(storageFilePath.getFileName() + DATA_EXTENSION);
        boolean rFExists = Files.exists(recordsFile, new LinkOption[0]);
        if (rFExists != (dFExists = Files.exists(dataFile, new LinkOption[0]))) {
            rFExists = false;
            dFExists = false;
        }
        if (!rFExists) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        if (!rFExists) {
            AbstractStorageLF.createOrTruncateFile(recordsFile);
        }
        if (!dFExists) {
            AbstractStorageLF.createOrTruncateFile(dataFile);
        }
        IRecordsTable recordsTable = null;
        try {
            recordsTable = this.createRecordsTable(context, recordsFile);
            dataTable = AbstractStorageLF.createDataTable(context, dataFile);
        }
        catch (IOException e) {
            boolean deleted;
            LOG.info(e.getMessage());
            if (recordsTable != null) {
                IOUtil.closeSafe(LOG, recordsTable);
            }
            if (!(deleted = AbstractStorageLF.deleteFiles(storageFilePath))) {
                throw new IOException("Can't delete caches at: " + storageFilePath);
            }
            if (retryCount >= 5) {
                throw new IOException("Can't create storage at: " + storageFilePath);
            }
            this.tryInit(storageFilePath, context, retryCount + 1);
            return;
        }
        this.recordsTable = recordsTable;
        this.dataTable = dataTable;
        this.context = context;
        if (this.dataTable.isCompactNecessary()) {
            this.compact(storageFilePath);
        }
    }

    @NotNull
    private static IDataTable createDataTable(@NotNull StorageLockContext context, @NotNull Path dataFile) throws IOException {
        if (context == null) {
            AbstractStorageLF.$$$reportNull$$$0(8);
        }
        if (dataFile == null) {
            AbstractStorageLF.$$$reportNull$$$0(9);
        }
        return new DataTableLF(dataFile, context);
    }

    protected abstract IRecordsTable createRecordsTable(@NotNull StorageLockContext var1, @NotNull Path var2) throws IOException;

    private void compact(@NotNull Path path) {
        if (path == null) {
            AbstractStorageLF.$$$reportNull$$$0(10);
        }
        this.withWriteLock(() -> {
            LOG.info("Space waste in " + path + " is " + this.dataTable.getWaste() + " bytes. Compacting now.");
            long start = System.currentTimeMillis();
            try {
                Path parentDir = path.getParent();
                Path newDataFile = parentDir.resolve(path.getFileName() + ".storageData.backup");
                Files.createDirectories(parentDir, new FileAttribute[0]);
                AbstractStorageLF.createOrTruncateFile(newDataFile);
                Path oldDataFile = parentDir.resolve(path.getFileName() + DATA_EXTENSION);
                IDataTable newDataTable = AbstractStorageLF.createDataTable(this.context, newDataFile);
                RecordIdIterator recordIterator = this.recordsTable.createRecordIdIterator();
                while (recordIterator.hasNextId()) {
                    int recordId = recordIterator.nextId();
                    long addr = this.recordsTable.getAddress(recordId);
                    int size = this.recordsTable.getSize(recordId);
                    if (size <= 0) continue;
                    assert (addr > 0L);
                    int capacity = this.capacityAllocationPolicy.calculateCapacity(size);
                    long newaddr = newDataTable.allocateSpace(capacity);
                    byte[] bytes = new byte[size];
                    this.dataTable.readBytes(addr, bytes);
                    newDataTable.writeBytes(newaddr, bytes);
                    this.recordsTable.setAddress(recordId, newaddr);
                    this.recordsTable.setCapacity(recordId, capacity);
                }
                this.dataTable.close();
                newDataTable.close();
                Files.move(newDataFile, oldDataFile, StandardCopyOption.REPLACE_EXISTING);
                this.dataTable = AbstractStorageLF.createDataTable(this.context, oldDataFile);
            }
            catch (IOException e) {
                LOG.info("Compact failed", e);
            }
            long timedelta = System.currentTimeMillis() - start;
            LOG.info("Done compacting in " + timedelta + "msec.");
        });
    }

    private static void createOrTruncateFile(@NotNull Path path) throws IOException {
        if (path == null) {
            AbstractStorageLF.$$$reportNull$$$0(11);
        }
        Files.newByteChannel(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE).close();
    }

    @Override
    public int getVersion() throws IOException {
        return (Integer)this.withReadLock(() -> this.recordsTable.getVersion());
    }

    @Override
    public void setVersion(int expectedVersion) throws IOException {
        this.withWriteLock(() -> this.recordsTable.setVersion(expectedVersion));
    }

    @Override
    public void force() throws IOException {
        this.withWriteLock(() -> {
            this.dataTable.force();
            this.recordsTable.force();
        });
    }

    @Override
    public boolean isDirty() {
        return this.dataTable.isDirty() || this.recordsTable.isDirty();
    }

    @Override
    @TestOnly
    public int getLiveRecordsCount() throws IOException {
        return (Integer)this.withReadLock(() -> this.recordsTable.getLiveRecordsCount());
    }

    @Override
    @TestOnly
    public RecordIdIterator createRecordIdIterator() throws IOException {
        return this.recordsTable.createRecordIdIterator();
    }

    @Override
    public StorageDataOutput writeStream(int record) {
        return this.writeStream(record, false);
    }

    @Override
    public StorageDataOutput writeStream(int record, boolean fixedSize) {
        return new StorageDataOutput(this, record, fixedSize);
    }

    @Override
    public AppenderStream appendStream(int record) {
        return new AppenderStream(record);
    }

    @Override
    public DataInputStream readStream(int record) throws IOException {
        byte[] bytes = this.readBytes(record);
        return new DataInputStream(new UnsyncByteArrayInputStream(bytes));
    }

    protected byte[] readBytes(int record) throws IOException {
        return (byte[])this.withReadLock(() -> {
            int length = this.recordsTable.getSize(record);
            if (length == 0 || AbstractRecordsTableLF.isSizeOfRemovedRecord(length)) {
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
            assert (length > 0) : length;
            long address = this.recordsTable.getAddress(record);
            byte[] result = new byte[length];
            this.dataTable.readBytes(address, result);
            return result;
        });
    }

    protected void appendBytes(int record, ByteArraySequence bytes) throws IOException {
        int delta = bytes.getLength();
        if (delta == 0) {
            return;
        }
        this.withWriteLock(() -> {
            int capacity = this.recordsTable.getCapacity(record);
            int oldSize = this.recordsTable.getSize(record);
            int newSize = oldSize + delta;
            if (newSize > capacity) {
                if (oldSize > 0) {
                    byte[] newbytes = new byte[newSize];
                    System.arraycopy(this.readBytes(record), 0, newbytes, 0, oldSize);
                    System.arraycopy(bytes.getInternalBuffer(), bytes.getOffset(), newbytes, oldSize, delta);
                    this.writeBytes(record, new ByteArraySequence(newbytes), false);
                } else {
                    this.writeBytes(record, bytes, false);
                }
            } else {
                long address = this.recordsTable.getAddress(record) + (long)oldSize;
                this.dataTable.writeBytes(address, bytes.getInternalBuffer(), bytes.getOffset(), bytes.getLength());
                this.recordsTable.setSize(record, newSize);
            }
        });
    }

    @Override
    public void writeBytes(int record, @NotNull ByteArraySequence bytes, boolean fixedSize) throws IOException {
        if (bytes == null) {
            AbstractStorageLF.$$$reportNull$$$0(12);
        }
        this.withWriteLock(() -> {
            long address;
            int requiredLength = bytes.getLength();
            int currentCapacity = this.recordsTable.getCapacity(record);
            int currentSize = this.recordsTable.getSize(record);
            assert (currentSize >= 0);
            if (requiredLength == 0 && currentSize == 0) {
                return;
            }
            if (currentCapacity >= requiredLength) {
                address = this.recordsTable.getAddress(record);
            } else {
                int newCapacity;
                this.dataTable.reclaimSpace(currentCapacity);
                int n = newCapacity = fixedSize ? requiredLength : this.capacityAllocationPolicy.calculateCapacity(requiredLength);
                if (newCapacity < requiredLength) {
                    newCapacity = requiredLength;
                }
                address = this.dataTable.allocateSpace(newCapacity);
                this.recordsTable.setAddress(record, address);
                this.recordsTable.setCapacity(record, newCapacity);
            }
            this.dataTable.writeBytes(address, bytes.getInternalBuffer(), bytes.getOffset(), bytes.getLength());
            this.recordsTable.setSize(record, requiredLength);
        });
    }

    protected void doDeleteRecord(int record) throws IOException {
        this.dataTable.reclaimSpace(this.recordsTable.getCapacity(record));
        this.recordsTable.deleteRecord(record);
    }

    @Override
    public void dispose() {
        this.withWriteLock(() -> {
            IOUtil.closeSafe(LOG, this.recordsTable);
            IOUtil.closeSafe(LOG, this.dataTable);
        });
    }

    @Override
    public void closeAndClean() throws IOException {
        Disposer.dispose(this);
        AbstractStorageLF.deleteFiles(this.storagePath);
    }

    @Override
    public void checkSanity(int record) throws IOException {
        this.withReadLock(() -> {
            int size = this.recordsTable.getSize(record);
            int capacity = this.recordsTable.getCapacity(record);
            long address = this.recordsTable.getAddress(record);
            long dataFileSize = this.dataTable.getFileSize();
            assert (size >= 0) : "[#" + record + "]: size(=" + size + ") must not be negative";
            assert (capacity >= 0) : "[#" + record + "]: capacity(=" + capacity + ") -- must NOT be negative";
            assert (address >= 0L) : "[#" + record + "]: address(=" + address + ") must not be negative";
            assert (size <= capacity) : "[#" + record + "]: size(=" + size + ") > capacity(=" + capacity + ")";
            assert (address + (long)capacity <= dataFileSize) : "[#" + record + "]: address(=" + address + ")+capacity(=" + size + ") is beyond EOF(=" + dataFileSize + ")";
        });
    }

    @Override
    public void replaceBytes(int record, int offset, @NotNull ByteArraySequence bytes) throws IOException {
        if (bytes == null) {
            AbstractStorageLF.$$$reportNull$$$0(13);
        }
        this.withWriteLock(() -> {
            int changedBytesLength = bytes.getLength();
            int currentSize = this.recordsTable.getSize(record);
            assert (currentSize >= 0);
            assert (offset + bytes.getLength() <= currentSize);
            if (changedBytesLength == 0) {
                return;
            }
            long address = this.recordsTable.getAddress(record);
            this.dataTable.writeBytes(address + (long)offset, bytes.getInternalBuffer(), bytes.getOffset(), bytes.getLength());
        });
    }

    protected <T, E extends Throwable> T withReadLock(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            AbstractStorageLF.$$$reportNull$$$0(14);
        }
        return ConcurrencyUtil.withLock(this.context.readLock(), runnable);
    }

    protected <E extends Throwable> void withReadLock(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            AbstractStorageLF.$$$reportNull$$$0(15);
        }
        ConcurrencyUtil.withLock(this.context.readLock(), runnable);
    }

    protected <T, E extends Throwable> T withWriteLock(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            AbstractStorageLF.$$$reportNull$$$0(16);
        }
        return ConcurrencyUtil.withLock(this.context.writeLock(), runnable);
    }

    protected <E extends Throwable> void withWriteLock(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            AbstractStorageLF.$$$reportNull$$$0(17);
        }
        ConcurrencyUtil.withLock(this.context.writeLock(), runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFilePath";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/storage/lf/AbstractStorageLF";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDataTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "compact";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrTruncateFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBytes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceBytes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "withReadLock";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "withWriteLock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class StorageDataOutput
    extends DataOutputStream
    implements IStorageDataOutput {
        private final AbstractStorageLF myStorage;
        private final int myRecordId;
        private final boolean myFixedSize;

        private StorageDataOutput(AbstractStorageLF storage, int recordId, boolean fixedSize) {
            super(new BufferExposingByteArrayOutputStream());
            this.myStorage = storage;
            this.myRecordId = recordId;
            this.myFixedSize = fixedSize;
        }

        @Override
        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream byteStream = this.getByteStream();
            this.myStorage.writeBytes(this.myRecordId, byteStream.toByteArraySequence(), this.myFixedSize);
        }

        private BufferExposingByteArrayOutputStream getByteStream() {
            return (BufferExposingByteArrayOutputStream)this.out;
        }

        @Override
        public int getRecordId() {
            return this.myRecordId;
        }

        @Override
        @NotNull
        public ByteArraySequence asByteArraySequence() {
            ByteArraySequence byteArraySequence = this.getByteStream().asByteArraySequence();
            if (byteArraySequence == null) {
                StorageDataOutput.$$$reportNull$$$0(0);
            }
            return byteArraySequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/storage/lf/AbstractStorageLF$StorageDataOutput", "asByteArraySequence"));
        }
    }

    public final class AppenderStream
    extends DataOutputStream
    implements IAppenderStream {
        private final int myRecordId;

        private AppenderStream(int recordId) {
            super(new BufferExposingByteArrayOutputStream());
            this.myRecordId = recordId;
        }

        @Override
        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            AbstractStorageLF.this.appendBytes(this.myRecordId, _out.toByteArraySequence());
        }

        private BufferExposingByteArrayOutputStream getByteStream() {
            return (BufferExposingByteArrayOutputStream)this.out;
        }

        @Override
        @NotNull
        public ByteArraySequence asByteArraySequence() {
            ByteArraySequence byteArraySequence = this.getByteStream().asByteArraySequence();
            if (byteArraySequence == null) {
                AppenderStream.$$$reportNull$$$0(0);
            }
            return byteArraySequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/storage/lf/AbstractStorageLF$AppenderStream", "asByteArraySequence"));
        }
    }
}

