/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.system;

import com.intellij.execution.Platform;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OS {
    Windows,
    macOS,
    Linux,
    FreeBSD,
    Other;

    @NotNull
    public final String version = OS.getOsVersion();
    public static final OS CURRENT;

    @NotNull
    public static OS fromString(@Nullable String os) {
        if (os != null) {
            if ((os = os.toLowerCase(Locale.ENGLISH)).startsWith("windows")) {
                OS oS = Windows;
                if (oS == null) {
                    OS.$$$reportNull$$$0(0);
                }
                return oS;
            }
            if (os.startsWith("mac")) {
                OS oS = macOS;
                if (oS == null) {
                    OS.$$$reportNull$$$0(1);
                }
                return oS;
            }
            if (os.startsWith("linux")) {
                OS oS = Linux;
                if (oS == null) {
                    OS.$$$reportNull$$$0(2);
                }
                return oS;
            }
            if (os.startsWith("freebsd")) {
                OS oS = FreeBSD;
                if (oS == null) {
                    OS.$$$reportNull$$$0(3);
                }
                return oS;
            }
        }
        OS oS = Other;
        if (oS == null) {
            OS.$$$reportNull$$$0(4);
        }
        return oS;
    }

    private static String getOsVersion() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version", "unknown").toLowerCase(Locale.ENGLISH);
        if (name.startsWith("Windows") && name.matches("Windows \\d+")) {
            try {
                String version2 = name.substring("Windows".length() + 1) + ".0";
                if (Float.parseFloat(version2) > Float.parseFloat(version)) {
                    version = version2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return version;
    }

    @NotNull
    public Platform getPlatform() {
        Platform platform = this == Windows ? Platform.WINDOWS : Platform.UNIX;
        if (platform == null) {
            OS.$$$reportNull$$$0(5);
        }
        return platform;
    }

    static {
        CURRENT = OS.fromString(System.getProperty("os.name"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/system/OS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

