/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoExecutionContext;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoRegistration;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SingleThreadIoEventLoop
extends SingleThreadEventLoop
implements IoEventLoop {
    private static final long DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS = TimeUnit.MILLISECONDS.toNanos(Math.max(100, SystemPropertyUtil.getInt("io.netty.eventLoop.maxTaskProcessingQuantumMs", 1000)));
    private final long maxTaskProcessingQuantumNs;
    private final IoExecutionContext context = new IoExecutionContext(){

        @Override
        public boolean canBlock() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return !SingleThreadIoEventLoop.this.hasTasks() && !SingleThreadIoEventLoop.this.hasScheduledTasks();
        }

        @Override
        public long delayNanos(long currentTimeNanos) {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.delayNanos(currentTimeNanos);
        }

        @Override
        public long deadlineNanos() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.deadlineNanos();
        }
    };
    private final IoHandler ioHandler;
    private int numRegistrations;
    private final FutureListener<Object> decrementRegistrationListener = f -> {
        assert (this.inEventLoop());
        --this.numRegistrations;
    };

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, ThreadFactory threadFactory, IoHandler ioHandler) {
        super((EventLoopGroup)parent, threadFactory, false, true);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler) {
        super((EventLoopGroup)parent, executor, false, true);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, ThreadFactory threadFactory, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, long maxTaskProcessingQuantumMs) {
        super((EventLoopGroup)parent, threadFactory, false, true, maxPendingTasks, rejectedExecutionHandler);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
        this.maxTaskProcessingQuantumNs = ObjectUtil.checkPositiveOrZero(maxTaskProcessingQuantumMs, "maxTaskProcessingQuantumMs") == 0L ? DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS : maxTaskProcessingQuantumMs;
    }

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, long maxTaskProcessingQuantumMs) {
        super((EventLoopGroup)parent, executor, false, true, maxPendingTasks, rejectedExecutionHandler);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
        this.maxTaskProcessingQuantumNs = ObjectUtil.checkPositiveOrZero(maxTaskProcessingQuantumMs, "maxTaskProcessingQuantumMs") == 0L ? DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS : maxTaskProcessingQuantumMs;
    }

    protected SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler, Queue<Runnable> taskQueue, Queue<Runnable> tailTaskQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parent, executor, false, true, taskQueue, tailTaskQueue, rejectedExecutionHandler);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
    }

    @Override
    protected void run() {
        assert (this.inEventLoop());
        do {
            this.runIo();
            if (this.isShuttingDown()) {
                this.ioHandler.prepareToDestroy();
            }
            this.runAllTasks(this.maxTaskProcessingQuantumNs);
        } while (!this.confirmShutdown() && !this.canSuspend());
    }

    protected final IoHandler ioHandler() {
        return this.ioHandler;
    }

    @Override
    protected boolean canSuspend(int state) {
        return super.canSuspend(state) && this.numRegistrations == 0;
    }

    protected int runIo() {
        assert (this.inEventLoop());
        return this.ioHandler.run(this.context);
    }

    @Override
    public IoEventLoop next() {
        return this;
    }

    @Override
    public final Future<IoRegistration> register(IoHandle handle) {
        Promise<IoRegistration> promise = this.newPromise();
        if (this.inEventLoop()) {
            this.registerForIo0(handle, promise);
        } else {
            this.execute(() -> this.registerForIo0(handle, promise));
        }
        return promise;
    }

    private void registerForIo0(IoHandle handle, Promise<IoRegistration> promise) {
        IoRegistration registration;
        assert (this.inEventLoop());
        try {
            registration = this.ioHandler.register(this, handle);
        }
        catch (Exception e) {
            promise.setFailure(e);
            return;
        }
        registration.cancelFuture().addListener(this.decrementRegistrationListener);
        ++this.numRegistrations;
        promise.setSuccess(registration);
    }

    @Override
    protected final void wakeup(boolean inEventLoop) {
        this.ioHandler.wakeup(this);
    }

    @Override
    protected final void cleanup() {
        assert (this.inEventLoop());
        this.ioHandler.destroy();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return this.ioHandler.isCompatible(handleType);
    }

    @Override
    public boolean isIoType(Class<? extends IoHandler> handlerType) {
        return this.ioHandler.getClass().equals(handlerType);
    }
}

