/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Parent;
import org.jdom.Verifier;

public final class EntityRef
extends Content {
    private String name;

    public EntityRef(String name) {
        this(name, null, null);
    }

    public EntityRef(String name, String systemID) {
        this(name, null, systemID);
    }

    public EntityRef(String name, String publicID, String systemID) {
        super(Content.CType.EntityRef);
        this.setName(name);
        this.setPublicID(publicID);
        this.setSystemID(systemID);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return "";
    }

    public EntityRef setName(String name) {
        String reason = Verifier.checkXMLName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "EntityRef", reason);
        }
        this.name = name;
        return this;
    }

    public EntityRef setPublicID(String publicID) {
        String reason = Verifier.checkPublicID(publicID);
        if (reason != null) {
            throw new IllegalDataException(publicID, "EntityRef", reason);
        }
        return this;
    }

    public EntityRef setSystemID(String systemID) {
        String reason = Verifier.checkSystemLiteral(systemID);
        if (reason != null) {
            throw new IllegalDataException(systemID, "EntityRef", reason);
        }
        return this;
    }

    public String toString() {
        return "[EntityRef: &" + this.name + ";]";
    }

    @Override
    public EntityRef detach() {
        return (EntityRef)super.detach();
    }

    @Override
    protected EntityRef setParent(Parent parent) {
        return (EntityRef)super.setParent(parent);
    }

    @Override
    public Element getParent() {
        return (Element)super.getParent();
    }

    @Override
    public EntityRef clone() {
        return (EntityRef)super.clone();
    }
}

