/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run.terminal;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.sh.run.ShDefaultShellPathProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;

final class ShTerminalShellPathProvider
implements ShDefaultShellPathProvider {
    private final Project myProject;

    ShTerminalShellPathProvider(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public String getDefaultShell() {
        TerminalProjectOptionsProvider terminalProjectOptionsProvider = TerminalProjectOptionsProvider.getInstance((Project)this.myProject);
        String shellPathWithoutDefault = terminalProjectOptionsProvider.getShellPathWithoutDefault$intellij_terminal();
        if (shellPathWithoutDefault != null) {
            String string = shellPathWithoutDefault;
            if (string == null) {
                ShTerminalShellPathProvider.$$$reportNull$$$0(0);
            }
            return string;
        }
        return ShTerminalShellPathProvider.findDefaultShellPath();
    }

    @NotNull
    private static String findDefaultShellPath() {
        Path shellPath;
        if (SystemInfo.isWindows) {
            return "powershell.exe";
        }
        String shell = System.getenv("SHELL");
        Path path = shellPath = shell != null ? NioFiles.toPath((String)shell) : null;
        if (shellPath != null && Files.exists(shellPath, new LinkOption[0])) {
            String string = shell;
            if (string == null) {
                ShTerminalShellPathProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        Path bashPath = NioFiles.toPath((String)"/bin/bash");
        if (bashPath != null && Files.exists(bashPath, new LinkOption[0])) {
            String string = bashPath.toString();
            if (string == null) {
                ShTerminalShellPathProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "/bin/sh";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sh/run/terminal/ShTerminalShellPathProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShell";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefaultShellPath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

