/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

final class Constants {
    /*
     * WARNING - void declaration
     */
    static void checkAsmExperimental(Object caller) {
        Class<?> callerClass = caller.getClass();
        String internalName = callerClass.getName().replace('.', '/');
        if (!Constants.isWhitelisted(internalName)) {
            void var1_1;
            Class<?> clazz;
            Constants.checkIsPreview(clazz.getClassLoader().getResourceAsStream((String)var1_1 + ".class"));
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean isWhitelisted(String internalName) {
        String string;
        void var1_1;
        if (!internalName.startsWith("org/jetbrains/coverage/org/objectweb/asm/")) {
            return false;
        }
        String member = "(Annotation|Class|Field|Method|Module|RecordComponent|Signature)";
        return internalName.contains("Test$") || Pattern.matches("org/jetbrains/coverage/org/objectweb/asm/util/Trace" + member + "Visitor(\\$.*)?", internalName) || Pattern.matches("org/jetbrains/coverage/org/objectweb/asm/util/Check" + (String)var1_1 + "Adapter(\\$.*)?", string);
    }

    /*
     * WARNING - void declaration
     */
    static void checkIsPreview(InputStream classInputStream) {
        void var0_1;
        if (classInputStream == null) {
            throw new IllegalStateException("Bytecode not available, can't check class version");
        }
        try {
            DataInputStream callerClassStream = new DataInputStream(classInputStream);
            try {
                callerClassStream.readInt();
                int minorVersion = callerClassStream.readUnsignedShort();
            }
            catch (Throwable minorVersion) {
                try {
                    callerClassStream.close();
                }
                catch (Throwable throwable) {}
                throw minorVersion;
            }
            callerClassStream.close();
        }
        catch (IOException ioe) {
            void var1_4;
            throw new IllegalStateException("I/O error, can't check class version", (Throwable)var1_4);
        }
        if (var0_1 != 65535) {
            throw new IllegalStateException("ASM9_EXPERIMENTAL can only be used by classes compiled with --enable-preview");
        }
    }
}

