/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesKt;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.render.RootCell;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.NewUiRootCellRenderer;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/ui/table/column/Root;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "Lcom/intellij/vcs/log/ui/render/RootCell;", "<init>", "()V", "isResizable", "", "()Z", "getValue", "model", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "row", "", "Lcom/intellij/vcs/log/ui/table/VcsLogTableIndex;", "createTableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "getStubValue", "equals", "other", "", "hashCode", "toString", "", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogDefaultColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogDefaultColumn.kt\ncom/intellij/vcs/log/ui/table/column/Root\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
public final class Root
extends VcsLogDefaultColumn<RootCell> {
    @NotNull
    public static final Root INSTANCE = new Root();
    private static final boolean isResizable;

    private Root() {
        super("Default.Root", "", false, null);
    }

    @Override
    public boolean isResizable() {
        return isResizable;
    }

    @Override
    @Nullable
    public RootCell getValue(@NotNull GraphTableModel model, int row) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        VisiblePack visiblePack = model.getVisiblePack();
        if (FileHistoryPaths.hasPathsInformation(visiblePack)) {
            Integer n = model.getId(row);
            if (n == null) {
                return null;
            }
            int commit = n;
            FilePath path = FileHistoryPaths.filePathOrDefault(visiblePack, commit);
            if (path != null) {
                return new RootCell.RealCommit(path);
            }
        }
        VirtualFile virtualFile = model.getRootAtRow(row);
        if (virtualFile != null) {
            VirtualFile p0 = virtualFile;
            boolean bl = false;
            filePath = VcsUtil.getFilePath((VirtualFile)p0);
        } else {
            filePath = null;
        }
        FilePath filePath2 = filePath;
        return new RootCell.RealCommit(filePath2);
    }

    @Override
    @NotNull
    public TableCellRenderer createTableCellRenderer(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        VcsLogUiProperties vcsLogUiProperties = table.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperties, (String)"getProperties(...)");
        VcsLogUiPropertiesKt.onPropertyChange(vcsLogUiProperties, table, arg_0 -> Root.createTableCellRenderer$lambda$0(table, arg_0));
        if (ExperimentalUI.Companion.isNewUI()) {
            VcsLogUiProperties vcsLogUiProperties2 = table.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperties2, (String)"getProperties(...)");
            VcsLogColorManager vcsLogColorManager = table.getColorManager();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogColorManager, (String)"getColorManager(...)");
            return new NewUiRootCellRenderer(vcsLogUiProperties2, vcsLogColorManager);
        }
        return new RootCellRenderer(table.getProperties(), table.getColorManager());
    }

    @Override
    @NotNull
    public RootCell getStubValue(@NotNull GraphTableModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Collection<VirtualFile> collection = model.getLogData().getRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRoots(...)");
        return new RootCell.RealCommit(VcsUtil.getFilePath((VirtualFile)((VirtualFile)CollectionsKt.first((Iterable)collection))));
    }

    @NotNull
    public String toString() {
        return "Root";
    }

    public int hashCode() {
        return -318006916;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Root)) {
            return false;
        }
        Root cfr_ignored_0 = (Root)other;
        return true;
    }

    private static final Unit createTableCellRenderer$lambda$0(VcsLogGraphTable $table, VcsLogUiProperties.VcsLogUiProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (Intrinsics.areEqual(CommonUiProperties.SHOW_ROOT_NAMES, (Object)property)) {
            $table.rootColumnUpdated();
        }
        return Unit.INSTANCE;
    }
}

